/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.DataElements;

import com.sos.JSHelper.DataElements.JSDataElement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class JSDataElementDateTime
extends JSDataElement {
    protected Date dteDateTime = new Date();
    private String strDateFormat = "yyyy.MM.dd HH:mm:ss";
    private String strTimestamp = null;
    private SimpleDateFormat dateFormatter = null;
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd";
    public static final String FULL_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public JSDataElementDateTime() {
    }

    public JSDataElementDateTime(Date pdteDateTime) {
        this.dteDateTime = pdteDateTime;
    }

    public JSDataElementDateTime(String pstrValue) {
        super(pstrValue);
        this.string2Date(pstrValue);
    }

    public JSDataElementDateTime(String pPstrValue, String pPstrDescription) {
        super(pPstrValue, pPstrDescription);
    }

    private void string2Date(String pstrDateTime) {
        DateFormat objDF = DateFormat.getDateTimeInstance();
        try {
            this.dteDateTime = objDF.parse(pstrDateTime);
        }
        catch (Exception objException) {
            super.setValue("");
            this.dteDateTime = null;
        }
    }

    @Override
    public void doInit() {
        super.setFormatString(this.strDateFormat);
        super.description("DateAndTime");
        super.columnHeader("DateTime");
        super.xmlTagName("DateTime");
    }

    @Override
    public void setValue(String pstrDateTime) {
        this.string2Date(pstrDateTime);
        super.setValue(pstrDateTime);
    }

    public void setValue(Date pdteDateTime) {
        this.dteDateTime = pdteDateTime;
        super.setValue(this.getFormattedValue());
    }

    public Date value() {
        return this.dteDateTime;
    }

    @Override
    public String getFormattedValue() {
        if (this.dteDateTime == null) {
            this.strTimestamp = "";
        } else {
            if (this.isEmpty(this.getFormatString())) {
                this.setFormatString(FULL_DATETIME_FORMAT);
            }
            this.dateFormatter = new SimpleDateFormat(this.getFormatString());
            this.strTimestamp = this.dateFormatter.format(this.dteDateTime);
        }
        return this.strTimestamp;
    }

    public Date getActualDateTime() {
        return Calendar.getInstance().getTime();
    }
}

