/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Basics.JSToolBox;
import com.sos.JSHelper.Exceptions.JSExceptionMandatoryOptionMissing;
import com.sos.JSHelper.Options.ISOSOptions;
import com.sos.JSHelper.Options.IValueChangedListener;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.interfaces.IAutoCompleteProposal;
import com.sos.i18n.annotation.I18NResourceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="com_sos_JSHelper_Messages", defaultLocale="en")
public class SOSOptionElement
extends JSToolBox
implements Serializable,
ISOSOptions,
IAutoCompleteProposal {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSOptionElement.class);
    public static boolean gflgProcessHashMap = true;
    public static boolean gflgCreateShortXML = false;
    public static final int isOptionTypeOptions = 4;
    public static boolean flgShowPasswords = false;
    public final String ControlType = "text";
    public IValueChangedListener objParentControl = null;
    protected static final int isOptionTypeString = 0;
    protected static final int isOptionTypeBoolean = 1;
    protected static final int isOptionTypeFileName = 2;
    protected static final int isOptionTypeInteger = 3;
    protected static final int isOptionTypeFolder = 5;
    protected JSOptionsClass objParentClass = null;
    protected JSOptionsClass objOptions = null;
    protected Vector<String> objAliase = new Vector();
    protected Vector<Object> objObjectStore = new Vector();
    protected String strKey = "";
    protected String strValue = "";
    protected int intOptionType = 0;
    protected boolean flgValue = false;
    private static boolean flgIncludeProcessingInProgress = false;
    private static final String constPrefixForEnviromentVariables = "env:";
    private static final long serialVersionUID = -7652466722187678671L;
    private static final HashMap<String, String> defaultProposals = new HashMap();
    private static final String conNullButMandatory = "JSO-D-0011";
    private Stack<String> objValueStack = null;
    private ArrayList<IValueChangedListener> lstValueChangedListeners = null;
    private String strDefaultValue = "";
    private String strDescription = "";
    private String strTitle = "";
    private String strColumnHeader = "";
    private String strXMLTagName = "";
    private String strFormatString = "";
    private final boolean flgSelecteDirtyOnly = true;
    private boolean flgHideValue = false;
    private boolean flgHideOption = false;
    private boolean gflgProtected = false;
    private boolean flgIsDirty = false;
    private boolean flgIsMandatory = false;
    private int intSize = 0;

    public SOSOptionElement(String pstrFolderName) {
        this.setMessageResource("com_sos_JSHelper_Messages");
        this.objParentClass = null;
        this.strKey = "";
        this.description("description");
        this.setValue(pstrFolderName);
        this.flgIsMandatory = false;
        this.flgIsDirty = false;
    }

    public SOSOptionElement(JSOptionsClass pobjParent, String pstrKey, String pstrDescription, String pstrValue, String pstrDefaultValue, boolean pflgIsMandatory) {
        try {
            this.setMessageResource("com_sos_JSHelper_Messages");
            this.objParentClass = pobjParent;
            this.strKey = pstrKey;
            this.strDefaultValue = this.getValue(pstrDefaultValue);
            this.description(pstrDescription);
            this.strTitle = pstrDescription;
            this.flgIsMandatory = pflgIsMandatory;
            this.strXMLTagName = pstrKey;
            this.strColumnHeader = pstrKey;
            this.setValue(this.getValue(pstrValue));
            this.flgIsDirty = false;
        }
        catch (Exception objException) {
            LOGGER.error(objException.toString(), (Throwable)objException);
        }
    }

    public SOSOptionElement addObject(Object objO) {
        this.getObjectStore();
        this.objObjectStore.add(objO);
        return this;
    }

    public void addValueChangedListener(IValueChangedListener pobjValueChangedListener) {
        if (this.lstValueChangedListeners == null) {
            this.lstValueChangedListeners = new ArrayList();
        }
        this.lstValueChangedListeners.add(pobjValueChangedListener);
    }

    public void removeValueChangedListener(IValueChangedListener pobjValueChangedListener) {
        if (this.lstValueChangedListeners == null) {
            this.lstValueChangedListeners = new ArrayList();
        }
        this.lstValueChangedListeners.remove(pobjValueChangedListener);
    }

    public Vector<Object> getObjectStore() {
        if (this.objObjectStore == null) {
            this.objObjectStore = new Vector();
        }
        return this.objObjectStore;
    }

    public void changeDefaults(String pstrValue, String pstrDefaultValue) {
        this.strDefaultValue = this.getValue(pstrDefaultValue);
        this.setValue(this.getValue(pstrValue));
        this.flgIsDirty = false;
    }

    public void changeDefaults(int pintValue, int pintDefaultValue) {
        this.strDefaultValue = String.valueOf(pintDefaultValue);
        this.setValue(String.valueOf(pintValue));
        this.flgIsDirty = false;
    }

    public String getToolTip() {
        String strT = this.getDescription();
        strT = strT + "\nKey=  " + this.getShortKey();
        if (!this.objAliase.isEmpty()) {
            strT = strT + ", Alias ";
            for (String strAlias : this.objAliase) {
                strT = strT + strAlias + ", ";
            }
        }
        if (this.flgIsMandatory) {
            strT = strT + "\nValue is mandatory\n";
        }
        strT = strT + "\nType = " + this.getClass().getName();
        String[] strVL = this.getValueList();
        if (strVL.length > 0) {
            strT = strT + "\nValues = " + this.getStringArrayAsTextLines(strVL);
        }
        return strT;
    }

    private String getStringArrayAsTextLines(String[] pstrV) {
        String strT = "";
        for (String string : pstrV) {
            strT = strT + "\n    " + string;
        }
        return strT;
    }

    public void checkMandatory(boolean pflgIsMandatory) {
        if (pflgIsMandatory) {
            this.flgIsMandatory = true;
            this.checkMandatory();
        }
    }

    public void checkMandatory() {
        try {
            if (this.flgIsMandatory && this.isEmpty(this.strValue)) {
                this.signalError(this.Messages.getMsg(conNullButMandatory, this.strDescription, this.strKey));
            }
        }
        catch (Exception e) {
            throw new JSExceptionMandatoryOptionMissing(e.toString());
        }
    }

    public String getColumnHeader() {
        if (this.strColumnHeader == null) {
            this.strColumnHeader = "";
        }
        return this.strColumnHeader;
    }

    public SOSOptionElement columnHeader(String pstrColumnHeader) {
        if (pstrColumnHeader != null) {
            this.strColumnHeader = pstrColumnHeader;
        }
        return this;
    }

    public String createShortXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<item ").append(" name='").append(this.getShortXMLTagName()).append("'").append(" value='").append(this.getValue().trim()).append("' ").append("/>");
        return sb.toString();
    }

    public String getDefaultValue() {
        return this.strDefaultValue;
    }

    public void setDefaultValue(String pstrValue) {
        this.strDefaultValue = pstrValue;
    }

    public String getDescription() {
        if (this.strDescription == null) {
            this.strDescription = "";
        }
        return this.strDescription;
    }

    public SOSOptionElement description(String pstrDescription) {
        if (pstrDescription != null) {
            this.strDescription = pstrDescription;
        }
        return this;
    }

    public String getDirtyToString() {
        String strR = "";
        if (!this.flgHideOption && this.isDirty()) {
            String strV = this.strValue;
            if (this.flgHideValue) {
                strV = "*****";
            }
            strR = this.getShortKey() + " = " + strV;
        }
        return strR;
    }

    protected void doInit() {
    }

    public boolean isNotEmpty() {
        return !this.IsEmpty();
    }

    public boolean equalsIgnoreCase(String strCompare) {
        if (this.strValue == null) {
            return false;
        }
        return this.strValue.equalsIgnoreCase(strCompare);
    }

    public String getControlType() {
        return "text";
    }

    public String getFormatString() {
        if (this.strFormatString == null) {
            this.strFormatString = "";
        }
        return this.strFormatString;
    }

    public void setFormatString(String pstrFormatString) {
        this.strFormatString = pstrFormatString == null ? "" : pstrFormatString;
    }

    public String getFormattedValue() throws Exception {
        return this.getValue();
    }

    public byte[] getBytes() {
        return this.strValue.getBytes();
    }

    public String getKey() {
        return this.strKey;
    }

    public String getShortKey() {
        String strT = this.strKey;
        int i = strT.indexOf(".");
        if (i > 0) {
            String strPrefix;
            strT = strT.substring(i + 1);
            if (this.objParentClass != null && this.isNotEmpty(strPrefix = this.objParentClass.getPrefix()) && !strT.startsWith(strPrefix)) {
                strT = strPrefix + "_" + strT;
            }
        }
        return strT;
    }

    public String getShortXMLTagName() {
        String strT = this.getXMLTagName();
        int i = strT.indexOf(".");
        if (i > 0) {
            strT = strT.substring(i + 1);
        }
        return strT;
    }

    public Stack<String> getStack() {
        if (this.objValueStack == null) {
            this.objValueStack = new Stack();
        }
        return this.objValueStack;
    }

    private String getValue(String pstrValue) {
        String strRet = null;
        if (pstrValue == null) {
            strRet = null;
        } else if (pstrValue.toLowerCase().startsWith(constPrefixForEnviromentVariables)) {
            String strEnvVarName = pstrValue.substring(4);
            String strEnvVarValue = this.environmentVariable(strEnvVarName);
            if (this.isEmpty(strEnvVarValue)) {
                strRet = System.getProperty(strEnvVarName);
                if (this.isEmpty(strRet)) {
                    strRet = this.strDefaultValue;
                }
            } else {
                strRet = strEnvVarValue;
            }
        } else if (pstrValue.contains("${")) {
            int iFrom = pstrValue.indexOf("${");
            int iTo = pstrValue.indexOf("}");
            if (iTo != -1) {
                String strEnvVarName = pstrValue.substring(iFrom + 2, iTo);
                String strEnvVarValue = this.environmentVariable(strEnvVarName);
                if (strEnvVarValue == null) {
                    strEnvVarValue = "";
                }
                strRet = "";
                if (iFrom > 0) {
                    strRet = pstrValue.substring(0, iFrom);
                }
                strRet = strRet + strEnvVarValue;
                strRet = strRet + pstrValue.substring(iTo + 1);
            }
        } else {
            strRet = pstrValue;
        }
        return strRet;
    }

    public boolean isDefault() {
        return this.strValue.equalsIgnoreCase(this.strDefaultValue);
    }

    public boolean isDirty() {
        return this.flgIsDirty;
    }

    public boolean IsEmpty() throws RuntimeException {
        if (this.strValue != null) {
            return this.strValue.trim().isEmpty();
        }
        return true;
    }

    public boolean isHideOption() {
        return this.flgHideOption;
    }

    public boolean isHideValue() {
        return this.flgHideValue;
    }

    public Integer getIntegerSize() {
        return new Integer(this.intSize);
    }

    public boolean isProtected() {
        return this.gflgProtected;
    }

    public SOSOptionElement setProtected(boolean pflgProtected) {
        this.gflgProtected = pflgProtected;
        return this;
    }

    public boolean isMandatory() {
        return this.flgIsMandatory;
    }

    public void isMandatory(boolean pflgIsMandatory) {
        this.flgIsMandatory = pflgIsMandatory;
    }

    public boolean isNotDirty() {
        return !this.flgIsDirty;
    }

    public boolean isNull() {
        return this.strValue == null;
    }

    public void loadValues() {
        Preferences objP = this.objParentClass.getPreferenceStore();
        if (objP != null) {
            this.setValue(objP.get(this.getKey().toLowerCase(), this.strDefaultValue));
        }
    }

    public void storeValues() {
        Preferences objP = this.objParentClass.getPreferenceStore();
        if (objP != null) {
            objP.put(this.getKey().toLowerCase(), this.getValue());
        }
    }

    public void mapValue() {
        if (!this.isEmpty(this.strKey)) {
            String value = this.objParentClass.getItem(this.strKey, null);
            if (value == null) {
                String alias;
                Iterator<String> iterator = this.objAliase.iterator();
                while (iterator.hasNext() && (value = this.objParentClass.getItem(alias = iterator.next(), null)) == null) {
                }
            }
            if (value == null) {
                value = this.strDefaultValue;
            } else {
                this.setValue(value);
                this.setProtected(flgIncludeProcessingInProgress);
            }
            if (this.intOptionType == 4) {
                this.setValue(this.objParentClass.getIndexedItem(this.strKey, this.getDescription(), ";"));
            }
        }
    }

    public String getOptionalQuotedValue() {
        String strR = this.strValue;
        if (strR.indexOf(" ") > -1) {
            strR = this.getQuotedValue(strR);
        }
        return strR;
    }

    public int getOptionType() {
        return this.intOptionType;
    }

    public void setOptionType(int pintOptionType) {
        this.intOptionType = pintOptionType;
    }

    public void pop() {
        this.setValue(this.getStack().pop());
    }

    public void push() {
        this.getStack().push(this.strValue);
    }

    public String getQuotedValue() {
        return this.getQuotedValue(this.strValue);
    }

    public String getQuotedValue(String pstrValue) {
        return "\"" + pstrValue.replaceAll("\"", "\"\"") + "\"";
    }

    private void raiseValueChangedListener() {
        if (this.lstValueChangedListeners != null) {
            for (IValueChangedListener objValueChangedListener : this.lstValueChangedListeners) {
                objValueChangedListener.valueHasChanged(this);
            }
        }
    }

    public void set(SOSOptionElement pobjOption) {
        if (pobjOption.isDirty()) {
            this.setValue(pobjOption.getValue());
            this.setProtected(pobjOption.isProtected());
        }
    }

    public void setIfNotDirty(SOSOptionElement pobjOption) {
        if (!this.isDirty()) {
            this.set(pobjOption);
        }
    }

    public SOSOptionElement setAlias(String pstrAliasKey) {
        this.objAliase.add(pstrAliasKey);
        return this;
    }

    public SOSOptionElement setAlias(String ... pstrAliasKey) {
        for (String string : pstrAliasKey) {
            this.objAliase.add(string);
        }
        return this;
    }

    public void setDirty() {
        this.flgIsDirty = true;
    }

    public void setHideOption(boolean hideOption) {
        this.flgHideOption = hideOption;
    }

    public void setHideValue(boolean hideValue) {
        this.flgHideValue = hideValue;
    }

    public void setNotDirty() {
        this.flgIsDirty = false;
    }

    public void setNull() {
        this.strValue = null;
    }

    public String setPrefix(String prefix) {
        String key = this.strKey;
        int i = key.indexOf(".");
        key = i > 0 ? key.replaceFirst("\\.", "." + prefix) : prefix + key;
        this.strKey = key;
        return this.strKey;
    }

    public int getIntSize() {
        return this.intSize;
    }

    public SOSOptionElement setIntSize(int pintSize) {
        this.intSize = pintSize;
        return this;
    }

    public SOSOptionElement size(Integer pintSize) {
        this.intSize = pintSize;
        return this;
    }

    public boolean string2Bool() {
        boolean flgT = false;
        String pstrVal = this.strValue;
        if (this.isNotEmpty(pstrVal) && ("1".equals(pstrVal) || "y".equalsIgnoreCase(pstrVal) || "yes".equalsIgnoreCase(pstrVal) || "j".equalsIgnoreCase(pstrVal) || "on".equalsIgnoreCase(pstrVal) || "true".equalsIgnoreCase(pstrVal) || "wahr".equalsIgnoreCase(pstrVal))) {
            flgT = true;
        }
        return flgT;
    }

    @Override
    public String stripQuotes(String pstrS) {
        String strR = pstrS;
        if ("\"".equals(pstrS.substring(0, 1)) && "\"".equals(pstrS.substring(pstrS.length() - 1))) {
            strR = pstrS.substring(1, pstrS.length() - 1);
        }
        return strR;
    }

    public String getTitle() {
        if (this.strTitle == null) {
            this.strTitle = "";
        }
        return this.strTitle;
    }

    public String toKeyValuePair(String pstrAlternatePrefix) {
        String strRet = "";
        if (this.isDirty() && this.isNotEmpty()) {
            if (this.isNotEmpty(pstrAlternatePrefix)) {
                strRet = pstrAlternatePrefix + "_";
            }
            strRet = strRet + this.getShortKey() + "=" + this.strValue;
        }
        return strRet;
    }

    public String toCommandLine() {
        String strRet = "";
        if (this.isNotEmpty() && this.isDirty() && (this.isMandatory() || !this.isDefault())) {
            strRet = "-" + this.getShortKey() + "=" + this.getOptionalQuotedValue() + " ";
        }
        return strRet;
    }

    public String toQuotedCommandLine() {
        String strRet = "";
        if (this.isNotEmpty() && this.isDirty() && (this.isMandatory() || !this.isDefault())) {
            strRet = "-" + this.getShortKey() + "=" + this.getQuotedValue() + " ";
        }
        return strRet;
    }

    public String toString() {
        String strR = "";
        if (!this.flgHideOption) {
            String strV = this.strValue;
            if (this.flgHideValue) {
                strV = "*****";
            }
            strR = this.strKey + " (" + this.strDescription + "): " + strV;
        }
        return strR;
    }

    public String getValue() throws RuntimeException {
        if (this.strValue == null) {
            this.strValue = "";
        }
        return this.strValue;
    }

    @Override
    public void setValue(String pstrValue) {
        if (this.flgIsMandatory && pstrValue == null && gflgProcessHashMap) {
            return;
        }
        if (pstrValue != null) {
            if (this.objParentClass != null) {
                Properties objP = this.objParentClass.getTextProperties();
                objP.put(this.getShortKey(), pstrValue);
            }
            this.changeValue(pstrValue);
            this.addProposal(pstrValue);
        } else {
            this.changeValue("");
        }
    }

    private void changeValue(String pstrValue) {
        this.strValue = pstrValue;
        this.setDirty();
        this.raiseValueChangedListener();
    }

    public String getXMLTagName() {
        if (this.strXMLTagName == null) {
            this.strXMLTagName = "";
        }
        return this.strXMLTagName;
    }

    private String[] getValueList() {
        return new String[0];
    }

    @Override
    public void addProposal(String pstrProposal) {
        if (pstrProposal != null && !pstrProposal.trim().isEmpty()) {
            defaultProposals.put(pstrProposal, pstrProposal);
        }
    }

    @Override
    public String[] getAllProposals(String text) {
        String[] proposals = defaultProposals.keySet().toArray(new String[0]);
        return proposals;
    }
}

