/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionFileName;
import com.sos.JSHelper.io.Files.JSFolder;
import java.io.File;
import java.util.HashMap;

public class SOSOptionFolderName
extends SOSOptionFileName {
    private static final long serialVersionUID = 1197392401084895147L;
    private static final HashMap<String, String> DEFAULT_PROPOSALS = new HashMap();

    public SOSOptionFolderName(String name) {
        super(null, "", "description", name, "", false);
    }

    public SOSOptionFolderName(JSOptionsClass parent, String key, String description, String value, String defaultValue, boolean isMandatory) {
        super(parent, key, description, value, defaultValue, isMandatory);
        this.intOptionType = 5;
    }

    @Override
    public String getValue() {
        if (this.strValue == null) {
            this.strValue = "";
        }
        String value = super.getValue();
        if (this.isNotEmpty() && !value.endsWith("/") && !value.endsWith("\\") && !this.isDotFolder()) {
            value = value + "/";
        }
        return value;
    }

    public boolean isDotFolder() {
        String val = super.getValue();
        return ".".equals(val) || "..".equals(val);
    }

    public File[] listFiles() {
        File[] list = this.getJSFile().listFiles();
        if (list == null) {
            throw new JobSchedulerException(String.format("No Files found for pathname '%1$s'", this.strValue));
        }
        return list;
    }

    public String[] getSubFolderArray() {
        String[] result = null;
        try {
            String path = this.strValue.trim().replaceAll("/(\\s*/)+", "/");
            String slash = "";
            int iStart = 0;
            if (path.startsWith("/")) {
                slash = "/";
                iStart = 1;
            }
            String[] arr = path.substring(iStart).split("/");
            result = new String[arr.length];
            int i = 0;
            StringBuilder sb = new StringBuilder();
            for (String subFolder : arr) {
                sb.append(slash).append(subFolder);
                slash = "/";
                result[i] = sb.toString();
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String[] getSubFolderArrayReverse() {
        String[] result = null;
        try {
            String path = this.strValue.trim().replaceAll("/(\\s*/)+", "/");
            String slash = "";
            int iStart = 0;
            if (path.startsWith("/")) {
                slash = "/";
                iStart = 1;
            }
            String[] arr = path.substring(iStart).split("/");
            result = new String[arr.length];
            int i = arr.length - 1;
            StringBuilder sb = new StringBuilder();
            for (String subFolder : arr) {
                sb.append(slash).append(subFolder);
                slash = "/";
                result[i] = sb.toString();
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public JSFolder getFolder() {
        return new JSFolder(this.strValue);
    }

    @Override
    public void addProposal(String proposal) {
        if (proposal != null && !proposal.trim().isEmpty()) {
            String p = proposal.trim();
            DEFAULT_PROPOSALS.put(p, p);
        }
    }

    @Override
    public String[] getAllProposals(String text) {
        return DEFAULT_PROPOSALS.keySet().toArray(new String[0]);
    }
}

