/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.DataElements.JSDataElementDate;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionStringWVariables;
import com.sos.JSHelper.Options.SOSValidationError;
import com.sos.i18n.annotation.I18NResourceBundle;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="com_sos_JSHelper_Messages", defaultLocale="en")
public class SOSOptionRegExp
extends SOSOptionStringWVariables {
    private static final long serialVersionUID = 8393808803161272343L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSOptionRegExp.class);
    private static final HashMap<String, String> defaultProposals = new HashMap();
    private Pattern objCurrentPattern = null;
    private int intRegExpFlags = 2;
    private Matcher matcher = null;
    private String strMatchValue = "";
    private Vector<String> lstMatchValues = null;
    public static final String strCaseInsensitive = "(?i)";

    public SOSOptionRegExp(JSOptionsClass pPobjParent, String pPstrKey, String pPstrDescription, String pPstrValue, String pPstrDefaultValue, boolean pPflgIsMandatory) {
        super(pPobjParent, pPstrKey, pPstrDescription, pPstrValue, pPstrDefaultValue, pPflgIsMandatory);
    }

    public SOSOptionRegExp(String pstrRegExp) {
        super(null, "", "", pstrRegExp, "", false);
    }

    public int getRegExpFlags() {
        return this.intRegExpFlags;
    }

    public void setRegExpFlags(int pintRegExpFlags) {
        this.intRegExpFlags = pintRegExpFlags;
    }

    public String getRegExpFlagsText() {
        String msg = "";
        if (this.has(this.intRegExpFlags, 128)) {
            msg = msg + "CANON_EQ ";
        }
        if (this.has(this.intRegExpFlags, 2)) {
            msg = msg + "CASE_INSENSITIVE ";
        }
        if (this.has(this.intRegExpFlags, 4)) {
            msg = msg + "COMMENTS ";
        }
        if (this.has(this.intRegExpFlags, 32)) {
            msg = msg + "DOTALL ";
        }
        if (this.has(this.intRegExpFlags, 8)) {
            msg = msg + "MULTILINE ";
        }
        if (this.has(this.intRegExpFlags, 64)) {
            msg = msg + "UNICODE_CASE ";
        }
        if (this.has(this.intRegExpFlags, 1)) {
            msg = msg + "UNIX_LINES";
        }
        return msg;
    }

    private boolean has(int flags, int f) {
        return (flags & f) > 0;
    }

    public String doReplace(String pstrSourceString, String pstrReplacementPattern) throws Exception {
        String methodName = "SOSOptionRegExp::doReplace";
        String strTargetString = pstrSourceString;
        try {
            strTargetString = this.replaceGroups(strTargetString, pstrReplacementPattern);
            strTargetString = this.substituteAllDate(strTargetString);
            strTargetString = this.substituteAllFilename(strTargetString, pstrSourceString);
            strTargetString = this.substituteTimeStamp(strTargetString);
            strTargetString = this.substituteUUID(strTargetString);
            strTargetString = this.substituteSQLTimeStamp(strTargetString);
            Matcher m = Pattern.compile("\\[[^\\]]*\\]").matcher(strTargetString);
            if (m.find()) {
                throw new JobSchedulerException(String.format("unsupported variable found: ' %1$s'", m.group()));
            }
            return strTargetString;
        }
        catch (Exception e) {
            throw new JobSchedulerException("SOSOptionRegExp::doReplace: " + e.getMessage(), e);
        }
    }

    public String replaceGroups(String pstrSourceString, String replacement) throws Exception {
        String result = "";
        if (replacement == null) {
            throw new JobSchedulerException("replacements missing: 0 replacements defined");
        }
        Pattern p = Pattern.compile(this.strValue, this.intRegExpFlags);
        Matcher m = p.matcher(pstrSourceString);
        if (!m.find()) {
            return pstrSourceString;
        }
        String[] replacements = replacement.split(";");
        int intGroupCount = m.groupCount();
        if (intGroupCount == 0) {
            result = pstrSourceString.substring(0, m.start()) + replacements[0] + pstrSourceString.substring(m.end());
        } else {
            int index = 0;
            for (int i = 1; i <= intGroupCount; ++i) {
                String strRepl;
                int intStart = m.start(i);
                if (intStart >= 0 && i <= replacements.length && !(strRepl = replacements[i - 1].trim()).isEmpty()) {
                    if (strRepl.contains("\\")) {
                        strRepl = strRepl.replaceAll("\\\\-", "");
                        for (int j = 1; j <= intGroupCount; ++j) {
                            strRepl = strRepl.replaceAll("\\\\" + j, m.group(j));
                        }
                    }
                    result = result + pstrSourceString.substring(index, intStart) + strRepl;
                }
                index = m.end(i);
            }
            result = result + pstrSourceString.substring(index);
        }
        return result;
    }

    public String doRegExpReplace(String pstrSourceString, String pstrReplacementPattern) throws Exception {
        String methodName = "SOSOptionRegExp::doRegExpReplace";
        String strTargetString = pstrSourceString;
        try {
            Pattern pattern = Pattern.compile(this.strValue);
            Matcher matcher1 = pattern.matcher(pstrSourceString);
            strTargetString = matcher1.replaceAll(pstrReplacementPattern);
            strTargetString = this.substituteAllDate(strTargetString);
            strTargetString = this.substituteAllFilename(strTargetString, pstrSourceString);
            return strTargetString;
        }
        catch (Exception e) {
            throw new JobSchedulerException("SOSOptionRegExp::doRegExpReplace: " + e.getMessage(), e);
        }
    }

    public String substituteAllDate(String targetFilename) throws Exception {
        String temp = this.substituteFirstDate(targetFilename);
        while (!targetFilename.equals(temp)) {
            targetFilename = temp;
            temp = this.substituteFirstDate(targetFilename);
        }
        return temp;
    }

    private String substituteFirstDate(String targetFilename) throws Exception {
        String conVarName = "[date:";
        try {
            int posEnd;
            int posBegin;
            if (targetFilename.matches("(.*)(\\[date:)([^\\]]*)(\\])(.*)") && (posBegin = targetFilename.indexOf("[date:")) > -1 && (posEnd = targetFilename.indexOf("]", posBegin + 6)) > -1) {
                String strDateMask = targetFilename.substring(posBegin + 6, posEnd);
                String strDateTime = JSDataElementDate.getCurrentTimeAsString(strDateMask);
                String strT = (posBegin > 0 ? targetFilename.substring(0, posBegin) : "") + strDateTime;
                if (targetFilename.length() > posEnd) {
                    strT = strT + targetFilename.substring(posEnd + 1);
                }
                targetFilename = strT;
            }
            return targetFilename;
        }
        catch (Exception e) {
            throw new JobSchedulerException("error substituting [date:]: " + e.getMessage(), e);
        }
    }

    public String substituteAllFilename(String targetFilename, String original) throws Exception {
        String temp = this.substituteFirstFilename(targetFilename, original);
        while (!targetFilename.equals(temp)) {
            targetFilename = temp;
            temp = this.substituteFirstFilename(targetFilename, original);
        }
        return temp;
    }

    private String substituteUUID(String strValue) throws Exception {
        Matcher matcher1 = Pattern.compile("\\[uuid:([^\\]]*)\\]", this.intRegExpFlags).matcher(strValue);
        if (matcher1.find() && "".equals(matcher1.group(1))) {
            strValue = strValue.replaceFirst("\\[uuid:\\]", SOSOptionRegExp.getUUID());
        }
        return strValue;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    private String substituteTimeStamp(String pstrValue) throws Exception {
        Matcher matcher1 = Pattern.compile("\\[timestamp:([^\\]]*)\\]", this.intRegExpFlags).matcher(pstrValue);
        if (matcher1.find() && "".equals(matcher1.group(1))) {
            pstrValue = pstrValue.replaceFirst("\\[timestamp:\\]", SOSOptionRegExp.getUnixTimeStamp());
        }
        return pstrValue;
    }

    public static String getUnixTimeStamp() {
        return String.valueOf(System.nanoTime());
    }

    private String substituteSQLTimeStamp(String strValue) throws Exception {
        Matcher matcher1 = Pattern.compile("\\[sqltimestamp:([^\\]]*)\\]", this.intRegExpFlags).matcher(strValue);
        if (matcher1.find() && "".equals(matcher1.group(1))) {
            strValue = strValue.replaceFirst("\\[sqltimestamp:\\]", new Timestamp(new Date().getTime()).toString());
        }
        return strValue;
    }

    public static String getSqlTimeStamp() {
        return new Timestamp(new Date().getTime()).toString();
    }

    private String substituteFirstFilename(String targetFilename, String original) throws Exception {
        Matcher matcher1 = Pattern.compile("\\[filename:([^\\]]*)\\]", this.intRegExpFlags).matcher(targetFilename);
        if (matcher1.find()) {
            if ("".equals(matcher1.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:\\]", original);
            } else if ("lowercase".equals(matcher1.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:lowercase\\]", original.toLowerCase());
            } else if ("uppercase".equals(matcher1.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:uppercase\\]", original.toUpperCase());
            }
        }
        return targetFilename;
    }

    public Pattern getPattern(String pstrValue) {
        this.strValue = pstrValue;
        return this.getPattern();
    }

    public Pattern getPattern() {
        Pattern p = null;
        try {
            p = Pattern.compile(this.strValue, this.intRegExpFlags);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.objCurrentPattern = p;
        return p;
    }

    public void addValue(String pstrValue4Matching) {
        if (this.lstMatchValues == null) {
            this.lstMatchValues = new Vector();
        }
        this.lstMatchValues.add(pstrValue4Matching);
    }

    public boolean match(String pstrValue4Matching) {
        this.strMatchValue = "";
        if (this.objCurrentPattern == null) {
            this.getPattern();
        }
        boolean flgFound = false;
        this.matcher = this.objCurrentPattern.matcher(pstrValue4Matching);
        if (this.matcher.find()) {
            flgFound = true;
            this.strMatchValue = pstrValue4Matching;
        }
        if (!flgFound && this.lstMatchValues != null) {
            for (String strValue4Matching : this.lstMatchValues) {
                Pattern p = Pattern.compile(strValue4Matching, this.intRegExpFlags);
                this.matcher = this.objCurrentPattern.matcher(pstrValue4Matching);
                if (!this.matcher.find()) continue;
                flgFound = true;
                this.strMatchValue = pstrValue4Matching;
                break;
            }
        }
        return flgFound;
    }

    public String getGroup(int pintGroupNo) {
        String strRetVal = null;
        this.match(this.strMatchValue);
        if (this.matcher != null) {
            strRetVal = this.matcher.group(pintGroupNo);
        }
        return strRetVal;
    }

    @Override
    public void setValue(String pstrValue) {
        super.setValue(pstrValue);
        if (this.isNotEmpty(this.strValue)) {
            try {
                Pattern.compile(this.strValue);
            }
            catch (PatternSyntaxException exception) {
                String strT = String.format("The RegExp '%1$s' is invalid", this.strValue);
                SOSValidationError objVE = new SOSValidationError(strT);
                objVE.setException(new JobSchedulerException(strT, exception));
            }
        }
    }

    @Override
    public void addProposal(String pstrProposal) {
        if (pstrProposal != null && !pstrProposal.trim().isEmpty()) {
            defaultProposals.put(pstrProposal, pstrProposal);
        }
    }

    @Override
    public String[] getAllProposals(String text) {
        String[] proposals = defaultProposals.keySet().toArray(new String[0]);
        return proposals;
    }
}

