/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionString;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class SOSOptionTime
extends SOSOptionString {
    private static final long serialVersionUID = 6687670638160800096L;
    public final String ControlType = "timetext";
    public static String dateTimeFormat = new String("yyyy-MM-dd HH:mm:ss");
    private String strDefaultUoM = "";
    private long lngValue = 0L;

    public SOSOptionTime(JSOptionsClass pPobjParent, String pPstrKey, String pPstrDescription, String pPstrValue, String pPstrDefaultValue, boolean pPflgIsMandatory) {
        super(pPobjParent, pPstrKey, pPstrDescription, pPstrValue, pPstrDefaultValue, pPflgIsMandatory);
    }

    public SOSOptionTime(String pPstrValue) {
        this(null, "", "", pPstrValue, pPstrValue, false);
    }

    public static String getCurrentTimeAsString() {
        String strT = "n.a.";
        try {
            strT = SOSOptionTime.getCurrentTimeAsString(dateTimeFormat);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strT;
    }

    public static String getCurrentTimeAsString(String pstrDateTimeFormat) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat(pstrDateTimeFormat);
        formatter.setLenient(true);
        Calendar now = Calendar.getInstance();
        return formatter.format(now.getTime());
    }

    public static String getCurrentDateAsString() throws Exception {
        return SOSOptionTime.getCurrentDateAsString("yyyy-MM-dd");
    }

    public static String getCurrentDateAsString(String pstrDateFormatMask) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat(pstrDateFormatMask);
        formatter.setLenient(true);
        Calendar now = Calendar.getInstance();
        return formatter.format(now.getTime());
    }

    public void value(long plngValue) {
        this.lngValue = plngValue;
    }

    public void value(int pintValue) {
        this.lngValue = pintValue;
    }

    @Override
    public void setValue(String pstrValue) {
        super.setValue(pstrValue);
        this.strValue = this.adjust2TimeFormat();
    }

    public int value() {
        return this.getTimeAsSeconds();
    }

    public long getTimeAsMilliSeconds() {
        return (long)this.getTimeAsSeconds() * 1000L;
    }

    public int getTimeAsSeconds() {
        int intSeconds = 0;
        if (this.lngValue != 0L) {
            intSeconds = (int)this.lngValue;
        } else {
            int[] intM = new int[]{1, 60, 3600, 86400};
            String[] strT = this.strValue.split(":");
            int j = 0;
            for (int i = strT.length - 1; i >= 0; --i) {
                intSeconds += new Integer(strT[i]) * intM[j++];
            }
        }
        return intSeconds;
    }

    public long calculateFileAge() {
        long age = 0L;
        if (this.isNotEmpty(this.strValue)) {
            if (this.strValue.indexOf(":") > -1) {
                String[] timeArray = this.strValue.split(":");
                long hours = Long.parseLong(timeArray[0]);
                long minutes = Long.parseLong(timeArray[1]);
                long seconds = 0L;
                if (timeArray.length > 2) {
                    seconds = Long.parseLong(timeArray[2]);
                }
                age = hours * 3600000L + minutes * 60000L + seconds * 1000L;
            } else {
                age = Long.parseLong(this.strValue) * 1000L;
            }
        }
        return age;
    }

    public String getTimeAsString(long lngValue) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(lngValue);
    }

    public String adjust2TimeFormat() {
        if (this.isNotEmpty(this.strValue)) {
            if (this.strValue.indexOf(":") <= -1 && this.isNotEmpty(this.strDefaultUoM)) {
                this.strValue = this.strValue + this.strDefaultUoM;
            }
            int intL = this.strValue.length();
            if (!"0".equals(this.strValue)) {
                String strT = this.strValue.substring(intL - 1, intL).toLowerCase();
                String strN = this.strValue.substring(0, intL - 1);
                switch (strT) {
                    case "w": {
                        int intW = new Integer(strN);
                        this.strValue = intW * 7 + ":00:00:00";
                        break;
                    }
                    case "d": {
                        this.strValue = strN + ":00:00:00";
                        break;
                    }
                    case "h": {
                        this.strValue = strN + ":00:00";
                        break;
                    }
                    case "m": {
                        this.strValue = strN + ":00";
                        break;
                    }
                    case "s": {
                        this.strValue = strN;
                        break;
                    }
                }
            }
        }
        return this.strValue;
    }

    public String getDefaultUoM() {
        return this.strDefaultUoM;
    }

    public void setDefaultUoM(String defaultUoM) {
        this.strDefaultUoM = defaultUoM.toLowerCase();
        if (this.isNotEmpty(defaultUoM)) {
            this.adjust2TimeFormat();
        }
    }
}

