/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionElement;
import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.JSHelper.interfaces.ISOSDataProviderOptions;
import com.sos.JSHelper.interfaces.ISOSTransferOptions;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSOptionUrl
extends SOSOptionString {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSOptionUrl.class);
    private static final long serialVersionUID = 4655546707861016058L;
    private URL objURL = null;

    public SOSOptionUrl(JSOptionsClass pPobjParent, String pPstrKey, String pPstrDescription, String pPstrValue, String pPstrDefaultValue, boolean pPflgIsMandatory) {
        super(pPobjParent, pPstrKey, pPstrDescription, pPstrValue, pPstrDefaultValue, pPflgIsMandatory);
    }

    public SOSOptionUrl(String pstrUrl) {
        super(null, "", "", pstrUrl, "", false);
    }

    public URL getUrl() {
        return this.objURL;
    }

    @Override
    public void setValue(String pstrUrl) {
        if (this.isNotEmpty(pstrUrl)) {
            String strUrl = pstrUrl;
            try {
                this.objURL = new URL(strUrl);
                super.setValue(pstrUrl);
            }
            catch (MalformedURLException e) {
                throw new JobSchedulerException(String.format("invalid url '%1$s' specified", pstrUrl), e);
            }
        }
    }

    public void getOptions(ISOSDataProviderOptions pobjO) {
        if (this.objURL == null) {
            throw new JobSchedulerException("no URL speficied");
        }
        this.setIfNotDirty(pobjO.getHost(), this.objURL.getHost());
        String strPort = String.valueOf(this.objURL.getPort());
        if (this.isEmpty(strPort) || "-1".equals(strPort)) {
            strPort = String.valueOf(this.objURL.getDefaultPort());
        }
        this.setIfNotDirty(pobjO.getPort(), strPort);
        pobjO.getProtocol().setValue(this.objURL.getProtocol());
        String strUserInfo = this.objURL.getUserInfo();
        String[] strU = strUserInfo.split(":");
        this.setIfNotDirty(pobjO.getUser(), strU[0]);
        if (strU.length > 1) {
            this.setIfNotDirty(pobjO.getPassword(), strU[1]);
        }
    }

    public void getJadeOptions(ISOSTransferOptions pobjO) {
        if (this.objURL == null) {
            throw new JobSchedulerException("no URL speficied");
        }
        String strPath = this.objURL.getPath();
        String strAuthority = this.objURL.getAuthority();
        String[] strA = strAuthority.split("@");
    }

    public String getFolderName() {
        if (this.objURL == null) {
            throw new JobSchedulerException("no URL speficied");
        }
        String strPath = this.objURL.getPath();
        return strPath;
    }

    private void setIfNotDirty(SOSOptionElement objOption, String pstrValue) {
        if (objOption.isNotDirty() && this.isNotEmpty(pstrValue)) {
            LOGGER.trace("setValue = " + pstrValue);
            objOption.setValue(pstrValue);
        }
    }
}

