/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.System;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerShell {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerShell.class);
    private static final int GARBAGE_INTERVAL = 60000;
    private static File powershell = null;
    private final Process process;
    private final PipedOutputStream outputPipe;
    private Thread inputThread;
    private Thread shutdownThread;
    private Timer garbageTimer;
    private File source;
    private PrintWriter sourceWriter;
    private PipedInputStream inputPipe;

    public PowerShell() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        this.source = File.createTempFile(PowerShell.class.getSimpleName() + "Source", ".ps1");
        this.process = runtime.exec("PowerShell -NoLogo -File " + powershell.getAbsolutePath() + " -Source " + this.source);
        this.source.deleteOnExit();
        this.sourceWriter = new PrintWriter(this.source);
        this.shutdownThread = new Thread(){

            @Override
            public void run() {
                PowerShell.this.detatch();
            }
        };
        runtime.addShutdownHook(this.shutdownThread);
        this.inputPipe = new PipedInputStream();
        this.outputPipe = new PipedOutputStream(this.inputPipe);
        this.inputThread = new Thread(PowerShell.class.getSimpleName() + "Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream stream = null;
                try {
                    int length;
                    stream = PowerShell.this.process.getInputStream();
                    byte[] buffer = new byte[128];
                    while ((length = stream.read(buffer)) != -1) {
                        PowerShell.this.outputPipe.write(buffer, 0, length);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    PowerShell.this.detatch();
                }
            }
        };
        this.inputThread.start();
        this.garbageTimer = new Timer(PowerShell.class.getSimpleName() + "GarbageTimer", true);
        this.garbageTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (PowerShell.this.isDetatched()) {
                    this.cancel();
                } else if (PowerShell.this.source.length() > 131072L) {
                    PowerShell.this.reattach();
                }
            }
        }, 60000L, 60000L);
    }

    public InputStream getInputStream() {
        return this.inputPipe;
    }

    public synchronized void execute(String command) throws IOException {
        if (this.isDetatched()) {
            return;
        }
        this.sourceWriter.println(command);
        if (this.sourceWriter.checkError()) {
            throw new IOException();
        }
    }

    protected synchronized void reattach() {
        try {
            File newSource = File.createTempFile(PowerShell.class.getSimpleName() + "Source", ".ps1");
            this.sourceWriter.println(". JavaInitialize(\"" + newSource.getAbsolutePath() + "\")");
            this.sourceWriter.close();
            this.source = newSource;
            this.sourceWriter = new PrintWriter(this.source);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void detatch() {
        this.garbageTimer.cancel();
        Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        this.sourceWriter.close();
        try {
            this.process.destroy();
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.source.delete();
        try {
            this.outputPipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isDetatched() {
        return !this.inputThread.isAlive() || !this.source.exists();
    }

    public static void main(String[] args) throws IOException {
        PowerShell powershell = new PowerShell();
        while (true) {
            try {
                while (true) {
                    powershell.execute("[console]::beep(500,300)");
                    Thread.sleep(1000L);
                }
            }
            catch (IOException | InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    static {
        try {
            powershell = File.createTempFile(PowerShell.class.getSimpleName(), ".ps1");
            powershell.deleteOnExit();
            Files.copy(PowerShell.class.getResourceAsStream("PowerShell.ps1"), powershell.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | NullPointerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

