/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.io.Files;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionRegExp;
import com.sos.JSHelper.io.Files.JSFile;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSFolder
extends File {
    private static final long serialVersionUID = -4423886110579623387L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSFolder.class);
    private static final long UNDEFINED = -1L;
    private String strFolderName = "";
    public long IncludeOlderThan = -1L;
    public long IncludeNewerThan = -1L;
    public int intNoOfObjectsDeleted = 0;

    public JSFolder(String pathname) {
        super(pathname);
        this.init();
    }

    private boolean checkMoreFilter(JSFile pfleFile) {
        boolean flgR = true;
        if (this.IncludeOlderThan != -1L && flgR) {
            flgR = pfleFile.isOlderThan(this.IncludeOlderThan);
        } else if (this.IncludeNewerThan != -1L && flgR) {
            flgR = !pfleFile.isOlderThan(this.IncludeNewerThan);
        }
        return flgR;
    }

    public String getFolderName() {
        return this.strFolderName;
    }

    public String addFileSeparator(String str) {
        return str.endsWith("/") || str.endsWith("\\") ? str : str + "/";
    }

    private void init() {
        this.strFolderName = this.addFileSeparator(this.getAbsolutePath());
    }

    public JSFolder(URI uri) {
        super(uri);
        this.init();
    }

    public JSFolder(String parent, String child) {
        super(parent, child);
        this.init();
    }

    public JSFolder(File parent, String child) {
        super(parent, child);
        this.init();
    }

    public Vector<JSFile> getFilelist(String regexp, int flag) {
        if (!this.exists()) {
            throw new JobSchedulerException(String.format("directory does not exist: %1$s", this.getAbsolutePath()));
        }
        LOGGER.debug("regexp for filelist: " + regexp);
        Vector<JSFile> filelist = new Vector<JSFile>();
        try {
            for (File file : this.listFiles(new SOSFilelistFilter(regexp, flag))) {
                if (!file.isFile()) continue;
                filelist.add(new JSFile(file.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(e);
        }
        return filelist;
    }

    public Vector<JSFolder> getFolderlist(String regexp, int intRegExpOptions) {
        if (!this.exists()) {
            throw new JobSchedulerException(String.format("directory does not exist: %1$s", this.getAbsolutePath()));
        }
        Vector<JSFolder> objFolderList = new Vector<JSFolder>();
        try {
            for (File file : this.listFiles(new SOSFilelistFilter(regexp, intRegExpOptions))) {
                if (!file.isDirectory()) continue;
                objFolderList.add(new JSFolder(file.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(e);
        }
        return objFolderList;
    }

    public JSFile getNewFile(String pstrFileName) {
        return new JSFile(this.strFolderName + pstrFileName);
    }

    public static final JSFolder getTempDir() {
        return new JSFolder(System.getProperty("java.io.tmpdir"));
    }

    public int deleteFolder() {
        this.intNoOfObjectsDeleted = 0;
        return this.deleteFolder(this);
    }

    public int deleteFolder(JSFolder pobjFolder) {
        try {
            if (pobjFolder.isDirectory()) {
                for (File file2 : pobjFolder.listFiles()) {
                    this.deleteFolder(new JSFolder(file2.getAbsolutePath()));
                }
            }
            pobjFolder.delete();
            ++this.intNoOfObjectsDeleted;
        }
        catch (Exception e) {
            throw new JobSchedulerException(String.format("Folder '%1$s' not deleted due to an error.", pobjFolder.getAbsolutePath()), e);
        }
        return this.intNoOfObjectsDeleted;
    }

    public String checkFolder(Boolean flgCreateIfNotExist) {
        if (!this.exists()) {
            if (!flgCreateIfNotExist.booleanValue()) {
                LOGGER.error(String.format("Folder '%1$s' does not exist.", this.strFolderName));
            } else {
                this.mkdirs();
                LOGGER.debug(String.format("Folder '%1$s' created.", this.strFolderName));
            }
        }
        if (!this.canRead()) {
            LOGGER.error(String.format("File '%1$s'. canRead returns false. Check permissions.", this.strFolderName));
        }
        return this.strFolderName;
    }

    public Vector<String> deleteFileList(SOSOptionRegExp objRegExpr4Files2Delete) {
        return this.deleteFileList(objRegExpr4Files2Delete.getValue());
    }

    public int deleteFiles(String strRegExpr4Files2Delete) {
        return this.deleteFileList(strRegExpr4Files2Delete).size();
    }

    public Vector<String> deleteFileList(String strRegExpr4Files2Delete) {
        int intNoOfFilesDeleted = 0;
        Vector<String> objFileList = new Vector<String>();
        for (JSFile tempFile : this.getFilelist(strRegExpr4Files2Delete, 0)) {
            tempFile.delete();
            String strName = tempFile.getAbsolutePath();
            objFileList.add(strName);
            LOGGER.debug(String.format("File '%1$s' deleted", strName));
            ++intNoOfFilesDeleted;
        }
        LOGGER.debug(String.format("%1$s files deleted matching the regexp '%2$s'", intNoOfFilesDeleted, strRegExpr4Files2Delete));
        return objFileList;
    }

    public int compressFiles(String strRegExpr4Files2Compress) {
        return this.compressFileList(strRegExpr4Files2Compress).size();
    }

    public Vector<String> compressFileList(SOSOptionRegExp objRegExpr4Files2Compress) {
        return this.compressFileList(objRegExpr4Files2Compress.getValue());
    }

    public Vector<String> compressFileList(String strRegExpr4Files2Compress) {
        int intNoOfFilesCompressed = 0;
        Vector<String> objFileList = new Vector<String>();
        for (JSFile tempFile : this.getFilelist(strRegExpr4Files2Compress, 0)) {
            LOGGER.debug(String.format("...compresing File '%1$s'", tempFile.getAbsolutePath()));
            tempFile.createZipFile(this.getFolderName());
            tempFile.delete();
            String strName = tempFile.getAbsolutePath();
            objFileList.add(strName);
            ++intNoOfFilesCompressed;
            LOGGER.debug(String.format("File '%1$s' compressed", strName));
        }
        LOGGER.debug(String.format("%1$s files compressed matching the regexp '%2$s'", intNoOfFilesCompressed, strRegExpr4Files2Compress));
        return objFileList;
    }

    public class SOSFilelistFilter
    implements FilenameFilter {
        Pattern pattern = null;

        public SOSFilelistFilter(String regexp, int flag) throws Exception {
            if (regexp != null) {
                this.pattern = Pattern.compile(regexp, flag);
            }
        }

        @Override
        public boolean accept(File dir, String filename) {
            boolean flgR = true;
            if (this.pattern != null) {
                Matcher matcher = this.pattern.matcher(filename);
                flgR = matcher.find();
            } else {
                flgR = true;
            }
            if (flgR) {
                flgR = JSFolder.this.checkMoreFilter(new JSFile(dir, filename));
            }
            return flgR;
        }
    }
}

