/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.io.Files;

import com.sos.JSHelper.Annotations.JSOptionClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.Files.JSTextFile;
import com.sos.JSHelper.io.Files.SOSProfileEntry;
import com.sos.JSHelper.io.Files.SOSProfileSection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JSOptionClass(name="JSOptionsClass", description="JSOptionsClass")
public class JSIniFile
extends JSTextFile {
    private static final long serialVersionUID = -1960627326921434568L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSIniFile.class);
    private final Map<String, SOSProfileSection> mapSections = new HashMap<String, SOSProfileSection>();
    private String strSectionName = null;
    private boolean flgIgnoreDuplicateSections = true;
    private boolean flgIsDirty = false;
    private SOSProfileSection objCurrentSection = null;
    private JSTextFile objSaveFile = null;

    public JSIniFile(String pstrFileName) {
        super(pstrFileName);
        if (this.fleFile.exists()) {
            this.getIniFile();
        }
    }

    private void getIniFile() {
        String line = null;
        try {
            StringBuffer strB = new StringBuffer();
            while ((strB = this.getLine()) != null) {
                line = strB.toString().trim();
                LOGGER.debug(line);
                int intLineLength = line.length();
                if (intLineLength <= 0 || line.startsWith(";") || line.startsWith("#")) continue;
                if (line.startsWith("[")) {
                    if (!line.endsWith("]")) {
                        throw new JobSchedulerException("] expected in section header: " + line);
                    }
                    String strSectionName = line.substring(1, intLineLength - 1).trim();
                    if (strSectionName.isEmpty()) continue;
                    this.objCurrentSection = this.addSection(strSectionName);
                    continue;
                }
                if (this.objCurrentSection == null) {
                    throw new IOException("[sectionname]-header expected");
                }
                int index = line.indexOf(61);
                if (index < 0) {
                    throw new JobSchedulerException("key/value pair without =  : " + line);
                }
                String strKey = line.substring(0, index).trim();
                String strValue = line.substring(index + 1).trim();
                this.addEntry(strKey, strValue);
            }
            this.close();
            this.flgIsDirty = false;
        }
        catch (Exception e) {
            throw new JobSchedulerException(e.toString() + "\n\nFile name is: " + this.strFileName);
        }
    }

    public SOSProfileEntry addEntry(String strKey, String strValue) {
        SOSProfileEntry objE = null;
        if (this.objCurrentSection != null) {
            objE = this.objCurrentSection.addEntry(strKey, strValue);
        }
        return objE;
    }

    public SOSProfileSection addSection(String pstrSectionName) {
        SOSProfileSection objNewSection = this.mapSections.get(pstrSectionName);
        if (objNewSection == null) {
            objNewSection = new SOSProfileSection(pstrSectionName);
            this.mapSections.put(pstrSectionName.toLowerCase(), objNewSection);
            this.flgIsDirty = true;
        } else if (!this.flgIgnoreDuplicateSections) {
            throw new JobSchedulerException("Section '" + pstrSectionName + "' duplicated.");
        }
        return objNewSection;
    }

    public SOSProfileSection getSection(String pstrSectionName) {
        SOSProfileSection objNewSection = this.mapSections.get(pstrSectionName);
        return objNewSection;
    }

    public boolean isDirty() {
        return this.flgIsDirty;
    }

    public Map<String, SOSProfileSection> getSections() {
        return this.mapSections;
    }

    public String getValue(String pstrEntryName) throws IOException {
        String strDefaultValue = null;
        return this.getPropertyString(this.strSectionName, pstrEntryName, strDefaultValue);
    }

    public String getValue(String pstrEntryName, String pstrDefaultValue) throws IOException {
        return this.getPropertyString(this.strSectionName, pstrEntryName, pstrDefaultValue);
    }

    public void setValue(String pstrEntryName, String pstrEntryValue) {
    }

    public void setSectionName(String pstrSectionName) {
        this.strSectionName = pstrSectionName;
    }

    public String getSectionName() {
        return this.strSectionName;
    }

    public String getPropertyString(String pstrSection, String key, String defaultValue) {
        SOSProfileEntry objPE;
        if (pstrSection == null) {
            throw new JobSchedulerException("[section] name missing");
        }
        SOSProfileSection map = this.mapSections.get(pstrSection.toLowerCase());
        if (map != null && (objPE = map.getEntry(key.toLowerCase())) != null) {
            return objPE.getValue();
        }
        return defaultValue;
    }

    public int getPropertyInt(String section, String key, int defaultValue) {
        String s = this.getPropertyString(section, key, null);
        if (s != null) {
            return Integer.parseInt(s);
        }
        return defaultValue;
    }

    public boolean getPropertyBool(String pstrSection, String key, boolean defaultValue) {
        String s = this.getPropertyString(pstrSection, key, null);
        if (s != null) {
            return "true".equalsIgnoreCase(s);
        }
        return defaultValue;
    }

    public String getProfileName() {
        return this.strFileName;
    }

    public void setProfileName(String pstrProfileName) {
        this.strFileName = pstrProfileName;
    }

    @Override
    public String toString() {
        String strT = "";
        int j = 0;
        for (Map.Entry<String, SOSProfileSection> e : this.getSections().entrySet()) {
            LOGGER.debug(j++ + ": " + e.getKey());
            SOSProfileSection objPS = e.getValue();
            LOGGER.debug(objPS.getName() + " - " + objPS.getEntries().size());
            strT = strT.concat(objPS.toString());
        }
        return strT;
    }

    public void saveAs(String pstrSaveAsFileName) {
        LOGGER.debug("SaveAs = " + pstrSaveAsFileName);
        this.objSaveFile = new JSTextFile(pstrSaveAsFileName);
        this.save(this.objSaveFile);
    }

    public void save() {
        this.objSaveFile = new JSTextFile(this.strFileName);
        this.save(this.objSaveFile);
    }

    public void save(JSTextFile pobjSaveFile1) {
        Map<String, SOSProfileSection> objS = this.getSections();
        LOGGER.debug("number of sections = " + objS.size());
        try {
            for (SOSProfileSection objPS : objS.values()) {
                pobjSaveFile1.writeLine(" ");
                pobjSaveFile1.writeLine("[" + objPS.getName() + "]");
                LOGGER.debug(objPS.getName());
                for (SOSProfileEntry objEntry : objPS.getEntries().values()) {
                    pobjSaveFile1.writeLine(objEntry.getName() + "=" + objEntry.getValue());
                    LOGGER.debug("     " + objEntry.getName() + " = " + objEntry.getValue());
                }
            }
            pobjSaveFile1.close();
            LOGGER.debug("File saved " + pobjSaveFile1.getAbsolutePath());
        }
        catch (Exception e) {
            throw new JobSchedulerException(e.getMessage());
        }
    }
}

