/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.io.Files;

import com.sos.JSHelper.DataElements.JSDataElementDateISO;
import com.sos.JSHelper.Options.SOSOptionFileName;
import com.sos.JSHelper.io.Files.JSTextFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.xslt.EnvironmentCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JSXMLFile
extends JSTextFile {
    protected final String conMissingDate = "0000-00-00";
    protected final String conMissingDate2 = "--";
    protected HashMap<String, String> hsmParameters = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSXMLFile.class);
    private static final long serialVersionUID = 1L;
    private Boolean flgFileIsOpen = false;
    private int intIndent = 0;
    private Boolean flgDecrIndent = false;
    private Boolean flgIncrIndent = false;
    private Vector<SOSXMLAttribute> lstAttributes = null;
    private int intNumberOfXMLDeclarations = 0;
    public static final String conORG_APACHE_XERCES_JAXP_DOCUMENT_BUILDER_FACTORY_IMPL = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    Document document = null;

    public JSXMLFile() {
        super((String)null);
    }

    public JSXMLFile(SOSOptionFileName pobjOptionElementFileName) throws Exception {
        super(pobjOptionElementFileName.getValue());
        this.strFileName = pobjOptionElementFileName.getValue();
    }

    public JSXMLFile(String pstrFileName) throws Exception {
        super(pstrFileName);
        this.strFileName = pstrFileName;
    }

    public void open(String pstrOutputFileName) throws Exception {
    }

    public JSXMLFile getXMLTagV(String pstrTagName, String pstrTagValue) throws Exception {
        return this.newTag(pstrTagName, pstrTagValue);
    }

    private String getStartTag(String strTagName) {
        String strT = this.addBraces(this.adjustTagName(strTagName) + this.buildAttributesString());
        if (strTagName.startsWith("/")) {
            this.flgDecrIndent = true;
        } else {
            this.flgIncrIndent = true;
        }
        return strT;
    }

    private String getEmptyTag(String strTagName) {
        String strT = this.addBraces(this.adjustTagName(strTagName) + this.buildAttributesString() + " /");
        this.flgDecrIndent = true;
        this.flgIncrIndent = true;
        return strT;
    }

    private String buildAttributesString() {
        String strT = "";
        if (this.lstAttributes != null) {
            for (int i = 0; i < this.lstAttributes.size(); ++i) {
                strT = strT + " " + this.lstAttributes.elementAt(i).toString();
            }
            this.lstAttributes = null;
        }
        return strT;
    }

    private String adjustTagName(String pstrTagName) {
        return pstrTagName;
    }

    private String addBraces(String pstrParam) {
        return "<" + pstrParam + ">";
    }

    private String getEndTag(String strTagName) {
        this.flgDecrIndent = true;
        return this.addBraces("/" + this.adjustTagName(strTagName));
    }

    public String tag(String pstrTagName, String pstrTagValue) {
        String strValue = pstrTagValue;
        if (strValue == null) {
            strValue = "";
        } else if (strValue.matches(".*[&<>].*") && !pstrTagValue.contains("![CDATA[")) {
            strValue = this.makeCData(strValue);
        }
        String strTemp = "";
        strTemp = strValue.isEmpty() ? String.format("%1$s", this.getEmptyTag(pstrTagName)) : String.format("%1$s%2$s%3$s", this.getStartTag(pstrTagName), strValue, this.getEndTag(pstrTagName));
        return strTemp;
    }

    public JSXMLFile newTag(String pstrTagName, String pstrTagValue) throws Exception {
        String strValue = pstrTagValue;
        if (strValue == null) {
            strValue = "";
        } else if (strValue.matches(".*[&<>].*") && !pstrTagValue.contains("![CDATA[")) {
            strValue = this.makeCData(strValue);
        }
        String strTemp = "";
        strTemp = strValue.isEmpty() ? String.format("%1$s", this.getEmptyTag(pstrTagName)) : String.format("%1$s%2$s%3$s", this.getStartTag(pstrTagName), strValue, this.getEndTag(pstrTagName));
        this.write2File(strTemp);
        return this;
    }

    public JSXMLFile write2File(String pstrS) throws Exception {
        String strT = "";
        if (!this.flgFileIsOpen.booleanValue()) {
            this.flgFileIsOpen = true;
        }
        if (this.flgIncrIndent.booleanValue()) {
            strT = this.getIndent();
            ++this.intIndent;
            this.flgIncrIndent = false;
        }
        if (this.flgDecrIndent.booleanValue()) {
            --this.intIndent;
            this.flgDecrIndent = false;
            strT = this.getIndent();
        }
        super.write(strT + pstrS);
        return this;
    }

    private String getIndent() {
        String strT = "";
        if (this.intIndent > 0) {
            strT = "";
            for (int i = 0; i < this.intIndent; ++i) {
                strT = strT + "\t";
            }
        }
        return strT;
    }

    public boolean isOpened() {
        return this.flgFileIsOpen;
    }

    public JSXMLFile writeXMLDeclaration(String pstrCharset) throws Exception {
        String strCharset = pstrCharset;
        if (strCharset == null || strCharset.isEmpty()) {
            strCharset = "ISO-8859-1";
        }
        this.write2File(this.addBraces("?xml version='1.0' encoding='" + strCharset + "' ?"));
        ++this.intNumberOfXMLDeclarations;
        return this;
    }

    public JSXMLFile writeXMLDeclaration() throws Exception {
        this.writeXMLDeclaration(null);
        return this;
    }

    public JSXMLFile comment(String pstrComment) throws Exception {
        this.write2File(this.addBraces("!-- " + pstrComment + " --"));
        return this;
    }

    public String tag(String pstrTagName) {
        return this.getStartTag(pstrTagName);
    }

    public JSXMLFile newTag(String pstrTagName) throws Exception {
        this.write2File(this.getStartTag(pstrTagName));
        return this;
    }

    public JSXMLFile endTag(String pstrTagName) throws Exception {
        this.write2File(this.getEndTag(pstrTagName));
        return this;
    }

    public JSXMLFile newCDataTag(String pstrTagName) throws Exception {
        this.write2File(this.getStartTag(pstrTagName) + "<![CDATA[");
        return this;
    }

    public JSXMLFile endCDataTag(String pstrTagName) throws Exception {
        this.write2File("]]>" + this.getEndTag(pstrTagName));
        return this;
    }

    public JSXMLFile newCDataTag(String pstrTagName, String pstrTagValue) throws Exception {
        if (pstrTagValue != null && pstrTagName != null && !pstrTagValue.isEmpty()) {
            this.newTag(pstrTagName, this.makeCData(pstrTagValue));
        }
        return this;
    }

    public String makeCData(String pstrValue) {
        return this.addBraces("![CDATA[" + pstrValue + "]]");
    }

    public JSXMLFile newDateTag(String pstrTagName, String pstrTagValue) throws Exception {
        if (pstrTagValue == null || !"0000-00-00".equals(pstrTagValue) && !"".equals(pstrTagValue) && !"--".equals(pstrTagValue.trim())) {
            this.newTag(pstrTagName, pstrTagValue);
        }
        return this;
    }

    public JSXMLFile addAttribute(String pstrAttributeName, String pstrAttributeValue) {
        SOSXMLAttribute objAtt = new SOSXMLAttribute(pstrAttributeName, pstrAttributeValue);
        if (this.lstAttributes == null) {
            this.lstAttributes = new Vector();
        }
        this.lstAttributes.add(objAtt);
        return this;
    }

    public void transform(File xslFile, File outputFile) throws TransformerException, TransformerConfigurationException, FileNotFoundException, Exception {
        Transformer transformer = null;
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            transformer = tFactory.newTransformer(new StreamSource(xslFile));
        }
        catch (TransformerFactoryConfigurationError e) {
            throw e;
        }
        catch (TransformerException e) {
            throw e;
        }
        DOMSource objDS = new DOMSource(this.getDomDocument());
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transf = tf.newTransformer();
        if (this.hsmParameters != null) {
            for (String strKey : this.hsmParameters.keySet()) {
                String strValue = this.hsmParameters.get(strKey);
                LOGGER.debug(String.format("Set XSLT-Parameter '%1$s' to value '%2$s'", strKey, strValue));
                transf.setParameter(strKey, strValue);
                transformer.setParameter(strKey, strValue);
            }
        }
        JSDataElementDateISO objISODate = new JSDataElementDateISO();
        objISODate.now();
        transf.setParameter("sos.timestamp", objISODate.now());
        transformer.setParameter("sos.timestamp", objISODate.now());
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transf.transform(objDS, result);
        LOGGER.debug(writer.toString());
        if (outputFile == null) {
            transformer.transform(objDS, new StreamResult(new OutputStreamWriter(System.out)));
        } else {
            transformer.transform(objDS, new StreamResult(new FileOutputStream(outputFile)));
        }
    }

    @Override
    public String getContent() {
        String strT = "";
        try {
            DOMSource objDS = new DOMSource(this.getDomDocument());
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transf = tf.newTransformer();
            transf.transform(objDS, result);
            strT = writer.toString();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return strT;
    }

    public void validate() throws SAXException, IOException {
        if (this.intNumberOfXMLDeclarations > 1) {
            return;
        }
    }

    public void error(SAXParseException pobjException) throws SAXException {
        throw pobjException;
    }

    public void fatalError(SAXParseException arg0) throws SAXException {
    }

    public void warning(SAXParseException arg0) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDomDocument() throws ParserConfigurationException {
        if (this.document == null) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", conORG_APACHE_XERCES_JAXP_DOCUMENT_BUILDER_FACTORY_IMPL);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance(conORG_APACHE_XERCES_JAXP_DOCUMENT_BUILDER_FACTORY_IMPL, this.getClass().getClassLoader());
            builderFactory.setNamespaceAware(true);
            builderFactory.setXIncludeAware(true);
            String strUserDir = System.getProperty("user.dir");
            try {
                String strPath = new File(this.strFileName).getParent();
                if (strPath != null) {
                    System.setProperty("user.dir", strPath);
                }
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                LOGGER.debug("Namespace aware:" + builder.isNamespaceAware());
                LOGGER.debug("XInclude aware:" + builder.isXIncludeAware());
                InputStreamReader objR = new InputStreamReader((InputStream)new FileInputStream(this.strFileName), "UTF-8");
                InputSource inS = new InputSource(objR);
                this.document = builder.parse(inS);
            }
            catch (ParserConfigurationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                System.setProperty("user.dir", strUserDir);
                LOGGER.debug(this.document.toString());
            }
        }
        return this.document;
    }

    public void writeDocument(String pstrFileName) throws Exception {
        this.getDomDocument();
        this.writeXmlFile(this.document, pstrFileName);
    }

    public void writeXmlFile(Document doc, String filename) throws Exception {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file.toURI().getPath());
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw e;
        }
        catch (TransformerException e) {
            throw e;
        }
    }

    public void setParameters(HashMap<String, String> pobjHshMap) {
        this.hsmParameters = pobjHshMap;
    }

    public void environmentCheck() throws Exception {
        EnvironmentCheck ec = new EnvironmentCheck();
        StringWriter sWri = new StringWriter();
        PrintWriter pWri = new PrintWriter(new StringWriter());
        ec.checkEnvironment(pWri);
        pWri.close();
        LOGGER.debug("Checking Xalan environment...");
        LOGGER.debug(sWri.toString());
    }

    class SOSXMLTag {
        private String Name;
        private String Value;
        private Boolean isCdata;
        private int DataType;

        public SOSXMLTag() {
        }

        public SOSXMLTag(String pstrTagName) {
            this(pstrTagName, "");
        }

        public SOSXMLTag(String pstrTagName, String pstrTagValue) {
            this.Name = pstrTagName;
            this.Value = pstrTagValue;
        }

        public String toString() {
            return "not implemented";
        }

        public int getDataType() {
            return this.DataType;
        }

        public void setDataType(int dataType) {
            this.DataType = dataType;
        }

        public Boolean getIsCdata() {
            return this.isCdata;
        }

        public void setIsCdata(Boolean isCdata1) {
            this.isCdata = isCdata1;
        }

        public String getName() {
            return this.Name;
        }

        public void setName(String name) {
            this.Name = name;
        }

        public String getValue() {
            return this.Value;
        }

        public void setValue(String value) {
            this.Value = value;
        }
    }

    class SOSXMLAttribute {
        private String strAttributeName = null;
        private String strAttributeValue = null;

        public SOSXMLAttribute() {
        }

        public SOSXMLAttribute(String pstrAttributeName, String pstrAttributeValue) {
            this.strAttributeName = pstrAttributeName;
            this.strAttributeValue = pstrAttributeValue;
        }

        public String toString() {
            return this.strAttributeName + "='" + this.strAttributeValue + "'";
        }
    }
}

