/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.io;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.SOSFileSystemOperations;
import java.io.File;

public class SOSFileSystemOperationsRename
extends SOSFileSystemOperations {
    private static final String ACTION_NAME = "renameFiles: ";

    @Override
    protected String getActionName() {
        return ACTION_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean handleOneFile(File source, File target, boolean overwrite, boolean gracious) throws Exception {
        if (source.equals(target)) {
            throw new JobSchedulerException("cannot rename file to itself: " + source.getCanonicalPath());
        }
        if (!overwrite && target.exists()) {
            if (!gracious) {
                throw new JobSchedulerException("file already exists: " + target.getCanonicalPath());
            }
            LOGGER.info("file already exists: " + target.getCanonicalPath());
            return false;
        }
        if (target.exists() && !target.delete()) {
            throw new JobSchedulerException("cannot overwrite " + target.getCanonicalPath());
        }
        if (!source.renameTo(target)) {
            boolean rc = this.copyFile(source, target);
            if (!rc) throw new JobSchedulerException("cannot rename file from " + source.getCanonicalPath() + " to " + target.getCanonicalPath());
            rc = source.delete();
            if (rc) return true;
            rc = target.delete();
            throw new JobSchedulerException("cannot rename file from " + source.getCanonicalPath() + " to " + target.getCanonicalPath());
        }
        LOGGER.info("rename " + source.getPath() + " to " + target.getPath());
        return true;
    }
}

