/*
 * Decompiled with CFR 0.152.
 */
package com.sos.localization;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.UnknownFormatConversionException;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messages
implements Serializable {
    private static final long serialVersionUID = -1276188512965716159L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Messages.class);
    private static final String ENCODING_KEY = "properties.file.encoding";
    private String BUNDLE_NAME = "com.sos.localization.messages";
    private ResourceBundle objResource_Bundle = null;
    private ResourceBundle objResourceBundleDefault = null;
    private Locale objCurrentLocale = Locale.getDefault();
    private enuEncodings enuEncoding = enuEncodings.ISO_8859_1;
    private final enuEncodings enuEncodingDefault = enuEncodings.ISO_8859_1;
    private String strLastKey = "";

    public Messages(String pstrBundleName) {
        this.BUNDLE_NAME = pstrBundleName;
        String strSOSLocale = System.getenv("SOS_LOCALE");
        this.objCurrentLocale = strSOSLocale == null ? Locale.getDefault() : new Locale(strSOSLocale);
        this.objResource_Bundle = this.getBundle();
    }

    public Messages(String pstrBundleName, Locale pobjLocale) {
        this.BUNDLE_NAME = pstrBundleName;
        this.objCurrentLocale = pobjLocale;
        this.objResource_Bundle = this.getBundle();
    }

    public Messages(String pstrBundleName, Locale pobjLocale, ClassLoader loader) {
        this.BUNDLE_NAME = pstrBundleName;
        this.objCurrentLocale = pobjLocale;
        this.objResource_Bundle = this.getBundle(loader);
    }

    public ResourceBundle getBundle() {
        ResourceBundle objB = null;
        try {
            objB = ResourceBundle.getBundle(this.BUNDLE_NAME, this.objCurrentLocale);
            this.setEncoding(objB);
        }
        catch (MissingResourceException mb) {
            try {
                objB = ResourceBundle.getBundle(this.BUNDLE_NAME);
            }
            catch (MissingResourceException mbb) {
                objB = ResourceBundle.getBundle(this.BUNDLE_NAME, new Locale("en"));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.objResourceBundleDefault = ResourceBundle.getBundle(this.BUNDLE_NAME, new Locale("en"));
        return objB;
    }

    public ResourceBundle getBundle(ClassLoader loader) {
        ResourceBundle objB;
        block7: {
            objB = null;
            try {
                objB = loader == null ? ResourceBundle.getBundle(this.BUNDLE_NAME, this.objCurrentLocale) : ResourceBundle.getBundle(this.BUNDLE_NAME, this.objCurrentLocale, loader);
                this.setEncoding(objB);
            }
            catch (MissingResourceException mb) {
                try {
                    if (loader == null) {
                        objB = ResourceBundle.getBundle(this.BUNDLE_NAME);
                    }
                    objB = ResourceBundle.getBundle(this.BUNDLE_NAME, Locale.getDefault(), loader);
                }
                catch (MissingResourceException mbb) {
                    if (loader == null) {
                        objB = ResourceBundle.getBundle(this.BUNDLE_NAME, new Locale("en"));
                        break block7;
                    }
                    objB = ResourceBundle.getBundle(this.BUNDLE_NAME, new Locale("en"), loader);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        this.objResourceBundleDefault = loader == null ? ResourceBundle.getBundle(this.BUNDLE_NAME, new Locale("en")) : ResourceBundle.getBundle(this.BUNDLE_NAME, new Locale("en"), loader);
        return objB;
    }

    public void setLocale(Locale pobjLocale) {
        this.objCurrentLocale = pobjLocale;
    }

    private void setEncoding(ResourceBundle objBundle) {
        try {
            String strM = null;
            if (objBundle != null && (strM = objBundle.getString(ENCODING_KEY)) != null && strM.equalsIgnoreCase(enuEncodings.UTF_8.text())) {
                this.enuEncoding = enuEncodings.UTF_8;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private String getString(String pstrKey, ResourceBundle objBundle) {
        String strT = null;
        try {
            String strM = "";
            if (this.objResource_Bundle == null) {
                this.objResource_Bundle = this.getBundle();
            }
            enuEncodings encoding = this.enuEncoding;
            if (this.objResource_Bundle != null) {
                try {
                    strM = this.objResource_Bundle.getString(pstrKey);
                }
                catch (MissingResourceException e) {
                    strM = this.objResourceBundleDefault.getString(pstrKey);
                    encoding = this.enuEncodingDefault;
                }
                if (strM == null) {
                    strM = pstrKey;
                } else if (strM.startsWith("[") && strM.endsWith("]")) {
                    LOGGER.trace("strLastKey = " + this.strLastKey + ", strKey = " + strM);
                    if (strM.equalsIgnoreCase(this.strLastKey)) {
                        strM = "** loop: " + strM;
                    } else {
                        String strM1;
                        String strKey = strM.substring(1, strM.length() - 1);
                        strM = strM1 = this.getString(strKey, objBundle);
                    }
                    this.strLastKey = strM;
                }
            } else {
                strM = pstrKey;
            }
            try {
                if (encoding == enuEncodings.UTF_8 && !(strT = new String(strM.getBytes(enuEncodings.ISO_8859_1.text()), enuEncodings.UTF_8.text())).contains("\u00ef\u00bf\u00bd")) {
                    strM = strT;
                }
            }
            catch (UnsupportedEncodingException e) {
                strM = strT;
            }
            return strM;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String getMsg(String pstrKey) {
        String strM = "";
        try {
            strM = this.addKey(pstrKey, this.getString(pstrKey, this.objResource_Bundle));
        }
        catch (MissingResourceException e) {
            strM = '!' + pstrKey + '!';
        }
        return strM;
    }

    private String addKey(String pstrKey, String pstrMsgTxt) {
        String strRet = pstrMsgTxt;
        if (pstrMsgTxt != null) {
            if (pstrKey != null && !pstrKey.contains("_T_") && !pstrKey.contains("_L_")) {
                strRet = pstrKey + ": " + pstrMsgTxt;
            }
        } else {
            strRet = pstrKey;
        }
        return strRet;
    }

    public String getLabel(String pstrKey) {
        try {
            String strM = this.getString(pstrKey, this.objResource_Bundle);
            return strM;
        }
        catch (MissingResourceException e) {
            return '!' + pstrKey + '!';
        }
    }

    public String getTooltip(String pstrKey) {
        try {
            String strM = this.getString(pstrKey, this.objResource_Bundle);
            return strM;
        }
        catch (MissingResourceException e) {
            return '!' + pstrKey + '!';
        }
    }

    public String getMsg(String pstrKey, Object ... pstrArgs) {
        String strM = "";
        try {
            strM = this.addKey(pstrKey, this.getString(pstrKey, this.objResource_Bundle));
            strM = String.format(strM, pstrArgs);
            int i = 0;
            if (strM.contains("{")) {
                for (Object object : pstrArgs) {
                    try {
                        String strT = (String)object;
                        strT = Matcher.quoteReplacement(strT);
                        strM = strM.replaceAll("\\{" + i++ + "\\}", strT);
                    }
                    catch (ClassCastException e) {
                        ++i;
                    }
                }
            }
            return strM;
        }
        catch (MissingFormatArgumentException e) {
            strM = String.format("%1$s (%2$s): %3$s | missing format specifer: %4$s", pstrKey, this.objCurrentLocale.getDisplayName(), strM, e.getFormatSpecifier());
            return strM;
        }
        catch (UnknownFormatConversionException e) {
            strM = String.format("%1$s (%2$s): %3$s | unknown format conversion: %4$s", pstrKey, this.objCurrentLocale.getDisplayName(), strM, e.getConversion());
            return strM;
        }
        catch (MissingResourceException e) {
            strM = String.format("%1$s (%2$s): %3$s", pstrKey, this.objCurrentLocale.getDisplayName(), strM);
            return strM;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return strM;
        }
    }

    public String getMsg(String pstrKey, Locale pobjLocale) {
        String strM = "";
        try {
            if (!this.objCurrentLocale.equals(pobjLocale)) {
                this.objCurrentLocale = pobjLocale;
                this.objResource_Bundle = this.getBundle();
            }
            strM = this.addKey(pstrKey, this.getString(pstrKey, this.objResource_Bundle));
        }
        catch (MissingResourceException e) {
            strM = '!' + pstrKey + '!';
        }
        return strM;
    }

    public static enum enuEncodings {
        ISO_8859_1,
        UTF_8;


        public String text() {
            String strT = this.name().toUpperCase().replace('_', '-');
            return strT;
        }
    }
}

