/*
 * Decompiled with CFR 0.152.
 */
package com.sos.localization;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.localization.I18NObject;
import com.sos.localization.PropertyFactoryOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFactory
extends JSJobUtilitiesClass<PropertyFactoryOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyFactory.class);

    public PropertyFactory() {
        super(new PropertyFactoryOptions());
    }

    @Override
    public PropertyFactoryOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new PropertyFactoryOptions();
        }
        return (PropertyFactoryOptions)this.objOptions;
    }

    public PropertyFactory execute() throws Exception {
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().dirtyString());
            String strPropertyFileName = ((PropertyFactoryOptions)this.objOptions).propertyFileNamePrefix.getValue();
            HashMap<String, Map<String, I18NObject>> allKeys = new HashMap<String, Map<String, I18NObject>>();
            Map<String, I18NObject> mapKeys = new HashMap();
            Vector<String> vecLanguages = new Vector<String>();
            for (File objFile : ((PropertyFactoryOptions)this.objOptions).sourceFolderName.listFiles()) {
                String strFileName = objFile.getName();
                if (!strFileName.startsWith(strPropertyFileName) || !strFileName.endsWith(".properties")) continue;
                LOGGER.info("FileName = " + objFile.getName());
                FileInputStream ips = new FileInputStream(objFile);
                Properties objProps = new Properties();
                objProps.load(ips);
                ((InputStream)ips).close();
                String strLanguage = "de";
                strLanguage = strFileName.replaceAll("\\.properties", "");
                strLanguage = strLanguage.substring(strPropertyFileName.length() + 1);
                vecLanguages.add(strLanguage);
                for (String key : objProps.stringPropertyNames()) {
                    String strIDent;
                    I18NObject objI18NO;
                    String[] strA = key.split("\\.");
                    if (strA.length < 2) {
                        LOGGER.debug(key + " = " + objProps.getProperty(key));
                        continue;
                    }
                    mapKeys = (Map)allKeys.get(strA[0]);
                    if (mapKeys == null) {
                        mapKeys = new HashMap();
                        allKeys.put(strA[0], mapKeys);
                    }
                    if ((objI18NO = (I18NObject)mapKeys.get(strIDent = strA[0] + "_" + strLanguage)) == null) {
                        objI18NO = new I18NObject(strIDent, strLanguage);
                        mapKeys.put(strIDent, objI18NO);
                    }
                    objI18NO.setBeanProperty(strA[1], objProps.getProperty(key));
                }
                for (String objK : allKeys.keySet()) {
                    LOGGER.debug(objK);
                    mapKeys = (Map)allKeys.get(objK);
                    for (String objL : mapKeys.keySet()) {
                        LOGGER.debug("_______" + objL);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return this;
    }
}

