/*
 * Decompiled with CFR 0.152.
 */
package com.sos.localization;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.Files.JSFile;
import com.sos.JSHelper.io.Files.JSTextFile;
import com.sos.localization.Messages;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSMsg {
    private static final Logger lOGGER = LoggerFactory.getLogger(SOSMsg.class);
    private static JSTextFile MISSING_CODES_FILE = null;
    private static HashMap<String, String> CODES = new HashMap();
    private static final String PROPERTY_EXTENSION_F1 = ".f1";
    private static final String ENV_VAR_SOS_LOCALE = "SOS_LOCALE";
    private static final String EXTENSION_TOOLTIP = ".tooltip";
    private static final String EXTENSION_LABEL = ".label";
    private static final String EXTENSION_ICON = ".icon";
    private static final String EXTENSION_ACC = ".acc";
    private static boolean SHOW_FULL_MESSAGE_TEXT = false;
    private MsgTypes type = MsgTypes.undefined;
    private Messages messages = null;
    private String controlName = "";
    private String controlParent = "";
    private int verbosityLevel = 0;
    private int curVerbosityLevel = 0;
    private String code = null;
    private boolean fullMessageReported = false;

    public SOSMsg(String messageCode) {
        this.code = messageCode;
        this.setMsgType();
    }

    public SOSMsg(String messageCode, int level) {
        this(messageCode);
        this.verbosityLevel = level;
    }

    public void toLog() {
        this.write2Log(this.get());
    }

    private void setMsgType() {
        this.type = MsgTypes.undefined;
        if (this.code.indexOf("_E_") != -1) {
            this.type = MsgTypes.error;
        } else if (this.code.indexOf("_F_") != -1) {
            this.type = MsgTypes.fatal;
        } else if (this.code.indexOf("_D_") != -1) {
            this.type = MsgTypes.debug;
        } else if (this.code.indexOf("_I_") != -1) {
            this.type = MsgTypes.info;
        } else if (this.code.indexOf("_W_") != -1) {
            this.type = MsgTypes.warning;
        } else if (this.code.indexOf("_T_") != -1) {
            this.type = MsgTypes.text;
        } else if (this.code.indexOf("_L_") != -1) {
            this.type = MsgTypes.label;
        } else if (this.code.indexOf("_R_") != -1) {
            this.type = MsgTypes.trace;
        }
    }

    public void toLog(Object ... args) {
        this.write2Log(this.getFullMessage(this.messages.getMsg(this.code, args)));
    }

    private void write2Log(String msg) {
        switch (this.type) {
            case error: {
                lOGGER.error(msg);
                break;
            }
            case fatal: {
                lOGGER.error(msg);
                throw new JobSchedulerException(msg);
            }
            case warning: {
                if (!lOGGER.isWarnEnabled()) break;
                lOGGER.warn(msg);
                break;
            }
            case debug: {
                if (!lOGGER.isDebugEnabled()) break;
                this.checkVerbosityLevel();
                if (this.verbosityLevel > this.curVerbosityLevel) break;
                lOGGER.debug(msg);
                break;
            }
            case info: 
            case text: 
            case undefined: {
                lOGGER.info(msg);
                break;
            }
            case trace: {
                lOGGER.trace(msg);
                break;
            }
            default: {
                lOGGER.info(msg);
            }
        }
    }

    public String icon() {
        String key = this.code.trim().replaceAll(" ", "");
        String label = this.messages.getLabel(key + EXTENSION_ICON);
        if (label == null) {
            label = "noIcon";
        }
        return label;
    }

    public String accelerator() {
        String key = this.code.trim().replaceAll(" ", "");
        String label = this.messages.getLabel(key + EXTENSION_ACC);
        if (label == null) {
            label = "";
        }
        return label;
    }

    private String getLabel(String defaultValue) {
        String key = this.code.trim().replaceAll(" ", "");
        try {
            String msg = this.messages.getLabel(key + EXTENSION_LABEL);
            if (msg == null && (msg = this.messages.getLabel(key + ".Label")) == null && (msg = this.messages.getLabel(key.toLowerCase() + EXTENSION_LABEL)) == null && (msg = this.messages.getLabel(key.toLowerCase() + ".Label")) == null) {
                msg = this.messages.getLabel(key);
            }
            String result = this.code;
            if (msg == null) {
                result = "??" + this.code + "??";
                result = defaultValue;
                this.handleMissingCodes();
            } else {
                result = msg;
            }
            return result;
        }
        catch (Exception e) {
            return this.code;
        }
    }

    private void handleMissingCodes() {
        if (MISSING_CODES_FILE == null) {
            MISSING_CODES_FILE = new JSTextFile(JSFile.getTempdir(), "MissingCodes.properties");
        }
        if (CODES.get(this.code) == null) {
            try {
                MISSING_CODES_FILE.writeLine(this.code + ".label = " + this.code);
                MISSING_CODES_FILE.writeLine(this.code + ".tooltip = " + this.code);
                MISSING_CODES_FILE.writeLine(this.code + ".shorttext = " + this.code);
                MISSING_CODES_FILE.writeLine(this.code + ".F1 = ");
                MISSING_CODES_FILE.writeLine(this.code + ".F10 = ");
                MISSING_CODES_FILE.writeLine(this.code + ".icon = ");
                MISSING_CODES_FILE.writeLine(this.code + ".acc = ");
            }
            catch (IOException e) {
                lOGGER.error(e.getMessage(), (Throwable)e);
            }
            CODES.put(this.code, "");
        }
    }

    public String label() {
        String key = this.code.trim().replaceAll(" ", "");
        return this.getLabel(key);
    }

    public String caption() {
        return this.getLabel("");
    }

    public String tooltip() {
        try {
            String control;
            String msg = this.messages.getTooltip(this.code + EXTENSION_TOOLTIP);
            if (msg == null && (msg = this.messages.getTooltip("tooltip." + this.code.toLowerCase())) == null && (msg = this.messages.getTooltip(this.code.toLowerCase() + EXTENSION_TOOLTIP)) == null && (msg = this.messages.getTooltip("tooltip." + this.code)) == null && (msg = this.messages.getTooltip(this.code + ".Tooltip")) == null && (msg = this.messages.getTooltip("Tooltip." + this.code.toLowerCase())) == null && (msg = this.messages.getTooltip(this.code.toLowerCase() + ".Tooltip")) == null) {
                msg = this.messages.getTooltip("Tooltip." + this.code);
            }
            if ("none".equals(msg.trim())) {
                msg = this.code + ": sorry, no tooltip available yet";
            }
            if (!".".equals(control = this.controlParent + "." + this.controlName)) {
                msg = control + " -> " + msg;
            }
            return msg;
        }
        catch (Exception e) {
            return this.code;
        }
    }

    public String getF1() {
        String key = this.code.trim().replaceAll(" ", "");
        try {
            String msg = this.messages.getLabel(key + ".F1");
            if (msg == null && (msg = this.messages.getLabel(key.toLowerCase() + ".F1")) == null && (msg = this.messages.getLabel(key + PROPERTY_EXTENSION_F1)) == null && (msg = this.messages.getLabel(key.toLowerCase() + PROPERTY_EXTENSION_F1)) == null) {
                msg = this.messages.getLabel(key);
            }
            return msg != null && !"".equals(msg) ? msg : key;
        }
        catch (Exception e) {
            return this.code;
        }
    }

    public String get() {
        if (!this.fullMessageReported) {
            return this.getFullMessage();
        }
        return this.messages.getMsg(this.code);
    }

    public String get(Exception ex) {
        if (!this.fullMessageReported) {
            return this.getFullMessage();
        }
        return this.messages.getMsg(this.code, ex.getMessage());
    }

    public String getFullMessage() {
        return this.getFullMessage(this.messages.getMsg(this.code));
    }

    private String getFullMessage(String msg) {
        StringBuilder sb = new StringBuilder(msg);
        if (SHOW_FULL_MESSAGE_TEXT && !this.fullMessageReported) {
            switch (this.type) {
                case error: 
                case fatal: 
                case warning: {
                    String reason;
                    String desc = this.messages.getLabel(this.code + ".description");
                    if (desc == null) {
                        desc = "*** no detailed description available ***";
                    }
                    if ((reason = this.messages.getLabel(this.code + ".reason")) == null) {
                        reason = "*** no detailed explanation available ***";
                    }
                    sb.append("\n\n").append("DESCRIPTION").append("\n").append(desc).append("\n\n").append("REASON").append("\n").append(reason);
                    this.fullMessageReported = true;
                    break;
                }
            }
        }
        return sb.toString();
    }

    public String get(Object ... args) {
        return this.getFullMessage(this.messages.getMsg(this.code, args));
    }

    public String getFullMessage(Object ... args) {
        boolean full = SHOW_FULL_MESSAGE_TEXT;
        SHOW_FULL_MESSAGE_TEXT = true;
        String msg = this.messages.getMsg(this.code, args);
        msg = String.format(this.getFullMessage(msg), args);
        SHOW_FULL_MESSAGE_TEXT = full;
        return msg;
    }

    public String params(Object ... args) {
        String msg = this.messages.getLabel(this.code + EXTENSION_LABEL);
        if (msg == null) {
            msg = this.messages.getLabel(this.code.toLowerCase() + EXTENSION_LABEL);
        }
        if (msg != null) {
            try {
                msg = String.format(msg, args);
            }
            catch (Exception e) {
                lOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            msg = this.messages.getMsg(this.code, args);
        }
        return msg;
    }

    public String params(String[] args) {
        String msg = this.messages.getLabel(this.code + EXTENSION_LABEL);
        if (msg == null) {
            msg = this.messages.getLabel(this.code.toLowerCase() + EXTENSION_LABEL);
        }
        StringBuilder sb = new StringBuilder();
        for (String string : args) {
            sb.append(" ").append(string);
        }
        msg = msg != null ? String.format(msg, sb.toString()) : this.messages.getMsg(this.code, sb.toString());
        return msg;
    }

    public String paramsNoKey(Object ... args) {
        return String.format(this.messages.getLabel(this.code), args);
    }

    protected void setMessageResource(String val) {
        String locale = System.getenv(ENV_VAR_SOS_LOCALE);
        this.messages = locale == null ? new Messages(val, Locale.getDefault()) : new Messages(val, new Locale(locale));
    }

    protected void setMessageResource(String bundleName, String locale) {
        this.messages = new Messages(bundleName, new Locale(locale));
    }

    protected void checkVerbosityLevel() {
    }

    public void setVerbosityLevel(int val) {
        this.verbosityLevel = val;
    }

    public void setCurVerbosityLevel(int val) {
        this.curVerbosityLevel = val;
    }

    public void setMessages(Messages val) {
        this.messages = val;
    }

    public Messages getMessages() {
        return this.messages;
    }

    private static enum MsgTypes {
        undefined,
        error,
        info,
        fatal,
        debug,
        warning,
        text,
        trace,
        label;

    }
}

