/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.classes;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassList {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassList.class);
    private final ClassLoader classLoader;
    private final List<Class<?>> classes = new ArrayList();

    public ClassList() {
        this.classLoader = ClassLoader.getSystemClassLoader();
    }

    public void addClassIfExist(String className) {
        try {
            Class<?> c = this.classLoader.loadClass(className);
            this.add(c);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(String.format("Class %s not found in the classpath", className));
        }
    }

    public void add(Class<?> c) {
        if (!this.classes.contains(c)) {
            this.classes.add(c);
        }
    }

    public void merge(List<Class<?>> classesToMerge) {
        for (Class<?> c : classesToMerge) {
            this.add(c);
        }
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }
}

