/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.classes;

import com.sos.hibernate.classes.ClassList;
import com.sos.hibernate.classes.SOSHibernate;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateConfigurationException;
import com.sos.hibernate.exceptions.SOSHibernateConvertException;
import com.sos.hibernate.exceptions.SOSHibernateFactoryBuildException;
import com.sos.hibernate.exceptions.SOSHibernateOpenSessionException;
import com.sos.keepass.SOSKeePassResolver;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.persistence.PersistenceException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.LongType;
import org.hibernate.type.NumericBooleanType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSString;

public class SOSHibernateFactory
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateFactory.class);
    private static final long serialVersionUID = 1L;
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final boolean isTraceEnabled = LOGGER.isTraceEnabled();
    private ClassList classMapping;
    private Optional<Path> configFile = Optional.empty();
    private Configuration configuration;
    private Properties configurationProperties;
    private Enum<Dbms> dbms = Dbms.UNKNOWN;
    private Properties defaultConfigurationProperties;
    private Dialect dialect;
    private String identifier;
    private String logIdentifier;
    private Optional<Integer> jdbcFetchSize = Optional.empty();
    private SessionFactory sessionFactory;
    private boolean useDefaultConfigurationProperties = true;

    public SOSHibernateFactory() throws SOSHibernateConfigurationException {
        this((String)null);
    }

    public SOSHibernateFactory(Path hibernateConfigFile) throws SOSHibernateConfigurationException {
        this.setIdentifier(null);
        this.setConfigFile(hibernateConfigFile);
        this.initClassMapping();
        this.initConfigurationProperties();
    }

    public SOSHibernateFactory(String hibernateConfigFile) throws SOSHibernateConfigurationException {
        this.setIdentifier(null);
        this.setConfigFile(hibernateConfigFile);
        this.initClassMapping();
        this.initConfigurationProperties();
    }

    public static String getTransactionIsolationName(int isolationLevel) throws SOSHibernateConfigurationException {
        switch (isolationLevel) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        throw new SOSHibernateConfigurationException(String.format("invalid transaction isolation level=%s", isolationLevel));
    }

    public void addClassMapping(Class<?> c) {
        this.classMapping.add(c);
    }

    public void addClassMapping(ClassList list) {
        for (Class<?> c : list.getClasses()) {
            this.classMapping.add(c);
        }
    }

    public void build() throws SOSHibernateFactoryBuildException {
        try {
            this.initConfiguration();
            this.initSessionFactory();
            if (isDebugEnabled) {
                String method = SOSHibernate.getMethodName(this.logIdentifier, "build");
                int isolationLevel = this.getTransactionIsolation();
                LOGGER.debug(String.format("%s autoCommit=%s, transactionIsolation=%s", method, this.getAutoCommit(), SOSHibernateFactory.getTransactionIsolationName(isolationLevel)));
            }
        }
        catch (SOSHibernateConfigurationException ex) {
            throw new SOSHibernateFactoryBuildException(ex, this.configFile);
        }
        catch (PersistenceException ex) {
            throw new SOSHibernateFactoryBuildException(ex);
        }
    }

    public void close() {
        if (isDebugEnabled) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "close"));
        }
        try {
            if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
                this.sessionFactory.close();
            }
        }
        catch (Throwable e) {
            LOGGER.warn(e.toString(), e);
        }
        this.sessionFactory = null;
    }

    public boolean dbmsIsPostgres() {
        return this.dbms == Dbms.PGSQL;
    }

    public boolean getAutoCommit() throws SOSHibernateConfigurationException {
        if (this.configuration == null) {
            throw new SOSHibernateConfigurationException("configuration is NULL");
        }
        String p = this.configuration.getProperty("hibernate.connection.autocommit");
        if (SOSString.isEmpty((String)p)) {
            throw new SOSHibernateConfigurationException(String.format("\"%s\" property is not configured ", "hibernate.connection.autocommit"));
        }
        return Boolean.parseBoolean(p);
    }

    public ClassList getClassMapping() {
        return this.classMapping;
    }

    public Optional<Path> getConfigFile() {
        return this.configFile;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public SOSHibernateSession getCurrentSession() throws SOSHibernateOpenSessionException {
        return this.getCurrentSession(this.identifier);
    }

    public SOSHibernateSession getCurrentSession(String identifier) throws SOSHibernateOpenSessionException {
        SOSHibernateSession session = new SOSHibernateSession(this);
        session.setIsGetCurrentSession(true);
        session.setIdentifier(identifier);
        session.openSession();
        return session;
    }

    public Enum<Dbms> getDbms() {
        return this.dbms;
    }

    public Enum<Dbms> getDbmsBeforeBuild() throws SOSHibernateConfigurationException {
        Configuration conf = new Configuration();
        Dialect dt = null;
        try {
            if (this.configFile.isPresent()) {
                conf.configure(this.configFile.get().toUri().toURL());
            } else {
                conf.configure();
            }
            dt = Dialect.getDialect((Properties)conf.getProperties());
        }
        catch (MalformedURLException e) {
            throw new SOSHibernateConfigurationException(String.format("exception on get configFile %s as url", this.configFile), e);
        }
        catch (PersistenceException e) {
            throw new SOSHibernateConfigurationException(e);
        }
        return this.getDbms(dt);
    }

    public Properties getDefaultConfigurationProperties() {
        return this.defaultConfigurationProperties;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Optional<Integer> getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    public String getSequenceLastValString(String sequenceName) {
        if (this.dbms.equals((Object)Dbms.MSSQL)) {
            return "SELECT @@IDENTITY";
        }
        if (this.dbms.equals((Object)Dbms.MYSQL)) {
            return "SELECT LAST_INSERT_ID();";
        }
        if (this.dbms.equals((Object)Dbms.ORACLE)) {
            return "SELECT " + sequenceName + ".currval FROM DUAL";
        }
        if (this.dbms.equals((Object)Dbms.PGSQL)) {
            return "SELECT currval('" + sequenceName + "');";
        }
        if (this.dbms.equals((Object)Dbms.DB2)) {
            return "SELECT IDENTITY_VAL_LOCAL() AS INSERT_ID FROM SYSIBM.SYSDUMMY1";
        }
        if (this.dbms.equals((Object)Dbms.SYBASE)) {
            return "SELECT @@IDENTITY";
        }
        return null;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public int getTransactionIsolation() throws SOSHibernateConfigurationException {
        if (this.configuration == null) {
            throw new SOSHibernateConfigurationException("configuration is NULL");
        }
        String p = this.configuration.getProperty("hibernate.connection.isolation");
        if (SOSString.isEmpty((String)p)) {
            throw new SOSHibernateConfigurationException(String.format("\"%s\" property is not configured ", "hibernate.connection.isolation"));
        }
        return Integer.parseInt(p);
    }

    public boolean isUseDefaultConfigurationProperties() {
        return this.useDefaultConfigurationProperties;
    }

    public SOSHibernateSession openSession() throws SOSHibernateOpenSessionException {
        return this.openSession(this.identifier);
    }

    public SOSHibernateSession openSession(String identifier) throws SOSHibernateOpenSessionException {
        SOSHibernateSession session = new SOSHibernateSession(this);
        session.setIdentifier(identifier);
        session.openSession();
        return session;
    }

    public SOSHibernateSession openStatelessSession() throws SOSHibernateOpenSessionException {
        return this.openStatelessSession(this.identifier);
    }

    public SOSHibernateSession openStatelessSession(String identifier) throws SOSHibernateOpenSessionException {
        SOSHibernateSession session = new SOSHibernateSession(this);
        session.setIsStatelessSession(true);
        session.setIdentifier(identifier);
        session.openSession();
        return session;
    }

    public String quote(Type type, Object value) throws SOSHibernateConvertException {
        if (value == null) {
            return "NULL";
        }
        try {
            if (type instanceof NumericBooleanType) {
                return NumericBooleanType.INSTANCE.objectToSQLString((Boolean)value, this.dialect);
            }
            if (type instanceof LongType) {
                return LongType.INSTANCE.objectToSQLString((Long)value, this.dialect);
            }
            if (type instanceof StringType) {
                return "'" + value.toString().replaceAll("'", "''") + "'";
            }
            if (type instanceof TimestampType) {
                if (this.dbms.equals((Object)Dbms.ORACLE)) {
                    String val = SOSDate.getDateAsString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                    return "to_date('" + val + "','yyyy-mm-dd HH24:MI:SS')";
                }
                if (this.dbms.equals((Object)Dbms.MSSQL)) {
                    String val = SOSDate.getDateAsString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss.SSS");
                    return "'" + val.replace(" ", "T") + "'";
                }
                return TimestampType.INSTANCE.objectToSQLString((Date)value, this.dialect);
            }
        }
        catch (Exception e) {
            throw new SOSHibernateConvertException(String.format("can't convert value=%s to SQL string", value), e);
        }
        return value + "";
    }

    public String quoteColumn(String columnName) {
        if (this.dialect != null && columnName != null) {
            String[] arr = columnName.split("\\.");
            if (arr.length == 1) {
                columnName = this.dialect.openQuote() + columnName + this.dialect.closeQuote();
            } else {
                StringBuilder sb = new StringBuilder();
                String cn = arr[arr.length - 1];
                for (int i = 0; i < arr.length - 1; ++i) {
                    sb.append(arr[i] + ".");
                }
                sb.append(this.dialect.openQuote() + cn + this.dialect.closeQuote());
                columnName = sb.toString();
            }
        }
        return columnName;
    }

    public void setAutoCommit(boolean commit) {
        this.configurationProperties.put("hibernate.connection.autocommit", String.valueOf(commit));
    }

    public void setConfigFile(Path hibernateConfigFile) throws SOSHibernateConfigurationException {
        if (hibernateConfigFile != null) {
            if (!Files.exists(hibernateConfigFile, new LinkOption[0])) {
                throw new SOSHibernateConfigurationException(String.format("hibernate config file not found: %s", hibernateConfigFile.toString()));
            }
            this.configFile = Optional.of(hibernateConfigFile);
        }
    }

    public void setConfigFile(String hibernateConfigFile) throws SOSHibernateConfigurationException {
        this.setConfigFile(hibernateConfigFile == null ? null : Paths.get(hibernateConfigFile, new String[0]));
    }

    public void setConfigurationProperties(Properties properties) {
        if (this.configurationProperties.isEmpty()) {
            this.configurationProperties = properties;
        } else if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.configurationProperties.setProperty(key, value);
            }
        }
    }

    public void setIdentifier(String val) {
        this.identifier = val;
        this.logIdentifier = SOSHibernate.getLogIdentifier(this.identifier);
    }

    public void setTransactionIsolation(int level) {
        this.configurationProperties.put("hibernate.connection.isolation", String.valueOf(level));
    }

    public void setUseDefaultConfigurationProperties(boolean val) {
        this.useDefaultConfigurationProperties = val;
    }

    private void configure() throws SOSHibernateConfigurationException {
        try {
            if (this.configFile.isPresent()) {
                this.configuration.configure(this.configFile.get().toUri().toURL());
            } else {
                this.configuration.configure();
            }
            if (isDebugEnabled) {
                String method = SOSHibernate.getMethodName(this.logIdentifier, "configure");
                if (this.configFile.isPresent()) {
                    LOGGER.debug(String.format("%s %s", method, this.configFile.get().toAbsolutePath().toString()));
                } else {
                    LOGGER.debug(String.format("%s configure connection without the hibernate file", method));
                }
            }
        }
        catch (MalformedURLException e) {
            throw new SOSHibernateConfigurationException(String.format("exception on get configFile %s as url", this.configFile), e);
        }
        catch (PersistenceException e) {
            throw new SOSHibernateConfigurationException(e);
        }
    }

    private Enum<Dbms> getDbms(Dialect dialect) {
        Dbms db = Dbms.UNKNOWN;
        if (dialect != null) {
            String dialectClassName = dialect.getClass().getSimpleName().toLowerCase();
            if (dialectClassName.contains("db2")) {
                db = Dbms.DB2;
            } else if (dialectClassName.contains("firebird")) {
                db = Dbms.FBSQL;
            } else if (dialectClassName.contains("sqlserver")) {
                db = Dbms.MSSQL;
            } else if (dialectClassName.contains("mysql")) {
                db = Dbms.MYSQL;
            } else if (dialectClassName.contains("oracle")) {
                db = Dbms.ORACLE;
            } else if (dialectClassName.contains("postgre")) {
                db = Dbms.PGSQL;
            } else if (dialectClassName.contains("sybase")) {
                db = Dbms.SYBASE;
            }
        }
        return db;
    }

    private void initClassMapping() {
        this.classMapping = new ClassList();
    }

    private void initConfiguration() throws SOSHibernateConfigurationException {
        if (isDebugEnabled) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "initConfiguration"));
        }
        this.configuration = new Configuration();
        this.setConfigurationClassMapping();
        this.setDefaultConfigurationProperties();
        this.configure();
        this.setConfigurationProperties();
        this.resolveCredentialStoreProperties();
        this.showConfigurationProperties();
    }

    private void initConfigurationProperties() {
        this.defaultConfigurationProperties = new Properties();
        this.defaultConfigurationProperties.put("hibernate.connection.isolation", String.valueOf(2));
        this.defaultConfigurationProperties.put("hibernate.connection.autocommit", "false");
        this.defaultConfigurationProperties.put("hibernate.jdbc.use_scrollable_resultset", "true");
        this.defaultConfigurationProperties.put("hibernate.current_session_context_class", "jta");
        this.defaultConfigurationProperties.put("javax.persistence.validation.mode", "none");
        this.defaultConfigurationProperties.put("hibernate.id.new_generator_mappings", "false");
        this.defaultConfigurationProperties.put("hibernate.sos.mssql_lock_timeout", "30000");
        this.configurationProperties = new Properties();
    }

    private void initSessionFactory() {
        if (isDebugEnabled) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "initSessionFactory"));
        }
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)this.configuration.getProperties()).build();
        this.sessionFactory = this.configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        SessionFactoryImplementor impl = (SessionFactoryImplementor)this.sessionFactory;
        if (impl != null) {
            this.dialect = impl.getJdbcServices().getDialect();
            this.setDbms(this.dialect);
        }
    }

    private void showConfigurationProperties() {
        String property = this.configuration.getProperty("hibernate.sos.show_configuration_properties");
        if (property != null && property.toLowerCase().equals("true")) {
            String method = SOSHibernate.getMethodName(this.logIdentifier, "showConfigurationProperties");
            for (Map.Entry<Object, Object> entry : this.configuration.getProperties().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.equals("hibernate.connection.password")) {
                    value = "***";
                }
                LOGGER.info(String.format("%s %s=%s", method, key, value));
            }
        }
    }

    private void setConfigurationClassMapping() {
        if (this.classMapping != null) {
            String method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "setConfigurationClassMapping") : "";
            for (Class<?> c : this.classMapping.getClasses()) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s %s", method, c.getCanonicalName()));
                }
                this.configuration.addAnnotatedClass(c);
            }
        }
    }

    private void setConfigurationProperties() {
        if (this.configurationProperties != null) {
            String method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "setConfigurationProperties") : "";
            for (Map.Entry<Object, Object> entry : this.configurationProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.configuration.setProperty(key, value);
                if (!isDebugEnabled) continue;
                LOGGER.debug(String.format("%s %s=%s", method, key, value));
            }
            if (this.configuration.getProperty("hibernate.jdbc.fetch_size") != null) {
                try {
                    this.jdbcFetchSize = Optional.of(Integer.parseInt(this.configuration.getProperty("hibernate.jdbc.fetch_size")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void resolveCredentialStoreProperties() throws SOSHibernateConfigurationException {
        if (this.configuration == null) {
            return;
        }
        try {
            String password;
            String username;
            String f = this.configuration.getProperty("hibernate.sos.credential_store_file");
            String kf = this.configuration.getProperty("hibernate.sos.credential_store_key_file");
            String p = this.configuration.getProperty("hibernate.sos.credential_store_password");
            String ep = this.configuration.getProperty("hibernate.sos.credential_store_entry_path");
            SOSKeePassResolver r = new SOSKeePassResolver(f, kf, p);
            r.setEntryPath(ep);
            String url = this.configuration.getProperty("hibernate.connection.url");
            if (url != null) {
                this.configuration.setProperty("hibernate.connection.url", r.resolve(url));
            }
            if ((username = this.configuration.getProperty("hibernate.connection.username")) != null) {
                this.configuration.setProperty("hibernate.connection.username", r.resolve(username));
            }
            if ((password = this.configuration.getProperty("hibernate.connection.password")) != null) {
                this.configuration.setProperty("hibernate.connection.password", r.resolve(password));
            }
        }
        catch (Throwable e) {
            throw new SOSHibernateConfigurationException(e.toString(), e);
        }
    }

    private void setDbms(Dialect dialect) {
        this.dbms = this.getDbms(dialect);
    }

    private void setDefaultConfigurationProperties() {
        if (this.useDefaultConfigurationProperties && this.defaultConfigurationProperties != null) {
            String method = isTraceEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "setDefaultConfigurationProperties") : "";
            for (Map.Entry<Object, Object> entry : this.defaultConfigurationProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (isTraceEnabled) {
                    LOGGER.trace(String.format("%s %s=%s", method, key, value));
                }
                this.configuration.setProperty(key, value);
            }
        }
    }

    public static enum Dbms {
        DB2,
        FBSQL,
        MSSQL,
        MYSQL,
        ORACLE,
        PGSQL,
        SYBASE,
        UNKNOWN;

    }
}

