/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.classes;

import com.sos.hibernate.classes.SOSHibernateSession;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.annotations.Type;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateResultSetProcessor
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateResultSetProcessor.class);
    private static final long serialVersionUID = 1L;
    private Class<?> entity;
    private HashMap<String, Method> entityGetMethods;
    private HashMap<String, Method> entitySetMethods;
    private ResultSet resultSet;
    private SOSHibernateSession session;
    private String sqlStatement;
    private Statement statement;

    public SOSHibernateResultSetProcessor(SOSHibernateSession sess) {
        this.session = sess;
    }

    public void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dispose();
    }

    public ResultSet createResultSet(Class<?> resultEntity, Criteria criteria, ScrollMode scrollMode) throws Exception {
        return this.createResultSet(resultEntity, criteria, scrollMode, null);
    }

    public ResultSet createResultSet(Class<?> resultEntity, Criteria criteria, ScrollMode scrollMode, Optional<Integer> fetchSize) throws Exception {
        String method = "createResultSet";
        try {
            LOGGER.debug(String.format("%s", method));
            CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
            this.entity = resultEntity == null ? Class.forName(criteriaImpl.getEntityOrClassName()) : resultEntity;
            SharedSessionContractImplementor session = criteriaImpl.getSession();
            SessionFactoryImplementor factory = session.getFactory();
            CriteriaQueryTranslator translator = new CriteriaQueryTranslator(factory, criteriaImpl, criteriaImpl.getEntityOrClassName(), "this_");
            String[] implementors = factory.getImplementors(criteriaImpl.getEntityOrClassName());
            CriteriaJoinWalker walker = new CriteriaJoinWalker((OuterJoinLoadable)factory.getEntityPersister(implementors[0]), translator, factory, criteriaImpl, criteriaImpl.getEntityOrClassName(), session.getLoadQueryInfluencers());
            String sql = this.createSqlStatement(translator, walker.getSQLString());
            this.createMetadata(translator);
            this.resultSet = this.createResultSet(sql, scrollMode, criteria.isReadOnly(), fetchSize);
        }
        catch (Exception ex) {
            throw new Exception(String.format("%s: %s", method, ex.toString()));
        }
        return this.resultSet;
    }

    public ResultSet createResultSet(Criteria criteria, ScrollMode scrollMode) throws Exception {
        return this.createResultSet(null, criteria, scrollMode, null);
    }

    public ResultSet createResultSet(Criteria criteria, ScrollMode scrollMode, Optional<Integer> fetchSize) throws Exception {
        return this.createResultSet(null, criteria, scrollMode, fetchSize);
    }

    public ResultSet createResultSet(String sql, ScrollMode scrollMode, boolean isReadOnly) throws Exception {
        return this.createResultSet(sql, scrollMode, isReadOnly, null);
    }

    public ResultSet createResultSet(String sql, ScrollMode scrollMode, boolean isReadOnly, Optional<Integer> fetchSize) throws Exception {
        String method = "createResultSet";
        this.sqlStatement = sql;
        LOGGER.debug(String.format("%s: sqlStatement = %s, scrollMode = %s, isReadOnly = %s, fetchSize= %s", method, this.sqlStatement, scrollMode.toString(), isReadOnly, fetchSize));
        this.statement = this.session.getConnection().createStatement(this.getResultSetType(scrollMode), this.getConcurrencyMode(isReadOnly));
        if (fetchSize.isPresent()) {
            this.statement.setFetchSize(fetchSize.get());
        } else if (this.session.getFactory().getJdbcFetchSize().isPresent()) {
            this.statement.setFetchSize(this.session.getFactory().getJdbcFetchSize().get());
        }
        this.resultSet = this.statement.executeQuery(this.sqlStatement);
        LOGGER.debug(String.format("%s: statement.getFetchSize = %s", method, this.statement.getFetchSize()));
        return this.resultSet;
    }

    public Object get() throws Exception {
        if (this.entity == null) {
            throw new Exception("entity is NULL");
        }
        if (this.entitySetMethods == null) {
            throw new Exception("entitySetMethods is NULL");
        }
        if (this.entityGetMethods == null) {
            throw new Exception("entityGetMethods is NULL");
        }
        Object bean = this.entity.newInstance();
        for (Map.Entry<String, Method> setters : this.entitySetMethods.entrySet()) {
            String field = setters.getKey();
            Method setter = setters.getValue();
            Method getter = this.entityGetMethods.get(field);
            String returnTypeName = getter.getReturnType().getSimpleName();
            if ("String".equalsIgnoreCase(returnTypeName)) {
                setter.invoke(bean, this.resultSet.getString(field));
                continue;
            }
            if ("Long".equalsIgnoreCase(returnTypeName)) {
                setter.invoke(bean, this.resultSet.getLong(field));
                continue;
            }
            if ("Integer".equalsIgnoreCase(returnTypeName)) {
                setter.invoke(bean, this.resultSet.getInt(field));
                continue;
            }
            if ("Timestamp".equals(returnTypeName)) {
                setter.invoke(bean, this.resultSet.getTimestamp(field));
                continue;
            }
            if ("Date".equals(returnTypeName)) {
                setter.invoke(bean, this.resultSet.getTimestamp(field));
                continue;
            }
            if ("boolean".equalsIgnoreCase(returnTypeName)) {
                Type t = getter.getAnnotation(Type.class);
                boolean setted = false;
                if (t != null && "numeric_boolean".equalsIgnoreCase(t.type())) {
                    long val = this.resultSet.getLong(field);
                    setter.invoke(bean, val == 0L ? new Boolean(false) : new Boolean(true));
                    setted = true;
                }
                if (setted) continue;
                setter.invoke(bean, this.resultSet.getBoolean(field));
                continue;
            }
            setter.invoke(bean, this.resultSet.getObject(field));
        }
        return bean;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    private void createMetadata(CriteriaQueryTranslator translator) throws Exception {
        String method = "createMetadata";
        if (translator.getRootCriteria().getProjection() == null) {
            throw new Exception(String.format("%s: translator.getRootCriteria().getProjection() is NULL. Please use the Projection in the criteria definition", method));
        }
        this.entityGetMethods = new HashMap();
        this.entitySetMethods = new HashMap();
        String[] properties = translator.getProjectedAliases();
        String[] propertiesColumnAliases = translator.getProjectedColumnAliases();
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            if (property == null) {
                throw new Exception(String.format("%s: property is NULL. Please use the field aliases in the Projection definition", method));
            }
            Method getter = new PropertyDescriptor(property, this.entity).getReadMethod();
            Method setter = new PropertyDescriptor(property, this.entity).getWriteMethod();
            this.entityGetMethods.put(propertiesColumnAliases[i], getter);
            this.entitySetMethods.put(propertiesColumnAliases[i], setter);
        }
    }

    private String createSqlStatement(CriteriaQueryTranslator translator, String hibernateSqlString) throws Exception {
        String where = translator.getWhereCondition();
        QueryParameters qp = translator.getQueryParameters();
        org.hibernate.type.Type[] types = qp.getPositionalParameterTypes();
        Object[] values = qp.getPositionalParameterValues();
        for (int i = 0; i < values.length; ++i) {
            int index = where.indexOf("?");
            if (index <= 0) continue;
            String val = this.session.getFactory().quote(types[i], values[i]);
            where = where.replaceFirst("\\?", val);
        }
        return hibernateSqlString.replace(translator.getWhereCondition(), where);
    }

    private void dispose() {
        this.resultSet = null;
        this.statement = null;
        this.entity = null;
        this.entityGetMethods = null;
        this.entitySetMethods = null;
        this.sqlStatement = null;
    }

    private int getConcurrencyMode(boolean readOnly) {
        return readOnly ? 1007 : 1008;
    }

    private int getResultSetType(ScrollMode scrollMode) throws Exception {
        String method = "getResultSetType";
        int type = 0;
        if (scrollMode.equals((Object)ScrollMode.FORWARD_ONLY)) {
            type = 1003;
        } else if (scrollMode.equals((Object)ScrollMode.SCROLL_INSENSITIVE)) {
            type = 1004;
        } else if (scrollMode.equals((Object)ScrollMode.SCROLL_SENSITIVE)) {
            type = 1005;
        } else {
            throw new Exception(String.format("%s: not supported scroll mode = %s", method, scrollMode.toString()));
        }
        return type;
    }
}

