/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Functor;
import cats.Invariant;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.std.Queue;
import cats.effect.std.Queue$;
import cats.effect.std.Queue$State$;
import cats.effect.std.Queue$SyncState$;
import cats.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class Queue$
implements Serializable {
    public static final Queue$SyncState$ cats$effect$std$Queue$$$SyncState;
    public static final Queue$State$ cats$effect$std$Queue$$$State;
    public static final Either<Nothing$, BoxedUnit> cats$effect$std$Queue$$$EitherUnit;
    public static final Queue$ MODULE$;

    private Queue$() {
    }

    static {
        MODULE$ = new Queue$();
        cats$effect$std$Queue$$$EitherUnit = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Queue$.class);
    }

    public <F, A> Object bounded(int capacity, GenConcurrent<F, ?> F) {
        this.assertNonNegative(capacity);
        if (1 < capacity && capacity < Short.MAX_VALUE * 2) {
            GenConcurrent<F, ?> genConcurrent = F;
            if (genConcurrent instanceof Async) {
                Async f0 = (Async)genConcurrent;
                return this.boundedForAsync(capacity, f0);
            }
            return this.boundedForConcurrent(capacity, F);
        }
        if (capacity > 0) {
            return this.boundedForConcurrent(capacity, F);
        }
        return this.synchronous(F);
    }

    public <F, A> Object boundedForConcurrent(int capacity, GenConcurrent<F, ?> F) {
        return package.all$.MODULE$.toFunctorOps(F.ref(Queue$State$.MODULE$.empty()), F).map((Function1 & Serializable)_$5 -> new Queue.BoundedQueue(capacity, _$5, F));
    }

    public <F, A> Object boundedForAsync(int capacity, Async<F> F) {
        return F.delay(() -> this.boundedForAsync$$anonfun$1(capacity, F));
    }

    public <F, A> Object unboundedForConcurrent(GenConcurrent<F, ?> F) {
        return this.boundedForConcurrent(Integer.MAX_VALUE, F);
    }

    public <F, A> Object unboundedForAsync(Async<F> F) {
        return F.delay(() -> this.unboundedForAsync$$anonfun$1(F));
    }

    public <F, A> Object synchronous(GenConcurrent<F, ?> F) {
        return package.all$.MODULE$.toFunctorOps(F.ref(Queue$SyncState$.MODULE$.empty()), F).map((Function1 & Serializable)_$10 -> new Queue.Synchronous(_$10, F));
    }

    public <F, A> Object unbounded(GenConcurrent<F, ?> F) {
        GenConcurrent<F, ?> genConcurrent = F;
        if (genConcurrent instanceof Async) {
            Async f0 = (Async)genConcurrent;
            return this.unboundedForAsync(f0);
        }
        return this.unboundedForConcurrent(F);
    }

    public <F, A> Object dropping(int capacity, GenConcurrent<F, ?> F) {
        this.assertPositive(capacity, "Dropping");
        return package.all$.MODULE$.toFunctorOps(F.ref(Queue$State$.MODULE$.empty()), F).map((Function1 & Serializable)_$13 -> new Queue.DroppingQueue(capacity, _$13, F));
    }

    public <F, A> Object circularBuffer(int capacity, GenConcurrent<F, ?> F) {
        this.assertPositive(capacity, "CircularBuffer");
        return package.all$.MODULE$.toFunctorOps(F.ref(Queue$State$.MODULE$.empty()), F).map((Function1 & Serializable)_$15 -> new Queue.CircularBufferQueue(capacity, _$15, F));
    }

    private void assertNonNegative(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Bounded queue capacity must be non-negative, was: ").append(capacity).toString());
        }
    }

    private void assertPositive(int capacity, String name) {
        if (capacity <= 0) {
            throw new IllegalArgumentException(new StringBuilder(39).append(name).append(" queue capacity must be positive, was: ").append(capacity).toString());
        }
    }

    public <F> Invariant<?> catsInvariantForQueue(Functor<F> evidence$1) {
        return new Invariant<?>(evidence$1){
            public final Functor cats$effect$std$Queue$$anon$3$$evidence$1$1;
            {
                this.cats$effect$std$Queue$$anon$3$$evidence$1$1 = evidence$1$2;
            }

            public Queue imap(Queue fa, Function1 f, Function1 g) {
                return new Queue<F, B>(fa, f, g, this){
                    private final Queue fa$1;
                    private final Function1 f$3;
                    private final Function1 g$1;
                    private final /* synthetic */ anon.3 $outer;
                    {
                        this.fa$1 = fa$4;
                        this.f$3 = f$6;
                        this.g$1 = g$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public Object offer(Object b) {
                        return this.fa$1.offer(this.g$1.apply(b));
                    }

                    public Object tryOffer(Object b) {
                        return this.fa$1.tryOffer(this.g$1.apply(b));
                    }

                    public Object take() {
                        return package.all$.MODULE$.toFunctorOps(this.fa$1.take(), this.$outer.cats$effect$std$Queue$$anon$3$$evidence$1$1).map(this.f$3);
                    }

                    public Object tryTake() {
                        return package.all$.MODULE$.toFunctorOps(this.fa$1.tryTake(), this.$outer.cats$effect$std$Queue$$anon$3$$evidence$1$1).map((Function1 & Serializable)_$36 -> _$36.map(this.f$3));
                    }

                    public Object size() {
                        return this.fa$1.size();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{tryTake$$anonfun$1(scala.Option )}, serializedLambda);
                    }
                };
            }
        };
    }

    private final Queue boundedForAsync$$anonfun$1(int capacity$2, Async F$2) {
        return new Queue.BoundedAsyncQueue(capacity$2, F$2);
    }

    private final Queue unboundedForAsync$$anonfun$1(Async F$3) {
        return new Queue.UnboundedAsyncQueue(F$3);
    }
}

