/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate;

import com.sos.commons.hibernate.SOSHibernateFactory;
import com.sos.commons.hibernate.SOSHibernateSession;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateFileProcessor.class);
    private String fileSpec = "^(.*)";
    private boolean hasDirectory = false;
    private boolean commitAtEnd = false;
    private List<String> successFiles;
    private Map<String, String> errorFiles;

    public SOSHibernateFileProcessor() {
        this.init();
    }

    private void init() {
        this.errorFiles = new LinkedHashMap<String, String>();
        this.successFiles = new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SOSHibernateSession session, Path inputFile) {
        String method = "process";
        boolean isEnd = false;
        try {
            if (Files.isDirectory(inputFile, new LinkOption[0])) {
                int i;
                LOGGER.info(String.format("[%s][directory][%s]fileSpec=%s", "process", inputFile.toString(), this.getFileSpec()));
                this.hasDirectory = true;
                Pattern pattern = Pattern.compile(this.getFileSpec(), 0);
                Set filelist = Files.list(inputFile).filter(p -> !Files.isDirectory(p, new LinkOption[0]) && pattern.matcher(p.getFileName().toString()).find()).collect(Collectors.toSet());
                Iterator iterator = filelist.iterator();
                while (iterator.hasNext()) {
                    this.process(session, (Path)iterator.next());
                }
                isEnd = true;
                LOGGER.info(String.format("[%s][%s][success=%s][error=%s][total=%s]", "process", inputFile.toString(), this.successFiles.size(), this.errorFiles.size(), filelist.size()));
                if (!this.successFiles.isEmpty()) {
                    LOGGER.info(String.format("[%s][%s][success]:", "process", inputFile.toString()));
                    for (i = 0; i < this.successFiles.size(); ++i) {
                        LOGGER.info(String.format("[%s]     %s) %s", "process", i + 1, this.successFiles.get(i)));
                    }
                }
                if (!this.errorFiles.isEmpty()) {
                    LOGGER.info(String.format("[%s][%s][error]:", "process", inputFile.toString()));
                    i = 1;
                    for (Map.Entry<String, String> entry : this.errorFiles.entrySet()) {
                        LOGGER.info(String.format("[%s]     %s) %s: %s", "process", i, entry.getKey(), entry.getValue()));
                        ++i;
                    }
                }
            } else {
                LOGGER.info(String.format("[%s][file]%s", "process", inputFile.toString()));
                session.getSQLExecutor().executeStatements(new String(Files.readAllBytes(inputFile), "UTF-8"));
                if (!this.hasDirectory) {
                    isEnd = true;
                }
                this.successFiles.add(inputFile.toString());
                LOGGER.info(String.format("[%s][file][processed]%s", "process", inputFile.toString()));
            }
        }
        catch (Exception e) {
            this.errorFiles.put(inputFile.toString(), e.toString());
            LOGGER.warn(String.format("[%s][exception][%s]%s", "process", inputFile.toString(), e.toString()), (Throwable)e);
        }
        finally {
            try {
                if (session != null && isEnd) {
                    if (this.isCommitAtEnd()) {
                        session.commit();
                    } else {
                        session.rollback();
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(String fileSpec) {
        this.fileSpec = fileSpec;
    }

    public boolean isCommitAtEnd() {
        return this.commitAtEnd;
    }

    public void setCommitAtEnd(boolean commitAtEnd) {
        this.commitAtEnd = commitAtEnd;
    }

    public void clearResult() {
        this.successFiles.clear();
        this.errorFiles.clear();
    }

    public boolean hasError() {
        return !this.errorFiles.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            LOGGER.info(String.format("Usage: %s hibernate_config_file   input_path   [file_spec]   [-commit-at-end]   [-auto-commit]", SOSHibernateFileProcessor.class.getSimpleName()));
            LOGGER.info("            hibernate_config_file : required");
            LOGGER.info("                                    path to the hibernate configuration file");
            LOGGER.info("            input_path            : required");
            LOGGER.info("                                    directory or file path");
            LOGGER.info("            file_spec             : optional");
            LOGGER.info("                                    file specification (regex)");
            LOGGER.info("            -commit-at-end        : optional");
            LOGGER.info("                                    execute COMMIT at end");
            LOGGER.info("            -auto-commit          : optional");
            LOGGER.info("                                    auto commit");
            return;
        }
        SOSHibernateFactory factory = null;
        SOSHibernateSession session = null;
        SOSHibernateFileProcessor processor = null;
        boolean logToStdErr = false;
        int exitCode = 0;
        try {
            factory = new SOSHibernateFactory(args[0]);
            processor = new SOSHibernateFileProcessor();
            logToStdErr = Arrays.asList(args).contains("-execute-from-setup");
            Path inputFile = null;
            for (int i = 0; i < args.length; ++i) {
                String param = args[i].trim();
                LOGGER.info(String.format("  %s) %s", i + 1, param));
                if (i == 1) {
                    inputFile = Paths.get(param, new String[0]);
                    continue;
                }
                if (i == 2) {
                    processor.setFileSpec(param);
                    continue;
                }
                if (i <= 3) continue;
                if ("-commit-at-end".equalsIgnoreCase(param)) {
                    processor.setCommitAtEnd(true);
                    continue;
                }
                if (!"-auto-commit".equalsIgnoreCase(param)) continue;
                factory.setAutoCommit(true);
            }
            factory.build();
            session = factory.openStatelessSession();
            processor.process(session, inputFile);
            if (processor.errorFiles != null) {
                exitCode = processor.errorFiles.size();
                if (logToStdErr) {
                    for (Map.Entry<String, String> entry : processor.errorFiles.entrySet()) {
                        System.err.println(String.format("%s: %s", entry.getKey(), entry.getValue()));
                    }
                }
            }
            if (logToStdErr && processor.successFiles != null) {
                for (String str : processor.successFiles) {
                    System.err.println(String.format("%s processed successfully", str));
                }
            }
        }
        catch (Exception e) {
            exitCode = 1;
            if (logToStdErr) {
                e.printStackTrace(System.err);
            } else {
                e.printStackTrace(System.out);
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (factory != null) {
                factory.close();
            }
        }
        System.exit(exitCode);
    }
}

