/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.function.json;

import com.sos.commons.hibernate.SOSHibernateFactory;
import java.util.Arrays;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.StandardBasicTypes;

public class SOSHibernateJsonValue
extends StandardSQLFunction {
    public static final String NAME = "SOS_JSON_VALUE";
    private SOSHibernateFactory factory;

    public SOSHibernateJsonValue(SOSHibernateFactory factory) {
        super(NAME, StandardBasicTypes.STRING);
        this.factory = factory;
    }

    public static String getFunction(ReturnType returnType, String property, String path) {
        return NAME + "('" + returnType.name() + "'," + property + ",'" + path + "')";
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) throws QueryException {
        if (arguments == null || arguments.size() < 3) {
            throw new QueryException("missing arguments", null, null);
        }
        switch (this.factory.getDbms()) {
            case MYSQL: {
                ReturnType retType = this.argument2ReturnType(arguments.get(0));
                if (retType.equals((Object)ReturnType.SCALAR)) {
                    sqlAppender.append((CharSequence)"JSON_UNQUOTE(JSON_EXTRACT(");
                    arguments.get(1).accept(translator);
                    sqlAppender.append((CharSequence)",");
                    arguments.get(2).accept(translator);
                    sqlAppender.append((CharSequence)"))");
                    break;
                }
                sqlAppender.append((CharSequence)"JSON_EXTRACT(");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)",");
                arguments.get(2).accept(translator);
                sqlAppender.append((CharSequence)")");
                break;
            }
            case MSSQL: {
                ReturnType retType = this.argument2ReturnType(arguments.get(0));
                if (retType.equals((Object)ReturnType.SCALAR)) {
                    sqlAppender.append((CharSequence)"JSON_VALUE(");
                    arguments.get(1).accept(translator);
                    sqlAppender.append((CharSequence)",");
                    arguments.get(2).accept(translator);
                    sqlAppender.append((CharSequence)")");
                    break;
                }
                sqlAppender.append((CharSequence)"JSON_QUERY(");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)",");
                arguments.get(2).accept(translator);
                sqlAppender.append((CharSequence)")");
                break;
            }
            case ORACLE: {
                ReturnType retType = this.argument2ReturnType(arguments.get(0));
                if (retType.equals((Object)ReturnType.SCALAR)) {
                    sqlAppender.append((CharSequence)"JSON_VALUE(");
                    arguments.get(1).accept(translator);
                    sqlAppender.append((CharSequence)",");
                    arguments.get(2).accept(translator);
                    sqlAppender.append((CharSequence)")");
                    break;
                }
                sqlAppender.append((CharSequence)"JSON_QUERY(");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)",");
                arguments.get(2).accept(translator);
                if (this.factory.getDatabaseMetaData().getOracle().getJson().returningClobEnabled()) {
                    sqlAppender.append((CharSequence)" RETURNING CLOB");
                }
                sqlAppender.append((CharSequence)")");
                break;
            }
            case PGSQL: {
                String path = this.getLiteralValue(arguments.get(2));
                String[] arr = path.replaceAll("'", "").substring(2).split("\\.");
                StringBuilder r = new StringBuilder();
                if (arr.length == 1) {
                    r.append("->>'").append(arr[0]).append("'");
                } else {
                    r.append("->'");
                    r.append(String.join((CharSequence)"'->'", Arrays.copyOf(arr, arr.length - 1)));
                    r.append("'->>'").append(arr[arr.length - 1]).append("'");
                }
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)"::jsonb");
                sqlAppender.append((CharSequence)r.toString());
                break;
            }
            case H2: {
                sqlAppender.append((CharSequence)NAME);
                sqlAppender.append((CharSequence)"(");
                arguments.get(1).accept(translator);
                sqlAppender.append((CharSequence)",");
                arguments.get(2).accept(translator);
                sqlAppender.append((CharSequence)")");
                break;
            }
            default: {
                sqlAppender.append((CharSequence)NAME);
            }
        }
    }

    private String getLiteralValue(SqlAstNode arg) {
        return ((QueryLiteral)arg).getLiteralValue().toString();
    }

    private ReturnType argument2ReturnType(SqlAstNode arg) throws QueryException {
        try {
            return ReturnType.valueOf(this.getLiteralValue(arg));
        }
        catch (Exception e) {
            throw new QueryException(String.format("[argument=%s]%s", arg, e.toString()), null, e);
        }
    }

    public static enum ReturnType {
        SCALAR,
        JSON;

    }
}

