/*
 * Decompiled with CFR 0.152.
 */
package sos.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;

public class Message {
    private MimeMessage msg;
    private final Properties properties = System.getProperties();
    private Session session = null;
    private byte[] body;
    private final List<BodyPart> attachments = new LinkedList<BodyPart>();
    private final List<InputStream> fileInputStreams = new ArrayList<InputStream>();
    private String smtpUserName = "";
    private String smtpPassword = "";
    private String encoding;
    private String contentType;
    private boolean built = false;
    static final int CURRENT_VERSION = 2;

    public Message() {
        this.msg = new MimeMessage(this.getSession());
    }

    public void close() throws Exception {
        Exception exception = null;
        for (InputStream stream : this.fileInputStreams) {
            try {
                stream.close();
            }
            catch (Exception x) {
                if (exception != null) continue;
                exception = x;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void needVersion(int version) throws Exception {
        if (version > 2) {
            throw new Exception("Class sos.mail.Message (sos.mail.jar) is not up to date");
        }
    }

    private Session getSession() {
        if (this.session == null) {
            this.session = Session.getInstance((Properties)this.properties, (Authenticator)new MyAuthenticator());
        }
        return this.session;
    }

    public void set(String what, byte[] value) throws AddressException, MessagingException, UnsupportedEncodingException {
        if ("smtp".equals(what)) {
            this.properties.put("mail.smtp.host", new String(value, "iso8859-1"));
        } else if ("from".equals(what)) {
            InternetAddress[] addr = InternetAddress.parse((String)new String(value, "iso8859-1"));
            if (addr.length != 0) {
                this.msg.setFrom((Address)addr[0]);
            }
        } else if ("reply-to".equals(what)) {
            this.msg.setReplyTo((Address[])InternetAddress.parse((String)new String(value, "iso8859-1")));
        } else if ("to".equals(what)) {
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)new String(value, "iso8859-1")));
        } else if ("cc".equals(what)) {
            this.msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)new String(value, "iso8859-1")));
        } else if ("bcc".equals(what)) {
            this.msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)new String(value, "iso8859-1")));
        } else if ("subject".equals(what)) {
            this.msg.setSubject(new String(value, "iso8859-1"));
        } else if ("body".equals(what)) {
            this.body = value;
        } else if ("content_type".equals(what)) {
            this.contentType = new String(value, "iso8859-1");
        } else if ("encoding".equals(what)) {
            this.encoding = new String(value, "iso8859-1");
        } else if ("send_rfc822".equals(what)) {
            this.msg = new MimeMessage(this.getSession(), (InputStream)new ByteArrayInputStream(value));
            this.send2();
        } else if ("debug".equals(what)) {
            this.getSession().setDebug("1".equals(new String(value, "iso8859-1")));
        } else {
            throw new RuntimeException("sos.mail.Message.set: what");
        }
    }

    public void setProperty(String name, String value) {
        if ("mail.smtp.user".equals(name)) {
            this.smtpUserName = value;
        } else if ("mail.smtp.password".equals(name)) {
            this.smtpPassword = value;
        } else {
            this.properties.put(name, value);
        }
    }

    private String stringFromAddresses(Address[] addresses) {
        if (addresses == null) {
            return "";
        }
        String result = "";
        for (Address addresse : addresses) {
            if (!"".equals(result)) {
                result = new String(result + ", ");
            }
            result = new String(result + addresse);
        }
        return result;
    }

    public String get(String what) throws Exception {
        if ("smtp".equals(what)) {
            return (String)this.properties.get("mail.smtp.host");
        }
        if ("from".equals(what)) {
            return this.stringFromAddresses(this.msg.getFrom());
        }
        if ("reply-to".equals(what)) {
            return this.stringFromAddresses(this.msg.getReplyTo());
        }
        if ("to".equals(what)) {
            return this.stringFromAddresses(this.msg.getRecipients(Message.RecipientType.TO));
        }
        if ("cc".equals(what)) {
            return this.stringFromAddresses(this.msg.getRecipients(Message.RecipientType.CC));
        }
        if ("bcc".equals(what)) {
            return this.stringFromAddresses(this.msg.getRecipients(Message.RecipientType.BCC));
        }
        if ("subject".equals(what)) {
            return this.msg.getSubject();
        }
        if ("body".equals(what)) {
            return this.body == null ? "" : new String(this.body, "iso8859-1");
        }
        if ("rfc822_text".equals(what)) {
            this.build();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.msg.writeTo((OutputStream)os);
            return os.toString();
        }
        throw new RuntimeException("sos.mail.Message.get: what=\"" + what + "\" ist unbekannt");
    }

    public void addHeaderField(String name, String value) throws MessagingException {
        this.msg.setHeader(name, value);
    }

    public void addFile(String realFilename, String newFilename, String contentType, String encoding) throws Exception {
        if (newFilename == null || newFilename.isEmpty()) {
            newFilename = realFilename;
        }
        if (contentType == null || contentType.isEmpty()) {
            contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(newFilename);
        }
        MimeBodyPart attachment = new MimeBodyPart();
        FileDataSource data_source = new FileDataSource(new File(realFilename), new File(newFilename), contentType);
        DataHandler data_handler = new DataHandler((DataSource)data_source);
        attachment.setDataHandler(data_handler);
        attachment.setFileName(data_handler.getName());
        this.attachments.add((BodyPart)attachment);
    }

    public void addAttachment(byte[] data, String filename, String contentType, String encoding) throws MessagingException {
        if (contentType.isEmpty()) {
            contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(filename);
        }
        MimeBodyPart attachment = new MimeBodyPart();
        ByteArrayDataSource data_source = new ByteArrayDataSource(data, new File(filename), contentType);
        DataHandler data_handler = new DataHandler((DataSource)data_source);
        attachment.setDataHandler(data_handler);
        attachment.setFileName(data_handler.getName());
        this.attachments.add((BodyPart)attachment);
    }

    public void send() throws Exception {
        this.build();
        this.send2();
    }

    public void build() throws Exception {
        if (this.built) {
            return;
        }
        this.msg.setSentDate(new Date());
        if (this.contentType == null || "".equals(this.contentType)) {
            this.contentType = "text/plain";
        }
        if (this.attachments.isEmpty()) {
            this.setBodyIn((MimePart)this.msg);
        } else {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart b = new MimeBodyPart();
            this.setBodyIn((MimePart)b);
            multipart.addBodyPart((BodyPart)b);
            for (BodyPart bodyPart : this.attachments) {
                multipart.addBodyPart(bodyPart);
            }
            this.msg.setContent((Multipart)multipart);
        }
        this.built = true;
    }

    private void setBodyIn(MimePart bodyPart) throws Exception {
        bodyPart.setContent((Object)new String(this.body, "iso8859-1"), this.contentType);
    }

    protected void send2() throws MessagingException, NoSuchProviderException {
        if (!this.smtpUserName.isEmpty()) {
            this.properties.put("mail.smtp.auth", "true");
        }
        Transport.send((javax.mail.Message)this.msg);
    }

    public class MyAuthenticator
    extends Authenticator {
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(Message.this.smtpUserName, Message.this.smtpPassword);
        }
    }

    class FileDataSource
    extends MyDataSource {
        final File file;

        public FileDataSource(File file, File new_filename, String content_type) {
            super(new_filename, content_type);
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            FileInputStream f = new FileInputStream(this.file);
            Message.this.fileInputStreams.add(f);
            return f;
        }
    }

    class ByteArrayDataSource
    extends MyDataSource {
        final byte[] byte_array;

        public ByteArrayDataSource(byte[] byte_array, File new_filename, String content_type) {
            super(new_filename, content_type);
            this.byte_array = byte_array;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.byte_array);
        }
    }

    abstract class MyDataSource
    implements DataSource {
        final String name;
        final String content_type;

        public MyDataSource(File new_filename, String content_type) {
            this.name = new_filename.getName();
            this.content_type = content_type;
        }

        public String getContentType() {
            return this.content_type;
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() {
            throw new RuntimeException(this.getClass().getName() + " hat keinen OutputStream");
        }
    }
}

