/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.metrics;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.metrics.CpuStarvation$;
import cats.effect.metrics.CpuStarvationMBean;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public class CpuStarvation
implements CpuStarvationMBean {
    private final AtomicLong counter;
    private final AtomicLong currentClockDrift;
    private final AtomicLong maxClockDrift;

    public static IO<CpuStarvation> apply() {
        return CpuStarvation$.MODULE$.apply();
    }

    public CpuStarvation(AtomicLong counter, AtomicLong currentClockDrift, AtomicLong maxClockDrift) {
        this.counter = counter;
        this.currentClockDrift = currentClockDrift;
        this.maxClockDrift = maxClockDrift;
    }

    @Override
    public long getCpuStarvationCount() {
        return this.counter.get();
    }

    @Override
    public long getMaxClockDriftMs() {
        return this.maxClockDrift.get();
    }

    @Override
    public long getCurrentClockDriftMs() {
        return this.currentClockDrift.get();
    }

    public IO<BoxedUnit> incStarvationCount() {
        return IO$.MODULE$.delay(this::incStarvationCount$$anonfun$1).void();
    }

    public IO<BoxedUnit> recordDrift(FiniteDuration drift) {
        long driftMs = drift.toMillis();
        IO<BoxedUnit> maxDrift = driftMs > 0L ? IO$.MODULE$.delay(() -> this.$anonfun$1(driftMs)).void() : IO$.MODULE$.unit();
        return IO$.MODULE$.delay((Function0 & Serializable)() -> {
            this.recordDrift$$anonfun$1(driftMs);
            return BoxedUnit.UNIT;
        }).$greater$greater(() -> CpuStarvation.recordDrift$$anonfun$2(maxDrift));
    }

    private final long incStarvationCount$$anonfun$1() {
        return this.counter.incrementAndGet();
    }

    private final long $anonfun$1(long driftMs$1) {
        return this.maxClockDrift.updateAndGet(_$1 -> package$.MODULE$.max(_$1, driftMs$1));
    }

    private final void recordDrift$$anonfun$1(long driftMs$3) {
        this.currentClockDrift.set(driftMs$3);
    }

    private static final IO recordDrift$$anonfun$2(IO maxDrift$1) {
        return maxDrift$1;
    }
}

