/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.tracing;

import cats.effect.IOFiber;
import cats.effect.Trace;
import cats.effect.Trace$;
import cats.effect.tracing.RingBuffer;
import cats.effect.tracing.RingBuffer$;
import cats.effect.tracing.TracingConstants;
import cats.effect.tracing.TracingEvent;
import cats.effect.tracing.TracingPlatform;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Tracing$
extends TracingPlatform
implements Serializable {
    private static final String[] runLoopFilter;
    private static final String[] stackTraceClassNameFilter;
    public static final Tracing$ MODULE$;

    private Tracing$() {
    }

    static {
        MODULE$ = new Tracing$();
        String TurnRight = "\u2570";
        String Junction = "\u251c";
        runLoopFilter = new String[]{"cats.effect.", "scala.runtime.", "scala.scalajs.runtime.", "scala.scalanative.runtime."};
        stackTraceClassNameFilter = new String[]{"cats.", "sbt.", "java.", "jdk.", "sun.", "scala.", "org.scalajs."};
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Tracing$.class);
    }

    public TracingEvent buildEvent() {
        return new TracingEvent.StackTrace();
    }

    public final String[] stackTraceClassNameFilter() {
        return stackTraceClassNameFilter;
    }

    public StackTraceElement combineOpAndCallSite(StackTraceElement methodSite, StackTraceElement callSite) {
        String methodSiteMethodName = methodSite.getMethodName();
        String op = this.decodeMethodName(methodSiteMethodName);
        return new StackTraceElement(new StringBuilder(3).append(op).append(" @ ").append(callSite.getClassName()).toString(), callSite.getMethodName(), callSite.getFileName(), callSite.getLineNumber());
    }

    public boolean isInternalClass(String className) {
        int len = this.stackTraceClassNameFilter().length;
        for (int i = 0; i < len; ++i) {
            if (!className.startsWith(this.stackTraceClassNameFilter()[i])) continue;
            return true;
        }
        return false;
    }

    public StackTraceElement cats$effect$tracing$Tracing$$$getOpAndCallSite(StackTraceElement[] stackTrace) {
        int len = stackTrace.length;
        for (int idx = 1; idx < len; ++idx) {
            StackTraceElement methodSite = stackTrace[idx - 1];
            StackTraceElement callSite = stackTrace[idx];
            String callSiteClassName = callSite.getClassName();
            String callSiteMethodName = callSite.getMethodName();
            String callSiteFileName = callSite.getFileName();
            String string = callSiteClassName;
            String string2 = "cats.effect.IOFiber";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = callSiteMethodName;
                String string4 = "run";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    return null;
                }
            }
            if (this.applyStackTraceFilter(callSiteClassName, callSiteMethodName, callSiteFileName)) continue;
            return this.combineOpAndCallSite(methodSite, callSite);
        }
        return null;
    }

    public void augmentThrowable(boolean enhancedExceptions, Throwable t, RingBuffer events) {
        if (TracingConstants.isStackTracing && enhancedExceptions) {
            Object[] stackTrace = t.getStackTrace();
            Object object = Predef$.MODULE$.refArrayOps(stackTrace);
            if (!ArrayOps$.MODULE$.isEmpty$extension(object)) {
                boolean augmented;
                Object object2 = Predef$.MODULE$.refArrayOps(stackTrace);
                boolean bl = augmented = ((StackTraceElement)ArrayOps$.MODULE$.last$extension(object2)).getClassName().indexOf(64) != -1;
                if (!augmented) {
                    Object[] prefix = this.dropRunLoopFrames$1((StackTraceElement[])stackTrace);
                    StackTraceElement[] suffix = (StackTraceElement[])this.getFrames(events).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
                    Object object3 = Predef$.MODULE$.refArrayOps(prefix);
                    t.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$extension(object3, (Object)suffix, ClassTag$.MODULE$.apply(StackTraceElement.class)));
                    return;
                }
                return;
            }
            return;
        }
    }

    public List<StackTraceElement> getFrames(RingBuffer events) {
        return events.toList().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(TracingEvent x) {
                TracingEvent tracingEvent = x;
                if (tracingEvent instanceof TracingEvent.StackTrace) {
                    TracingEvent.StackTrace ev = (TracingEvent.StackTrace)tracingEvent;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(TracingEvent x, Function1 function1) {
                TracingEvent tracingEvent = x;
                if (tracingEvent instanceof TracingEvent.StackTrace) {
                    TracingEvent.StackTrace ev = (TracingEvent.StackTrace)tracingEvent;
                    return Tracing$.MODULE$.cats$effect$tracing$Tracing$$$getOpAndCallSite(ev.getStackTrace());
                }
                return function1.apply((Object)x);
            }
        }).filter((Function1 & Serializable)_$1 -> _$1 != null);
    }

    public String prettyPrint(Trace trace) {
        List<StackTraceElement> frames = trace.toList();
        return ((List)frames.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                StackTraceElement frame = (StackTraceElement)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                String junc = index == frames.length() - 1 ? "\u2570" : "\u251c";
                return new StringBuilder(2).append(" ").append(junc).append(" ").append(frame).toString();
            }
            throw new MatchError((Object)tuple2);
        }).mkString(System.lineSeparator());
    }

    public Option<Tuple2<Runnable, Trace>> captureTrace(Runnable runnable) {
        IOFiber f;
        Runnable runnable2 = runnable;
        if (runnable2 instanceof IOFiber && (f = (IOFiber)runnable2).isDone()) {
            return None$.MODULE$;
        }
        if (runnable2 instanceof IOFiber) {
            IOFiber f2 = (IOFiber)runnable2;
            Runnable runnable3 = (Runnable)Predef$.MODULE$.ArrowAssoc((Object)runnable);
            return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)runnable3, (Object)f2.captureTrace()));
        }
        Runnable runnable4 = (Runnable)Predef$.MODULE$.ArrowAssoc((Object)runnable);
        return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)runnable4, (Object)Trace$.MODULE$.apply(RingBuffer$.MODULE$.empty(1))));
    }

    private final boolean applyRunLoopFilter$1(StackTraceElement ste) {
        String name = ste.getClassName();
        int len = runLoopFilter.length;
        for (int i = 0; i < len; ++i) {
            if (!name.startsWith(runLoopFilter[i])) continue;
            return true;
        }
        return false;
    }

    private final StackTraceElement[] dropRunLoopFrames$1(StackTraceElement[] frames) {
        ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
        for (StackTraceElement frame : frames) {
            if (this.applyRunLoopFilter$1(frame)) {
                return (StackTraceElement[])buffer.toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
            }
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)buffer.$plus$eq((Object)frame);
        }
        return (StackTraceElement[])buffer.toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
    }
}

