/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.IOFiber$;
import cats.effect.Trace;
import cats.effect.tracing.Tracing$;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.TimerSkipList;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WorkStealingThreadPool;
import cats.effect.unsafe.WorkStealingThreadPoolConstants;
import java.io.Serializable;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.BlockContext;
import scala.concurrent.CanAwait;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class WorkerThread
extends Thread
implements BlockContext {
    private final int idx;
    private LocalQueue queue;
    private AtomicBoolean parked;
    private final ScalQueue<Object> external;
    private WeakBag<Runnable> fiberBag;
    private TimerSkipList sleepers;
    private final WorkStealingThreadPool pool;
    private int _index;
    private ThreadLocalRandom random;
    private Runnable cedeBypass;
    private boolean blocking;
    private long now;
    private Runnable _active;
    private final LinkedTransferQueue indexTransfer;
    private final Duration runtimeBlockingExpiration;
    private final int nameIndex;

    public WorkerThread(int idx, LocalQueue queue, AtomicBoolean parked, ScalQueue<Object> external, WeakBag<Runnable> fiberBag, TimerSkipList sleepers, WorkStealingThreadPool pool) {
        this.idx = idx;
        this.queue = queue;
        this.parked = parked;
        this.external = external;
        this.fiberBag = fiberBag;
        this.sleepers = sleepers;
        this.pool = pool;
        this._index = idx;
        this.blocking = false;
        this.now = System.nanoTime();
        this.indexTransfer = new LinkedTransferQueue();
        this.runtimeBlockingExpiration = pool.runtimeBlockingExpiration();
        this.nameIndex = pool.blockedWorkerThreadNamingIndex().getAndIncrement();
        this.setDaemon(true);
        String prefix = pool.threadPrefix();
        this.setName(new java.lang.StringBuilder(1).append(prefix).append("-").append(this.nameIndex()).toString());
    }

    public AtomicBoolean parked() {
        return this.parked;
    }

    public void parked_$eq(AtomicBoolean x$1) {
        this.parked = x$1;
    }

    public long now() {
        return this.now;
    }

    public void now_$eq(long x$1) {
        this.now = x$1;
    }

    private LinkedTransferQueue<Integer> indexTransfer() {
        return this.indexTransfer;
    }

    public int nameIndex() {
        return this.nameIndex;
    }

    public void schedule(Runnable fiber) {
        ThreadLocalRandom rnd = this.random;
        this.queue.enqueue(fiber, this.external, rnd);
        this.pool.notifyParked(rnd);
    }

    public void reschedule(Runnable fiber) {
        if (this.cedeBypass == null && this.queue.isEmpty()) {
            this.cedeBypass = fiber;
            return;
        }
        this.schedule(fiber);
    }

    public Runnable sleep(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        long _now = System.nanoTime();
        this.now_$eq(_now);
        return this.sleepers.insert(_now, delay.toNanos(), callback, this.random);
    }

    public boolean isOwnedBy(WorkStealingThreadPool threadPool) {
        return this.pool == threadPool && !this.blocking;
    }

    public boolean canExecuteBlockingCodeOn(WorkStealingThreadPool threadPool) {
        return this.pool == threadPool;
    }

    public WeakBag.Handle monitor(Runnable fiber) {
        return this.fiberBag.insert(fiber);
    }

    public int index() {
        return this._index;
    }

    public Runnable active() {
        return this._active;
    }

    public void active_$eq(Runnable fiber) {
        this._active = fiber;
    }

    public Map<Runnable, Trace> suspendedTraces() {
        scala.collection.mutable.Map foreign = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.fiberBag.forEach((Function1<Runnable, BoxedUnit>)(JProcedure1 & Serializable)r -> foreign.$plus$plus$eq(Tracing$.MODULE$.captureTrace((Runnable)r)));
        return foreign.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        self = this;
        rnd = this.random = ThreadLocalRandom.current();
        RightUnit = IOFiber$.MODULE$.RightUnit();
        state = 4;
        done = this.pool.done();
        block24: while (!done.get()) {
            if (this.blocking) {
                this.queue = null;
                this.sleepers = null;
                this.parked_$eq(null);
                this.fiberBag = null;
                this.pool.cachedThreads().add(this);
                try {
                    len = this.runtimeBlockingExpiration.length();
                    unit = this.runtimeBlockingExpiration.unit();
                    newIdx = this.indexTransfer().poll(len, unit);
                    if (newIdx == null) {
                        if (this.pool.cachedThreads().remove(this)) {
                            this.pool.blockedWorkerThreadCounter().decrementAndGet();
                            return;
                        }
                        newIdx = this.indexTransfer().take();
                        this.init(Predef$.MODULE$.Integer2int(newIdx));
                    } else {
                        this.init(Predef$.MODULE$.Integer2int(newIdx));
                    }
                }
                catch (InterruptedException v0) {
                    return;
                }
                this.blocking = false;
                state = 4;
            }
            var10_9 = state & WorkStealingThreadPoolConstants.ExternalQueueTicksMask;
            switch (var10_9) {
                case 0: {
                    if (!this.pool.blockedThreadDetectionEnabled()) ** GOTO lbl53
                    otherIdx = this.random.nextInt(this.pool.getWorkerThreads().length);
                    if (otherIdx == this.idx) {
                        otherIdx = (this.idx + Math.max(1, this.random.nextInt(this.pool.getWorkerThreads().length - 1))) % this.pool.getWorkerThreads().length;
                    }
                    thread = this.pool.getWorkerThreads()[otherIdx];
                    state = thread.getState();
                    parked = thread.parked();
                    if (parked == null || parked.get()) ** GOTO lbl53
                    v1 = state;
                    var15_14 = Thread.State.BLOCKED;
                    if (!(v1 == null ? var15_14 != null : v1.equals((Object)var15_14) == false)) ** GOTO lbl52
                    v2 = state;
                    var16_15 = Thread.State.WAITING;
                    if (!(v2 == null ? var16_15 != null : v2.equals((Object)var16_15) == false)) ** GOTO lbl52
                    v3 = state;
                    var17_16 = Thread.State.TIMED_WAITING;
                    if (v3 != null ? v3.equals((Object)var17_16) == false : var17_16 != null) ** GOTO lbl53
lbl52:
                    // 3 sources

                    System.err.println(this.mkWarning(state, thread.getStackTrace()));
lbl53:
                    // 4 sources

                    if ((element = this.external.poll(rnd)) instanceof Runnable[]) {
                        batch = (Runnable[])element;
                        this.queue.drainBatch(this.external, rnd);
                        fiber = this.queue.enqueueBatch(batch, self);
                        this.pool.notifyParked(rnd);
                        try {
                            fiber.run();
                        }
                        catch (Throwable var21_20) {
                            t = var22_21 = var21_20;
                            if (NonFatal$.MODULE$.apply(t)) {
                                this.pool.reportFailure(t);
                            }
                            if (var22_21 != null) {
                                t = var22_21;
                                IOFiber$.MODULE$.onFatalFailure(t);
                            }
                            throw var21_20;
                        }
                    } else if (element instanceof Runnable) {
                        fiber = (Runnable)element;
                        if (TracingConstants.isStackTracing) {
                            this._active = fiber;
                            this.parked().lazySet(false);
                        }
                        try {
                            fiber.run();
                        }
                        catch (Throwable var26_25) {
                            t = var27_26 = var26_25;
                            if (NonFatal$.MODULE$.apply(t)) {
                                this.pool.reportFailure(t);
                            }
                            if (var27_26 != null) {
                                t = var27_26;
                                IOFiber$.MODULE$.onFatalFailure(t);
                            }
                            throw var26_25;
                        }
                    }
                    this.now_$eq(System.nanoTime());
                    state = 4;
                    continue block24;
                }
                case 1: {
                    element = this.external.poll(rnd);
                    if (element instanceof Runnable[]) {
                        batch = (Runnable[])element;
                        fiber = this.queue.enqueueBatch(batch, self);
                        this.pool.notifyParked(rnd);
                        try {
                            fiber.run();
                            v4 = BoxedUnit.UNIT;
                        }
                        catch (Throwable var33_32) {
                            t = var34_33 = var33_32;
                            if (NonFatal$.MODULE$.apply(t)) {
                                this.pool.reportFailure(t);
                                v4 = BoxedUnit.UNIT;
                            }
                            if (var34_33 != null) {
                                t = var34_33;
                                IOFiber$.MODULE$.onFatalFailure(t);
                                v4 = null;
                            }
                            throw var33_32;
                        }
                        state = 4;
                        continue block24;
                    }
                    if (element instanceof Runnable) {
                        fiber = (Runnable)element;
                        if (TracingConstants.isStackTracing) {
                            this._active = fiber;
                            this.parked().lazySet(false);
                        }
                        try {
                            fiber.run();
                            v5 = BoxedUnit.UNIT;
                        }
                        catch (Throwable var38_37) {
                            t = var39_38 = var38_37;
                            if (NonFatal$.MODULE$.apply(t)) {
                                this.pool.reportFailure(t);
                                v5 = BoxedUnit.UNIT;
                            }
                            if (var39_38 != null) {
                                t = var39_38;
                                IOFiber$.MODULE$.onFatalFailure(t);
                                v5 = null;
                            }
                            throw var38_37;
                        }
                        state = 4;
                        continue block24;
                    }
                    if (this.pool.transitionWorkerToSearching()) {
                        state = 2;
                        continue block24;
                    }
                    if (TracingConstants.isStackTracing) {
                        this._active = null;
                    }
                    this.parked().lazySet(true);
                    this.pool.transitionWorkerToParked();
                    state = this.park$1(rnd, done);
                    continue block24;
                }
                case 2: {
                    this.now_$eq(System.nanoTime());
                    if (this.pool.stealTimers(this.now(), rnd)) {
                        this.pool.transitionWorkerFromSearching(rnd);
                        state = 4;
                        continue block24;
                    }
                    fiber = this.pool.stealFromOtherWorkerThread(this.index(), rnd, self);
                    if (fiber != null) {
                        this.pool.transitionWorkerFromSearching(rnd);
                        try {
                            fiber.run();
                            v6 = BoxedUnit.UNIT;
                        }
                        catch (Throwable var43_42) {
                            t = var44_43 = var43_42;
                            if (NonFatal$.MODULE$.apply(t)) {
                                this.pool.reportFailure(t);
                                v6 = BoxedUnit.UNIT;
                            }
                            if (var44_43 != null) {
                                t = var44_43;
                                IOFiber$.MODULE$.onFatalFailure(t);
                                v6 = null;
                            }
                            throw var43_42;
                        }
                        state = 4;
                        continue block24;
                    }
                    if (TracingConstants.isStackTracing) {
                        this._active = null;
                    }
                    this.parked().lazySet(true);
                    if (this.pool.transitionWorkerToParkedWhenSearching()) {
                        this.pool.notifyIfWorkPending(rnd);
                    }
                    state = this.park$1(rnd, done);
                    continue block24;
                }
                case 3: {
                    element = this.external.poll(rnd);
                    if (element instanceof Runnable[]) {
                        batch = (Runnable[])element;
                        this.pool.transitionWorkerFromSearching(rnd);
                        fiber = this.queue.enqueueBatch(batch, self);
                        this.pool.notifyParked(rnd);
                        try {
                            fiber.run();
                            v7 = BoxedUnit.UNIT;
                        }
                        catch (Throwable var50_49) {
                            t = var51_50 = var50_49;
                            if (NonFatal$.MODULE$.apply(t)) {
                                this.pool.reportFailure(t);
                                v7 = BoxedUnit.UNIT;
                            }
                            if (var51_50 != null) {
                                t = var51_50;
                                IOFiber$.MODULE$.onFatalFailure(t);
                                v7 = null;
                            }
                            throw var50_49;
                        }
                        state = 4;
                        continue block24;
                    }
                    if (element instanceof Runnable) {
                        fiber = (Runnable)element;
                        if (TracingConstants.isStackTracing) {
                            this._active = fiber;
                            this.parked().lazySet(false);
                        }
                        this.pool.transitionWorkerFromSearching(rnd);
                        try {
                            fiber.run();
                            v8 = BoxedUnit.UNIT;
                        }
                        catch (Throwable var55_54) {
                            t = var56_55 = var55_54;
                            if (NonFatal$.MODULE$.apply(t)) {
                                this.pool.reportFailure(t);
                                v8 = BoxedUnit.UNIT;
                            }
                            if (var56_55 != null) {
                                t = var56_55;
                                IOFiber$.MODULE$.onFatalFailure(t);
                                v8 = null;
                            }
                            throw var55_54;
                        }
                        state = 4;
                        continue block24;
                    }
                    state = 2;
                    continue block24;
                }
            }
            cont = true;
            while (cont) {
                cb = this.sleepers.pollFirstIfTriggered(this.now());
                if (cb != null) {
                    cb.apply(RightUnit);
                    continue;
                }
                cont = false;
            }
            if (this.cedeBypass == null) {
                v9 = this.queue.dequeue(self);
            } else {
                f = this.cedeBypass;
                this.cedeBypass = null;
                v9 = fiber = f;
            }
            if (fiber != null) {
                try {
                    fiber.run();
                    v10 = BoxedUnit.UNIT;
                }
                catch (Throwable var63_62) {
                    t = var64_63 = var63_62;
                    if (NonFatal$.MODULE$.apply(t)) {
                        this.pool.reportFailure(t);
                        v10 = BoxedUnit.UNIT;
                    }
                    if (var64_63 != null) {
                        t = var64_63;
                        IOFiber$.MODULE$.onFatalFailure(t);
                        v10 = null;
                    }
                    throw var63_62;
                }
                ++state;
                continue;
            }
            state = 1;
        }
    }

    private String mkWarning(Thread.State state, StackTraceElement[] stackTrace) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(297).append("|[WARNING] A Cats Effect worker thread was detected to be in a blocked state (").append((Object)state).append(")\n        |").append(WorkerThread.formatTrace$1(stackTrace)).append("\n        |This is very likely to be due to suspending a blocking call in IO via\n        |`IO.delay` or `IO.apply`. If this is the case then you should use\n        |`IO.blocking` or `IO.interruptible` instead.").toString()));
    }

    public void prepareForBlocking() {
        if (this.blocking) {
            return;
        }
        Runnable bypass = this.cedeBypass;
        if (bypass != null) {
            this.queue.enqueue(bypass, this.external, this.random);
            this.cedeBypass = null;
        }
        this.blocking = true;
        String prefix = this.pool.blockerThreadPrefix();
        this.setName(new java.lang.StringBuilder(1).append(prefix).append("-").append(this.nameIndex()).toString());
        WorkerThread cached = this.pool.cachedThreads().pollFirst();
        if (cached != null) {
            int idx = this.index();
            this.pool.replaceWorker(idx, cached);
            cached.indexTransfer().transfer(Predef$.MODULE$.int2Integer(idx));
            return;
        }
        int idx = this.index();
        WorkerThread clone = new WorkerThread(idx, this.queue, this.parked(), this.external, this.fiberBag, this.sleepers, this.pool);
        String clonePrefix = this.pool.threadPrefix();
        clone.setName(new java.lang.StringBuilder(1).append(clonePrefix).append("-").append(idx).toString());
        this.pool.replaceWorker(idx, clone);
        this.pool.blockedWorkerThreadCounter().incrementAndGet();
        clone.start();
    }

    public <T> T blockOn(Function0<T> thunk, CanAwait permission) {
        this.prepareForBlocking();
        return (T)thunk.apply();
    }

    private void init(int newIdx) {
        this._index = newIdx;
        this.queue = this.pool.localQueues()[newIdx];
        this.sleepers = this.pool.sleepers()[newIdx];
        this.parked_$eq(this.pool.parkedSignals()[newIdx]);
        this.fiberBag = this.pool.fiberBags()[newIdx];
        String prefix = this.pool.threadPrefix();
        this.setName(new java.lang.StringBuilder(1).append(prefix).append("-").append(newIdx).toString());
    }

    public int getSuspendedFiberCount() {
        return this.fiberBag.size();
    }

    private final int park$1(ThreadLocalRandom rnd$1, AtomicBoolean done$1) {
        int n;
        long tt = this.sleepers.peekFirstTriggerTime();
        if (tt == Long.MIN_VALUE) {
            this.parkLoop$1(done$1);
            n = 3;
        } else if (this.parkUntilNextSleeper$1(done$1)) {
            this.pool.transitionWorkerFromSearching(rnd$1);
            n = 4;
        } else {
            n = 3;
        }
        int nextState = n;
        this.now_$eq(System.nanoTime());
        if (nextState != 4) {
            long nextTrigger = this.sleepers.peekFirstTriggerTime();
            if (nextTrigger != Long.MIN_VALUE && nextTrigger - this.now() <= 0L) {
                this.pool.transitionWorkerFromSearching(rnd$1);
                return 4;
            }
            return nextState;
        }
        return nextState;
    }

    private final void parkLoop$1(AtomicBoolean done$2) {
        boolean cont = true;
        while (cont && !done$2.get()) {
            LockSupport.park(this.pool);
            if (this.isInterrupted()) {
                this.pool.shutdown();
                continue;
            }
            cont = this.parked().get();
        }
    }

    private final boolean parkUntilNextSleeper$1(AtomicBoolean done$3) {
        block6: {
            block7: {
                long triggerTime;
                do {
                    if (done$3.get()) {
                        return false;
                    }
                    triggerTime = this.sleepers.peekFirstTriggerTime();
                    if (triggerTime == Long.MIN_VALUE) {
                        this.parkLoop$1(done$3);
                        return false;
                    }
                    this.now_$eq(System.nanoTime());
                    long nanos = triggerTime - this.now();
                    if (nanos <= 0L) break block6;
                    LockSupport.parkNanos(this.pool, nanos);
                    if (this.isInterrupted()) {
                        this.pool.shutdown();
                        return false;
                    }
                    this.now_$eq(System.nanoTime());
                    if (!this.parked().get()) break block7;
                } while (triggerTime - this.now() > 0L);
                if (this.parked().getAndSet(false)) {
                    this.pool.doneSleeping();
                }
                return true;
            }
            return false;
        }
        if (this.parked().getAndSet(false)) {
            this.pool.doneSleeping();
        }
        return true;
    }

    private static final String formatTrace$1(StackTraceElement[] st) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < st.length; ++i) {
            sb.append("  at ");
            sb.append(st[i].toString());
            if (i == st.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

