/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.common;

import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.credentialstore.keepass.SOSKeePassPath;
import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.SOSArgument;
import com.sos.commons.vfs.common.AProviderArguments;
import com.sos.commons.vfs.common.AProviderExtendedArguments;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.linguafranca.pwdb.Entry;

public class CredentialStoreResolver {
    public static boolean resolve(AProviderArguments args, SOSArgument<?> ... additional2resolve) throws Exception {
        if (args.getCredentialStore() == null) {
            return false;
        }
        if (args.getCredentialStore().getFile().getValue() != null && args.getKeepassDatabase() == null) {
            CredentialStoreResolver.setDatabase(args);
            CredentialStoreResolver.keepass2Arguments(args, additional2resolve);
            return true;
        }
        return false;
    }

    public static boolean resolveAttachment(AProviderArguments args, SOSArgument<?> arg) throws Exception {
        Entry<?, ?, ?, ?> entry;
        if (args.getCredentialStore() == null) {
            return false;
        }
        if (args.getKeepassDatabase() == null) {
            if (args.getCredentialStore().getFile().getValue() == null) {
                return false;
            }
            CredentialStoreResolver.setDatabase(args);
        }
        if (arg.getValue() == null) {
            return false;
        }
        SOSKeePassPath keePassPath = new SOSKeePassPath(args.getKeepassDatabase().getHandler().isKdbx(), arg.getValue().toString(), (String)args.getCredentialStore().getEntryPath().getValue());
        if (keePassPath.isValid() && (entry = CredentialStoreResolver.getEntry(args, keePassPath.getEntryPath())) != null) {
            args.setKeepassDatabaseEntry(entry);
            args.setKeepassAttachmentPropertyName(keePassPath.getPropertyName());
            return true;
        }
        return false;
    }

    private static void setDatabase(AProviderArguments args) throws Exception {
        SOSKeePassDatabase kpd = new SOSKeePassDatabase(SOSPath.toAbsolutePath((String)((String)args.getCredentialStore().getFile().getValue())), SOSKeePassDatabase.getModule((String)((String)args.getCredentialStore().getKeePassModule().getValue())));
        Path keyFile = null;
        if (args.getCredentialStore().getKeyFile().getValue() != null) {
            Path cskf = SOSPath.toAbsolutePath((String)((String)args.getCredentialStore().getKeyFile().getValue()));
            if (Files.notExists(cskf, new LinkOption[0])) {
                throw new Exception(String.format("[%s]key file not found", SOSKeePassDatabase.getFilePath((Path)cskf)));
            }
            keyFile = cskf;
        } else {
            keyFile = SOSKeePassDatabase.getDefaultKeyFile((Path)SOSPath.toAbsolutePath((String)((String)args.getCredentialStore().getFile().getValue())));
            if (keyFile == null && SOSString.isEmpty((String)((String)args.getCredentialStore().getPassword().getValue()))) {
                throw new Exception(String.format("default key file not found. password is empty", new Object[0]));
            }
        }
        if (keyFile == null) {
            kpd.load((String)args.getCredentialStore().getPassword().getValue());
        } else {
            kpd.load((String)args.getCredentialStore().getPassword().getValue(), keyFile);
        }
        args.setKeepassDatabase(kpd);
    }

    private static Entry<?, ?, ?, ?> keepass2Arguments(AProviderArguments args, SOSArgument<?> ... additional2resolve) throws Exception {
        AProviderExtendedArguments ext;
        Entry<?, ?, ?, ?> entry = CredentialStoreResolver.keepass2Argument(args, args.getHost(), null);
        entry = CredentialStoreResolver.keepass2Argument(args, args.getUser(), entry);
        entry = CredentialStoreResolver.keepass2Argument(args, args.getPassword(), entry);
        if (args instanceof AProviderExtendedArguments && (ext = (AProviderExtendedArguments)args).getProxy() != null) {
            entry = CredentialStoreResolver.keepass2Argument(args, ext.getProxyHost(), entry);
            entry = CredentialStoreResolver.keepass2Argument(args, ext.getProxyUser(), entry);
            entry = CredentialStoreResolver.keepass2Argument(args, ext.getProxyPassword(), entry);
            ext.recreateProxy();
        }
        if (additional2resolve != null) {
            for (SOSArgument<?> arg : additional2resolve) {
                CredentialStoreResolver.keepass2Argument(args, arg, entry);
            }
        }
        return entry;
    }

    private static Entry<?, ?, ?, ?> keepass2Argument(AProviderArguments args, SOSArgument<?> arg, Entry<?, ?, ?, ?> lastEntry) throws Exception {
        if (arg.getName() == null || arg.getValue() == null) {
            return lastEntry;
        }
        SOSKeePassPath keePassPath = new SOSKeePassPath(args.getKeepassDatabase().getHandler().isKdbx(), arg.getValue().toString(), (String)args.getCredentialStore().getEntryPath().getValue());
        Entry<?, ?, ?, ?> entry = null;
        String fileName = ((String)args.getCredentialStore().getFile().getValue()).toString();
        String argName = arg.getName();
        if (keePassPath.isValid()) {
            entry = lastEntry == null || !keePassPath.getEntryPath().equals(lastEntry.getPath()) ? CredentialStoreResolver.getEntry(args, keePassPath.getEntry()) : lastEntry;
            String value = entry.getProperty(keePassPath.getPropertyName());
            if (value == null) {
                throw new Exception(String.format("[%s][%s][%s]value is null", fileName, argName, keePassPath.toString()));
            }
            boolean setMultipleValue = false;
            AProviderExtendedArguments ext = null;
            if (args instanceof AProviderExtendedArguments) {
                ext = (AProviderExtendedArguments)args;
            }
            if (argName.equals(args.getHost().getName()) || ext != null && argName.equals(ext.getProxyHost().getName())) {
                String[] arr = value.split(":");
                switch (arr.length) {
                    case 1: {
                        break;
                    }
                    default: {
                        setMultipleValue = true;
                        if (argName.equals(args.getHost().getName())) {
                            args.getHost().setValue((Object)arr[0]);
                            if (!(args instanceof SSHProviderArguments)) break;
                            SSHProviderArguments sshArgs = (SSHProviderArguments)args;
                            sshArgs.getPort().setValue((Object)Integer.parseInt(arr[1]));
                            break;
                        }
                        if (ext == null) break;
                        ext.getProxyHost().setValue((Object)arr[0]);
                        ext.getProxyPort().setValue((Object)Integer.parseInt(arr[1]));
                    }
                }
            }
            if (!setMultipleValue) {
                arg.fromString(value);
            }
        }
        return entry == null ? lastEntry : entry;
    }

    private static Entry<?, ?, ?, ?> getEntry(AProviderArguments args, String entryPath) throws Exception {
        Entry entry = args.getKeepassDatabase().getEntryByPath(entryPath);
        if (entry == null) {
            throw new Exception(String.format("[%s][%s]entry not found", args.getCredentialStore().getFile().getValue(), entryPath));
        }
        if (entry.getExpires()) {
            throw new Exception(String.format("[%s][%s]entry is expired (%s)", args.getCredentialStore().getFile().getValue(), entryPath, entry.getExpiryTime()));
        }
        return entry;
    }
}

