/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.common.file.selection;

import com.sos.commons.vfs.common.file.ProviderFile;
import com.sos.commons.vfs.common.file.selection.ProviderFileSelectionConfig;
import com.sos.commons.vfs.common.file.selection.ProviderFileSelectionResult;

public class ProviderFileSelection {
    private ProviderFileSelectionConfig config;
    private ProviderFileSelectionResult result;

    public static ProviderFileSelection createIfNull(ProviderFileSelection selection) {
        return selection == null ? new ProviderFileSelection(new ProviderFileSelectionConfig.Builder().build()) : selection;
    }

    public ProviderFileSelection(ProviderFileSelectionConfig config) {
        this.config = config;
        this.result = new ProviderFileSelectionResult();
    }

    public boolean maxFilesExceeded(int currentSize) {
        return this.config.isFilterByMaxFilesEnabled() && currentSize >= this.config.getMaxFiles();
    }

    public boolean checkDirectory(String filePath) {
        return this.config.getExcludedDirectoriesPattern() == null || !this.config.getExcludedDirectoriesPattern().matcher(filePath).find();
    }

    public boolean checkFileName(String fileName) {
        if (this.config.getExcludedFileExtension() != null && fileName.endsWith(this.config.getExcludedFileExtension())) {
            return false;
        }
        return this.config.getFileNamePattern() == null || this.config.getFileNamePattern().matcher(fileName).find();
    }

    public boolean checkProviderFileMinMaxSize(ProviderFile file) {
        if (!this.checkProviderFileMaxSize(file)) {
            return false;
        }
        return this.checkProviderFileMinSize(file);
    }

    public boolean checkProviderFileMaxSize(ProviderFile file) {
        return !this.config.isFilterByMaxFileSizeEnabled() || file.getSize() <= this.config.getMaxFileSize();
    }

    public boolean checkProviderFileMinSize(ProviderFile file) {
        return !this.config.isFilterByMinFileSizeEnabled() || file.getSize() >= this.config.getMinFileSize();
    }

    public ProviderFileSelectionConfig getConfig() {
        return this.config;
    }

    public ProviderFileSelectionResult getResult() {
        return this.result;
    }
}

