/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.common;

import com.google.common.base.Joiner;
import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSPathUtil;
import com.sos.commons.util.common.SOSArgument;
import com.sos.commons.util.common.logger.ISOSLogger;
import com.sos.commons.vfs.common.AProvider;
import com.sos.commons.vfs.common.CredentialStoreResolver;
import com.sos.commons.vfs.exception.SOSProviderException;
import com.sos.commons.vfs.exception.SOSProviderInitializationException;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import com.sos.commons.vfs.ssh.common.SSHServerInfo;
import java.util.List;

public abstract class ASSHProvider
extends AProvider<SSHProviderArguments> {
    private SSHServerInfo serverInfo;
    private String serverVersion;

    public ASSHProvider() throws SOSProviderInitializationException {
        super(null, null);
    }

    public ASSHProvider(ISOSLogger logger, SSHProviderArguments args) throws SOSProviderInitializationException {
        super(logger, args);
        this.resolveCredentialStore();
        this.setAccessInfo(String.format("%s@%s:%s", ((SSHProviderArguments)((Object)this.getArguments())).getUser().getDisplayValue(), ((SSHProviderArguments)((Object)this.getArguments())).getHost().getDisplayValue(), ((SSHProviderArguments)((Object)this.getArguments())).getPort().getDisplayValue()));
    }

    public abstract void put(String var1, String var2, int var3) throws SOSProviderException;

    public abstract void put(String var1, String var2) throws SOSProviderException;

    public abstract void get(String var1, String var2) throws SOSProviderException;

    @Override
    public boolean isAbsolutePath(String path) {
        return SOSPathUtil.isAbsoluteFileSystemPath((String)path);
    }

    @Override
    public String getPathSeparator() {
        return "/";
    }

    public SSHServerInfo getServerInfo() {
        if (this.serverInfo == null) {
            this.serverInfo = new SSHServerInfo(this.serverVersion, this.executeCommand("uname"));
        }
        return this.serverInfo;
    }

    public void setServerVersion(String val) {
        this.serverVersion = val;
    }

    public String getConnectedMsg(List<String> additionalInfos) {
        Object msg = "";
        if (SOSCollection.isEmpty(additionalInfos)) {
            if (this.serverInfo != null) {
                msg = (String)msg + this.serverInfo.toString();
            }
        } else {
            if (this.serverInfo != null) {
                msg = (String)msg + "[" + this.serverInfo.toString() + "]";
            }
            msg = (String)msg + Joiner.on((String)", ").join(additionalInfos);
        }
        return this.getConnectedMsg((String)msg);
    }

    private void resolveCredentialStore() throws SOSProviderInitializationException {
        try {
            if (CredentialStoreResolver.resolve(this.getArguments(), new SOSArgument[]{((SSHProviderArguments)((Object)this.getArguments())).getPassphrase()})) {
                CredentialStoreResolver.resolveAttachment(this.getArguments(), ((SSHProviderArguments)((Object)this.getArguments())).getAuthFile());
            }
        }
        catch (Throwable e) {
            throw new SOSProviderInitializationException(e);
        }
    }
}

