/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.sshj;

import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.SOSCommandResult;
import com.sos.commons.util.common.SOSEnv;
import com.sos.commons.util.common.SOSTimeout;
import com.sos.commons.util.common.logger.ISOSLogger;
import com.sos.commons.vfs.common.file.ProviderFile;
import com.sos.commons.vfs.common.file.files.DeleteFilesResult;
import com.sos.commons.vfs.common.file.files.RenameFilesResult;
import com.sos.commons.vfs.common.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.common.proxy.Proxy;
import com.sos.commons.vfs.common.proxy.ProxySocketFactory;
import com.sos.commons.vfs.exception.SOSAuthenticationFailedException;
import com.sos.commons.vfs.exception.SOSProviderConnectException;
import com.sos.commons.vfs.exception.SOSProviderException;
import com.sos.commons.vfs.exception.SOSProviderInitializationException;
import com.sos.commons.vfs.ssh.common.ASSHProvider;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import com.sos.commons.vfs.ssh.exceptions.SOSSSHClientNotInitializedException;
import com.sos.commons.vfs.ssh.exceptions.SOSSSHCommandExitViolentlyException;
import com.sos.commons.vfs.ssh.sshj.SSHJProviderUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.Signal;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.method.PasswordResponseProvider;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;

public class SSHJProvider
extends ASSHProvider {
    private Config config;
    private SSHClient sshClient;
    private Map<String, Session.Command> commands = new ConcurrentHashMap<String, Session.Command>();

    public SSHJProvider(ISOSLogger logger, SSHProviderArguments args) throws SOSProviderInitializationException {
        super(logger, args);
    }

    @Override
    public void connect() throws SOSProviderConnectException {
        if (SOSString.isEmpty((String)((String)((SSHProviderArguments)((Object)this.getArguments())).getHost().getValue()))) {
            throw new SOSProviderConnectException((Throwable)new SOSRequiredArgumentMissingException("host"));
        }
        try {
            this.getLogger().info((Object)this.getConnectMsg());
            this.createSSHClient();
            this.sshClient.connect((String)((SSHProviderArguments)((Object)this.getArguments())).getHost().getValue(), ((Integer)((SSHProviderArguments)((Object)this.getArguments())).getPort().getValue()).intValue());
            this.authenticate();
            this.setKeepAlive();
            this.setServerVersion(this.sshClient.getTransport().getServerVersion());
            this.getServerInfo();
            this.getLogger().info((Object)this.getConnectedMsg(SSHJProviderUtil.getConnectedInfos(this.sshClient)));
        }
        catch (Throwable e) {
            throw new SOSProviderConnectException(String.format("[%s]", this.getAccessInfo()), e);
        }
    }

    @Override
    public boolean isConnected() {
        if (this.sshClient == null) {
            return false;
        }
        return this.sshClient.isConnected();
    }

    @Override
    public void disconnect() {
        this.commands = new ConcurrentHashMap<String, Session.Command>();
        this.closeQuietly((Closeable)this.sshClient);
        this.sshClient = null;
        this.getLogger().info((Object)this.getDisconnectedMsg());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean createDirectoriesIfNotExist(String path) throws SOSProviderException {
        this.checkBeforeOperation("createDirectoriesIfNotExist", this.sshClient, path, "path");
        try (SFTPClient sftp = this.sshClient.newSFTPClient();){
            if (SSHJProviderUtil.exists(sftp, path)) {
                boolean bl2 = false;
                return bl2;
            }
            sftp.mkdirs(path);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean deleteIfExists(String path) throws SOSProviderException {
        boolean bl;
        block12: {
            this.checkBeforeOperation("deleteIfExists", this.sshClient, path, "path");
            SFTPClient sftp = this.sshClient.newSFTPClient();
            try {
                SSHJProviderUtil.delete(sftp, path);
                bl = true;
                if (sftp == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (sftp != null) {
                            try {
                                sftp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SOSProviderException e) {
                        if (e.getCause() instanceof SOSNoSuchFileException) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("%s[deleteIfExists]not exists", new Object[]{this.getPathOperationPrefix(path)});
                            }
                            return false;
                        }
                        throw e;
                    }
                }
                catch (Throwable e) {
                    throw new SOSProviderException(this.getPathOperationPrefix(path), e.getCause());
                }
            }
            sftp.close();
        }
        return bl;
    }

    @Override
    public DeleteFilesResult deleteFilesIfExist(Collection<String> files, boolean stopOnSingleFileError) throws SOSProviderException {
        if (files == null) {
            return null;
        }
        this.checkBeforeOperation("deleteFilesIfExist", this.sshClient);
        DeleteFilesResult r = new DeleteFilesResult(files.size());
        try (SFTPClient sftp = this.sshClient.newSFTPClient();){
            for (String file : files) {
                try {
                    if (SSHJProviderUtil.exists(sftp, file)) {
                        SSHJProviderUtil.delete(sftp, file);
                        r.addSuccess();
                        continue;
                    }
                    r.addNotFound(file);
                }
                catch (Throwable e) {
                    r.addError(file, e);
                    if (!stopOnSingleFileError) continue;
                    break;
                }
            }
        }
        catch (Throwable e) {
            new SOSProviderException(e);
        }
        return r;
    }

    @Override
    public RenameFilesResult renameFilesIfExist(Map<String, String> files, boolean stopOnSingleFileError) throws SOSProviderException {
        if (files == null) {
            return null;
        }
        this.checkBeforeOperation("renameFilesIfExist", this.sshClient);
        RenameFilesResult r = new RenameFilesResult(files.size());
        try (SFTPClient sftp = this.sshClient.newSFTPClient();){
            for (Map.Entry<String, String> entry : files.entrySet()) {
                String source = entry.getKey();
                String target = entry.getValue();
                try {
                    if (SSHJProviderUtil.exists(sftp, source)) {
                        SSHJProviderUtil.rename(sftp, source, target);
                        r.addSuccess(source, target);
                        continue;
                    }
                    r.addNotFound(source);
                }
                catch (Throwable e) {
                    r.addError(source, e);
                    if (!stopOnSingleFileError) continue;
                    break;
                }
            }
        }
        catch (Throwable e) {
            new SOSProviderException(e);
        }
        return r;
    }

    @Override
    public boolean exists(String path) {
        boolean bl;
        block10: {
            if (this.sshClient == null) {
                return false;
            }
            SFTPClient sftp = this.sshClient.newSFTPClient();
            try {
                this.checkParam("exists", path, "path");
                bl = SSHJProviderUtil.exists(sftp, path);
                if (sftp == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (sftp != null) {
                        try {
                            sftp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("%s[exists=false]%s", new Object[]{this.getPathOperationPrefix(path), e.toString()});
                    }
                    return false;
                }
            }
            sftp.close();
        }
        return bl;
    }

    @Override
    public List<ProviderFile> selectFiles(ProviderFileSelection selection) throws SOSProviderException {
        this.checkBeforeOperation("selectFiles", this.sshClient);
        selection = ProviderFileSelection.createIfNull(selection);
        String directory = selection.getConfig().getDirectory() == null ? "." : selection.getConfig().getDirectory();
        ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
        SSHJProviderUtil.selectFiles(this.getLogger(), this.getLogger().isDebugEnabled(), this.getLogPrefix(), this.sshClient, this.getProviderFileCreator(), selection, directory, result);
        return result;
    }

    @Override
    public ProviderFile getFileIfExists(String path) throws SOSProviderException {
        this.checkBeforeOperation("getFileIfExists", this.sshClient, path, "path");
        ProviderFile f = null;
        try (SFTPClient sftp2 = this.sshClient.newSFTPClient();){
            FileAttributes attr = sftp2.stat(path);
            if (attr != null && SSHJProviderUtil.isFileType(attr.getType())) {
                f = this.createProviderFile(path, attr.getSize(), SSHJProviderUtil.getFileLastModifiedMillis(attr));
            }
        }
        catch (NoSuchFileException sftp2) {
        }
        catch (IOException e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
        return f;
    }

    @Override
    public ProviderFile rereadFileIfExists(ProviderFile file) throws SOSProviderException {
        this.checkBeforeOperation("rereadFileIfExists", this.sshClient);
        try (SFTPClient sftp = this.sshClient.newSFTPClient();){
            FileAttributes attr = sftp.stat(file.getFullPath());
            if (attr != null && SSHJProviderUtil.isFileType(attr.getType())) {
                file.setSize(attr.getSize());
                file.setLastModifiedMillis(SSHJProviderUtil.getFileLastModifiedMillis(attr));
            }
        }
        catch (NoSuchFileException e) {
            file = null;
        }
        catch (IOException e) {
            throw new SOSProviderException(this.getPathOperationPrefix(file.getFullPath()), e);
        }
        return file;
    }

    @Override
    public boolean isDirectory(String path) {
        boolean bl;
        block10: {
            if (this.sshClient == null) {
                return false;
            }
            SFTPClient sftp = this.sshClient.newSFTPClient();
            try {
                this.checkParam("isDirectory", path, "path");
                bl = SSHJProviderUtil.is(this.getLogger(), this.getLogPrefix(), sftp, path, FileMode.Type.DIRECTORY);
                if (sftp == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (sftp != null) {
                        try {
                            sftp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("%s[isDirectory=false]%s", new Object[]{this.getPathOperationPrefix(path), e.toString()});
                    }
                    return false;
                }
            }
            sftp.close();
        }
        return bl;
    }

    @Override
    public void setFileLastModifiedFromMillis(String path, long milliseconds) throws SOSProviderException {
        this.checkBeforeOperation("setFileLastModifiedFromMillis", this.sshClient, path, path);
        this.checkModificationTime(path, milliseconds);
        try (SFTPClient sftp = this.sshClient.newSFTPClient();){
            FileAttributes attr = sftp.stat(path);
            long seconds = milliseconds / 1000L;
            FileAttributes newAttr = new FileAttributes.Builder().withAtimeMtime(attr.getAtime(), seconds).build();
            sftp.setattr(path, newAttr);
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    private void setProxy() {
        Proxy proxy = ((SSHProviderArguments)((Object)this.getArguments())).getProxy();
        if (proxy != null) {
            this.sshClient.setSocketFactory((SocketFactory)((Object)new ProxySocketFactory(proxy)));
        }
    }

    @Override
    public void put(String source, String target, int perm) throws SOSProviderException {
        try (SFTPClient sftp = this.sshClient.newSFTPClient();){
            SSHJProviderUtil.put(sftp, source, target);
            sftp.chmod(target, perm);
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(source) + "[" + target + "][perm=" + perm + "]", e);
        }
    }

    @Override
    public void put(String source, String target) throws SOSProviderException {
        try (SFTPClient sftp = this.sshClient.newSFTPClient();){
            SSHJProviderUtil.put(sftp, source, target);
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(source) + "[" + target + "]", e);
        }
    }

    @Override
    public void get(String source, String target) throws SOSProviderException {
        try (SFTPClient sftp = this.sshClient.newSFTPClient();){
            sftp.get(sftp.canonicalize(source), (LocalDestFile)new FileSystemFile(target));
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(source) + "[" + target + "]", e);
        }
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout, SOSEnv env) {
        SOSCommandResult result = new SOSCommandResult(command);
        if (this.sshClient == null) {
            return result;
        }
        String uuid = this.getUUID();
        try (Session session = this.sshClient.startSession();){
            if (((Boolean)((SSHProviderArguments)((Object)this.getArguments())).getSimulateShell().getValue()).booleanValue()) {
                session.allocateDefaultPTY();
            }
            result.setCommand(this.handleEnvs(command, session, env));
            try (Session.Command cmd = session.exec(result.getCommand());){
                this.commands.put(uuid, cmd);
                result.setStdOut(IOUtils.readFully((InputStream)cmd.getInputStream()).toString());
                result.setStdErr(IOUtils.readFully((InputStream)cmd.getErrorStream()).toString());
                if (timeout == null) {
                    cmd.join();
                } else {
                    cmd.join(timeout.getInterval(), timeout.getTimeUnit());
                }
                result.setExitCode(cmd.getExitStatus());
                if (result.getExitCode() == null && cmd.getExitSignal() != null) {
                    throw new SOSSSHCommandExitViolentlyException(cmd.getExitSignal(), cmd.getExitErrorMessage());
                }
            }
        }
        catch (Throwable e) {
            result.setException(e);
        }
        this.resetCommand(uuid);
        return result;
    }

    private synchronized String getUUID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public SOSCommandResult cancelCommands() {
        SOSCommandResult r = null;
        if (this.commands != null && this.commands.size() > 0) {
            r = new SOSCommandResult("Signal.KILL");
            Iterator<Map.Entry<String, Session.Command>> iterator = this.commands.entrySet().iterator();
            while (iterator.hasNext()) {
                try {
                    Session.Command command = iterator.next().getValue();
                    command.signal(Signal.KILL);
                    r.setExitCode(command.getExitStatus());
                }
                catch (SSHException e) {
                    r.setException((Throwable)e);
                }
                iterator.remove();
            }
        }
        return r;
    }

    private void resetCommand(String uuid) {
        this.commands.remove(uuid);
    }

    public SSHClient getSSHClient() {
        return this.sshClient;
    }

    private void createSSHClient() throws Exception {
        this.config = new DefaultConfig();
        this.setKeepAliveProvider();
        this.sshClient = new SSHClient(this.config);
        this.setHostKeyVerifier();
        this.setCompression();
        this.setRemoteCharset();
        this.setTimeout();
        this.setProxy();
    }

    private void setKeepAliveProvider() {
        if (!((SSHProviderArguments)((Object)this.getArguments())).getServerAliveInterval().isEmpty()) {
            this.config.setKeepAliveProvider(KeepAliveProvider.KEEP_ALIVE);
        }
    }

    private void setKeepAlive() {
        if (!((SSHProviderArguments)((Object)this.getArguments())).getServerAliveInterval().isEmpty()) {
            this.sshClient.getConnection().getKeepAlive().setKeepAliveInterval(((Integer)((SSHProviderArguments)((Object)this.getArguments())).getServerAliveInterval().getValue()).intValue());
        }
    }

    private void setHostKeyVerifier() throws IOException {
        if (((Boolean)((SSHProviderArguments)((Object)this.getArguments())).getStrictHostkeyChecking().getValue()).booleanValue()) {
            if (((SSHProviderArguments)((Object)this.getArguments())).getHostkeyLocation().isEmpty()) {
                this.sshClient.loadKnownHosts();
            } else {
                this.sshClient.loadKnownHosts(((Path)((SSHProviderArguments)((Object)this.getArguments())).getHostkeyLocation().getValue()).toFile());
            }
        } else {
            this.sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        }
    }

    private void setCompression() throws TransportException {
        if (((Boolean)((SSHProviderArguments)((Object)this.getArguments())).getUseZlibCompression().getValue()).booleanValue()) {
            this.sshClient.useCompression();
        }
    }

    private void setRemoteCharset() throws TransportException {
        this.sshClient.setRemoteCharset((Charset)((SSHProviderArguments)((Object)this.getArguments())).getRemoteCharset().getValue());
    }

    private void setTimeout() {
        this.sshClient.setTimeout(((SSHProviderArguments)((Object)this.getArguments())).getSocketTimeoutAsMs().intValue());
        this.sshClient.setConnectTimeout(((SSHProviderArguments)((Object)this.getArguments())).getConnectTimeoutAsMs().intValue());
    }

    private void authenticate() throws Exception {
        if (!((SSHProviderArguments)((Object)this.getArguments())).getPreferredAuthentications().isEmpty()) {
            this.usePreferredAuthentications();
        } else if (!((SSHProviderArguments)((Object)this.getArguments())).getRequiredAuthentications().isEmpty()) {
            this.useRequiredAuthentications();
        } else {
            this.useAuthMethodAuthentication();
        }
    }

    private void usePreferredAuthentications() throws Exception {
        LinkedList<Object> methods = new LinkedList<Object>();
        for (SSHProviderArguments.AuthMethod am : (List)((SSHProviderArguments)((Object)this.getArguments())).getPreferredAuthentications().getValue()) {
            switch (am) {
                case PUBLICKEY: {
                    methods.add(this.getAuthPublickey());
                    break;
                }
                case PASSWORD: {
                    methods.add(this.getAuthPassword());
                    break;
                }
                case KEYBOARD_INTERACTIVE: {
                    methods.add(this.getAuthKeyboardInteractive());
                }
            }
        }
        this.sshClient.auth((String)((SSHProviderArguments)((Object)this.getArguments())).getUser().getValue(), methods);
    }

    private void useRequiredAuthentications() throws Exception {
        for (SSHProviderArguments.AuthMethod am : (List)((SSHProviderArguments)((Object)this.getArguments())).getRequiredAuthentications().getValue()) {
            switch (am) {
                case PUBLICKEY: {
                    this.partialAuthentication((AuthMethod)this.getAuthPublickey());
                    break;
                }
                case PASSWORD: {
                    this.partialAuthentication((AuthMethod)this.getAuthPassword());
                    break;
                }
                case KEYBOARD_INTERACTIVE: {
                    this.partialAuthentication((AuthMethod)this.getAuthKeyboardInteractive());
                }
            }
        }
    }

    private void partialAuthentication(AuthMethod method) throws SOSAuthenticationFailedException, UserAuthException, TransportException {
        if (!this.sshClient.getUserAuth().authenticate((String)((SSHProviderArguments)((Object)this.getArguments())).getUser().getValue(), (Service)this.sshClient.getConnection(), method, this.sshClient.getTransport().getTimeoutMs()) && !this.sshClient.getUserAuth().hadPartialSuccess()) {
            throw new SOSAuthenticationFailedException();
        }
    }

    private void useAuthMethodAuthentication() throws Exception {
        if (((SSHProviderArguments)((Object)this.getArguments())).getAuthMethod().getValue() == null) {
            throw new SOSRequiredArgumentMissingException(((SSHProviderArguments)((Object)this.getArguments())).getAuthMethod().getName());
        }
        AuthPublickey method = null;
        switch ((SSHProviderArguments.AuthMethod)((Object)((SSHProviderArguments)((Object)this.getArguments())).getAuthMethod().getValue())) {
            case PUBLICKEY: {
                method = this.getAuthPublickey();
                break;
            }
            case PASSWORD: {
                method = this.getAuthPassword();
                break;
            }
            case KEYBOARD_INTERACTIVE: {
                method = this.getAuthKeyboardInteractive();
            }
        }
        this.sshClient.auth((String)((SSHProviderArguments)((Object)this.getArguments())).getUser().getValue(), new AuthMethod[]{method});
    }

    private AuthPassword getAuthPassword() throws SOSRequiredArgumentMissingException, UserAuthException, TransportException {
        if (((SSHProviderArguments)((Object)this.getArguments())).getPassword().isEmpty()) {
            throw new SOSRequiredArgumentMissingException(((SSHProviderArguments)((Object)this.getArguments())).getPassword().getName());
        }
        return new AuthPassword(SSHJProviderUtil.getPasswordFinder((String)((SSHProviderArguments)((Object)this.getArguments())).getPassword().getValue()));
    }

    private AuthKeyboardInteractive getAuthKeyboardInteractive() throws SOSRequiredArgumentMissingException, UserAuthException, TransportException {
        if (((SSHProviderArguments)((Object)this.getArguments())).getPassword().isEmpty()) {
            throw new SOSRequiredArgumentMissingException(((SSHProviderArguments)((Object)this.getArguments())).getPassword().getName());
        }
        return new AuthKeyboardInteractive((ChallengeResponseProvider)new PasswordResponseProvider(SSHJProviderUtil.getPasswordFinder((String)((SSHProviderArguments)((Object)this.getArguments())).getPassword().getValue())));
    }

    private AuthPublickey getAuthPublickey() throws Exception {
        KeyProvider keyProvider = null;
        if (((SSHProviderArguments)((Object)this.getArguments())).getKeepassDatabase() != null && ((SSHProviderArguments)((Object)this.getArguments())).getKeepassDatabaseEntry() != null && !SOSString.isEmpty((String)((SSHProviderArguments)((Object)this.getArguments())).getKeepassAttachmentPropertyName())) {
            keyProvider = SSHJProviderUtil.getKeyProviderFromKeepass(this.sshClient, (SSHProviderArguments)((Object)this.getArguments()));
        } else {
            if (SOSString.isEmpty((String)((String)((SSHProviderArguments)((Object)this.getArguments())).getAuthFile().getValue()))) {
                throw new SOSRequiredArgumentMissingException(((SSHProviderArguments)((Object)this.getArguments())).getAuthFile().getName());
            }
            Path authFile = Paths.get((String)((SSHProviderArguments)((Object)this.getArguments())).getAuthFile().getValue(), new String[0]);
            keyProvider = ((SSHProviderArguments)((Object)this.getArguments())).getPassphrase().isEmpty() ? this.sshClient.loadKeys(authFile.toFile().getCanonicalPath()) : this.sshClient.loadKeys(authFile.toFile().getCanonicalPath(), (String)((SSHProviderArguments)((Object)this.getArguments())).getPassphrase().getValue());
        }
        return new AuthPublickey(keyProvider);
    }

    private String handleEnvs(String command, Session session, SOSEnv env) throws Exception {
        if (env == null) {
            return command;
        }
        if (env.getGlobalEnvs() != null && env.getGlobalEnvs().size() > 0) {
            for (Map.Entry entry : env.getGlobalEnvs().entrySet()) {
                try {
                    session.setEnvVar((String)entry.getKey(), (String)entry.getValue());
                }
                catch (Throwable e) {
                    throw new Exception(String.format("[can't set ssh session environment variable][%s=%s]%s", entry.getKey(), entry.getValue(), e.toString()), e);
                }
            }
        }
        if (env.getLocalEnvs() != null && env.getLocalEnvs().size() > 0) {
            this.getServerInfo();
            StringBuilder envs = new StringBuilder();
            for (Map.Entry entry : env.getLocalEnvs().entrySet()) {
                if (this.getServerInfo().hasWindowsShell()) {
                    envs.append(String.format("set %s=%s&", entry.getKey(), entry.getValue()));
                    continue;
                }
                envs.append(String.format("export \"%s=%s\";", entry.getKey(), entry.getValue()));
            }
            command = envs.toString() + (String)command;
        }
        return command;
    }

    @Override
    public InputStream getInputStream(String path) throws SOSProviderException {
        this.checkBeforeOperation("getInputStream", this.sshClient, path, "path");
        final AtomicReference<SFTPClient> sftpRef = new AtomicReference<SFTPClient>();
        try {
            RemoteFile remoteFile;
            sftpRef.set(this.sshClient.newSFTPClient());
            RemoteFile remoteFile2 = remoteFile = ((SFTPClient)sftpRef.get()).open(path);
            Objects.requireNonNull(remoteFile2);
            return new RemoteFile.ReadAheadRemoteFileInputStream(remoteFile2, 16){
                private final AtomicBoolean close;
                {
                    RemoteFile remoteFile2 = x0;
                    Objects.requireNonNull(remoteFile2);
                    super(remoteFile2, arg0);
                    this.close = new AtomicBoolean();
                }

                public void close() throws IOException {
                    if (this.close.get()) {
                        return;
                    }
                    try {
                        super.close();
                    }
                    finally {
                        SSHJProvider.this.closeQuietly((Closeable)remoteFile);
                        SSHJProvider.this.closeQuietly((Closeable)sftpRef.get());
                        this.close.set(true);
                    }
                }
            };
        }
        catch (Throwable e) {
            this.closeQuietly((Closeable)sftpRef.get());
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append) throws SOSProviderException {
        this.checkBeforeOperation("getOutputStream", this.sshClient, path, "path");
        final AtomicReference<SFTPClient> sftpRef = new AtomicReference<SFTPClient>();
        try {
            RemoteFile remoteFile;
            sftpRef.set(this.sshClient.newSFTPClient());
            EnumSet<OpenMode> mode = EnumSet.of(OpenMode.WRITE, OpenMode.CREAT);
            if (append) {
                mode.add(OpenMode.APPEND);
            } else {
                mode.add(OpenMode.TRUNC);
            }
            RemoteFile remoteFile2 = remoteFile = ((SFTPClient)sftpRef.get()).open(path, mode);
            Objects.requireNonNull(remoteFile2);
            return new RemoteFile.RemoteFileOutputStream(remoteFile2, 0L, 16){
                private final AtomicBoolean close;
                {
                    RemoteFile remoteFile2 = x0;
                    Objects.requireNonNull(remoteFile2);
                    super(remoteFile2, arg0, arg1);
                    this.close = new AtomicBoolean();
                }

                public void close() throws IOException {
                    if (this.close.get()) {
                        return;
                    }
                    try {
                        super.close();
                    }
                    finally {
                        SSHJProvider.this.closeQuietly((Closeable)remoteFile);
                        SSHJProvider.this.closeQuietly((Closeable)sftpRef.get());
                        this.close.set(true);
                    }
                }
            };
        }
        catch (Throwable e) {
            this.closeQuietly((Closeable)sftpRef.get());
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getFileContentIfExists(String path) throws SOSProviderException {
        this.checkBeforeOperation("getFileContentIfExists", this.sshClient, path, "path");
        try (SFTPClient sftp = this.sshClient.newSFTPClient();){
            if (!SSHJProviderUtil.exists(sftp, path)) {
                String string2 = null;
                return string2;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (RemoteFile file = sftp.open(path);){
                RemoteFile remoteFile = file;
                Objects.requireNonNull(remoteFile);
                try (RemoteFile.RemoteFileInputStream is = new RemoteFile.RemoteFileInputStream(remoteFile, 0L);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        baos.write(buffer, 0, bytesRead);
                    }
                }
            }
            String string = baos.toString(StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void writeFile(String path, String content) throws SOSProviderException {
        this.checkBeforeOperation("writeFile", this.sshClient, path, "path");
        EnumSet<OpenMode> mode = EnumSet.of(OpenMode.WRITE, OpenMode.CREAT, OpenMode.TRUNC);
        try (SFTPClient sftp = this.sshClient.newSFTPClient();
             RemoteFile remoteFile = sftp.open(path, mode);){
            remoteFile.write(0L, content.getBytes(StandardCharsets.UTF_8), 0, content.length());
        }
        catch (Throwable e) {
            throw new SOSProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    private void checkBeforeOperation(String method, SSHClient ssh) throws SOSProviderException {
        if (ssh == null) {
            throw new SOSSSHClientNotInitializedException(this.getLogPrefix() + method);
        }
    }

    private void checkBeforeOperation(String method, SSHClient ssh, String paramValue, String msg) throws SOSProviderException {
        this.checkBeforeOperation(method, ssh);
        this.checkParam(method, paramValue, msg);
    }
}

