/*
 * Decompiled with CFR 0.152.
 */
package sos.net;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSFTP;
import sos.net.SOSSSLSocketFactory;

public class SOSFTPS
extends SOSFTP {
    protected static final String DEFAULT_SSL_TLS_PROTOCOL = "TLS";
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFTPS.class);
    private String securityProtocol = "TLS";
    private int ftpPort = 990;
    private String proxyHost;
    private int proxyPort;

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol1) {
        this.securityProtocol = securityProtocol1;
    }

    public SOSFTPS(String ftpHost, int ftpPort1, String proxyHost1, int proxyPort1) throws SocketException, IOException, UnknownHostException {
        this.setProxyHost(proxyHost1);
        this.setProxyPort(proxyPort1);
        this.connect(ftpHost, ftpPort1);
    }

    public SOSFTPS(String ftpHost, int ftpPort1) throws SocketException, IOException, UnknownHostException {
        this.initProxy();
        this.connect(ftpHost, ftpPort1);
    }

    public SOSFTPS(String ftpHost) throws Exception {
        if (!this.isConnected()) {
            this.connect(ftpHost, this.getPort());
        }
    }

    @Override
    public void connect(String ftpHost) throws SocketException, IOException {
        if (!this.isConnected()) {
            this.connect(ftpHost, this.getPort());
        }
    }

    @Override
    public void connect(String ftpHost, int ftpPort1) throws SocketException, IOException {
        this.initProxy();
        if (!this.isConnected()) {
            this.setSocketFactory(new SOSSSLSocketFactory(this.getProxyHost(), this.getProxyPort(), this.getSecurityProtocol()));
            try {
                super.connect(ftpHost, ftpPort1);
            }
            catch (NullPointerException e) {
                throw new SocketException("Connect failed! Probably HTTP proxy in use or the entered ftps port is invalid: " + e.toString());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new SocketException("Connect failed, reason: " + e.toString());
            }
            this.sendCommand("PBSZ 0");
            this.sendCommand("PROT P");
            this.enterLocalPassiveMode();
        }
    }

    public int getPort() {
        return this.ftpPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String httpProxyHost) {
        this.proxyHost = httpProxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int httpProxyPort) {
        this.proxyPort = httpProxyPort;
    }

    private void initProxy() {
        if (System.getProperty("proxyHost") != null && !System.getProperty("proxyHost").isEmpty()) {
            this.setProxyHost(System.getProperty("proxyHost"));
        }
        if (System.getProperty("proxyPort") != null && !System.getProperty("proxyPort").isEmpty()) {
            try {
                this.setProxyPort(Integer.parseInt(System.getProperty("proxyPort")));
            }
            catch (Exception ex) {
                throw new NumberFormatException("Non-numeric value is set [proxyPort]: " + System.getProperty("proxyPort"));
            }
        }
        if (System.getProperty("http.proxyHost") != null && !System.getProperty("http.proxyHost").isEmpty()) {
            this.setProxyHost(System.getProperty("http.proxyHost"));
        }
        if (System.getProperty("http.proxyPort") != null && !System.getProperty("http.proxyPort").isEmpty()) {
            try {
                this.setProxyPort(Integer.parseInt(System.getProperty("http.proxyPort")));
            }
            catch (Exception ex) {
                throw new NumberFormatException("Non-numeric value is set [http.proxyPort]: " + System.getProperty("http.proxyPort"));
            }
        }
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SOSFTPS sosftp = null;
        try {
            sosftp = new SOSFTPS("localhost", 21);
            sosftp.login("kb", "kb");
            long s1 = System.currentTimeMillis();
            Vector<String> va = sosftp.nList("/home/kb");
            long e1 = System.currentTimeMillis();
            long l = e1 - s1;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (sosftp != null) {
                sosftp.disconnect();
            }
        }
    }
}

