/*
 * Decompiled with CFR 0.152.
 */
package sos.connection;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.util.SOSClassUtil;
import sos.util.SOSDate;
import sos.util.SOSString;

public class SOSODBCConnection
extends SOSConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSODBCConnection.class);
    private static final String[] REPLACEMENT = new String[]{"LCASE", "UCASE", "NOW()", "FOR UPDATE"};

    public SOSODBCConnection(Connection connection) throws Exception {
        super(connection);
    }

    public SOSODBCConnection(String configFileName) throws Exception {
        super(configFileName);
    }

    public SOSODBCConnection(String driver, String url, String dbuser, String dbpassword) throws Exception {
        super(driver, url, dbuser, dbpassword);
    }

    public SOSODBCConnection(String driver, String url, String dbname, String dbuser, String dbpassword) throws Exception {
        super(driver, url, dbuser, dbpassword);
        if (dbname == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database name.");
        }
        this.dbname = dbname;
    }

    @Override
    public void connect() throws Exception {
        Properties properties = new Properties();
        if (SOSString.isEmpty((String)this.url)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database url.");
        }
        if (SOSString.isEmpty((String)this.driver)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database driver.");
        }
        if (SOSString.isEmpty((String)this.dbuser)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database user.");
        }
        if (SOSString.isEmpty((String)this.dbpassword)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database password.");
        }
        if (!SOSString.isEmpty((String)this.dbname)) {
            properties.setProperty("databasename", this.dbname);
        }
        properties.setProperty("user", this.dbuser);
        properties.setProperty("password", this.dbpassword);
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            Driver driver = (Driver)Class.forName(this.driver).newInstance();
            this.connection = driver.connect(this.url, properties);
            if (this.connection == null) {
                throw new Exception("can't connect to database");
            }
            LOGGER.debug(".. successfully connected to " + this.url);
            this.prepare(this.connection);
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString(), e);
        }
    }

    @Override
    public void prepare(Connection connection) throws Exception {
        try {
            LOGGER.debug("calling " + SOSClassUtil.getMethodName());
            connection.setAutoCommit(false);
            connection.rollback();
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString(), e);
        }
    }

    @Override
    public String toDate(String dateString) throws Exception {
        if (SOSString.isEmpty((String)dateString)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": dateString has no value.");
        }
        return "{ ts '" + dateString + "'}";
    }

    @Override
    protected GregorianCalendar getDateTime(String format) throws Exception {
        GregorianCalendar gc = new GregorianCalendar();
        String timestamp = this.getSingleValue("select CURRENT_TIMESTAMP");
        if (timestamp.length() > 19) {
            timestamp = timestamp.substring(0, 19);
        }
        Date date = SOSDate.getDate((String)timestamp, (String)format);
        gc.setTime(date);
        return gc;
    }

    @Override
    protected String replaceCasts(String inputString) throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        Pattern pattern = Pattern.compile("(\\s*%cast\\s*)*\\s*(\\()*\\s*(\\s*%cast\\s*)+\\s*(\\(\\s*\\S+\\s*(\\S+?).*?)\\)(\\s*(\\+|\\-)*[0-9]*\\s*\\S*(\\)))*");
        Matcher matcher = pattern.matcher(inputString);
        StringBuffer buffer = new StringBuffer();
        LOGGER.trace("..inputString [" + inputString + "]");
        while (matcher.find()) {
            String token;
            String replaceString = matcher.group().toLowerCase();
            if (matcher.group(1) != null && matcher.group(6) != null) {
                token = matcher.group(6).replaceFirst("\\)", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", " as varchar");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", " as character");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", " as integer");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                }
            }
            if (matcher.group(3) != null && matcher.group(4) != null) {
                token = matcher.group(4).replaceFirst("\\(", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", " as varchar");
                    replaceString = replaceString.replaceAll("%cast", "cast");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", " as character");
                    replaceString = replaceString.replaceAll("%cast", "cast");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", " as integer");
                    replaceString = replaceString.replaceAll("%cast", "cast");
                }
            }
            replaceString = replaceString.toUpperCase();
            matcher.appendReplacement(buffer, replaceString);
        }
        matcher.appendTail(buffer);
        LOGGER.debug(".. result [" + buffer.toString() + "]");
        return buffer.toString();
    }

    @Override
    protected String getLastSequenceQuery(String sequence) {
        return "SELECT LAST_INSERT_ID();";
    }

    @Override
    protected boolean prepareGetStatements(StringBuffer contentSB, StringBuffer splitSB, StringBuffer endSB) throws Exception {
        if (contentSB == null) {
            throw new Exception("contentSB is null");
        }
        if (splitSB == null) {
            throw new Exception("splitSB is null");
        }
        if (endSB == null) {
            throw new Exception("endSB is null");
        }
        splitSB.append("\n/\n");
        endSB.append("");
        return true;
    }

    @Override
    public String[] getReplacement() {
        return REPLACEMENT;
    }
}

