/*
 * Decompiled with CFR 0.152.
 */
package sos.connection.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import sos.connection.SOSConnection;

public class SOSProfiler {
    private String tableSettings = "PROFILER_SETTINGS";
    private String tableHistory = "PROFILER_HISTORY";
    private String entryHistoryId = "profiler_history.id";
    private String entryHistoryStep = "profiler_history.step";
    private String application;
    private int step;
    private int session;
    private String scriptname;
    private String context;
    private int historyId;
    private long startTimeStamp;
    private String classname = new String();
    private String methodname = new String();
    public static boolean profilingAllowed = true;
    public static String profilingDepth = "profiling_depth";
    public static int allowedDepth = 100;
    public SOSConnection conn;
    public int scope = 100;

    public SOSProfiler(SOSConnection conn) {
        try {
            this.conn = conn;
            this.step = this.getSequence(this.entryHistoryStep);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start(String sqlStatement) {
        try {
            if (!profilingAllowed) {
                return;
            }
            String insStr = new String();
            this.getMethodName();
            if (this.scope > allowedDepth) {
                return;
            }
            sqlStatement = sqlStatement.replaceAll("'", "''");
            this.setStartTimeStamp(System.currentTimeMillis());
            this.historyId = this.getSequence(this.entryHistoryId);
            insStr = " INSERT INTO " + this.tableHistory + " (   \"ID\" , \"APPLICATION\" , \"SESSION\" , \"STEP\" , \"CONTEXT\" , \"SCOPE\" , \"CLASS\" , \"FUNCTION\" , \"SCRIPT_NAME\" , \"START_TIME\" , \"START_TIMESTAMP\" , \"STATEMENT\"  ) VALUES ( " + this.historyId + ", '" + this.application + "', " + this.session + ", " + this.step + ", '" + this.context + "', " + this.scope + ", '" + this.classname + "', '" + this.methodname + "', '" + this.scriptname + "', %now , " + this.getStartTimeStamp() + ", '" + sqlStatement + "' )";
            profilingAllowed = false;
            this.conn.execute(insStr);
            this.conn.commit();
            profilingAllowed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop(String errorCode, String errorText) {
        try {
            if (!profilingAllowed) {
                return;
            }
            long endTimeStamp = System.currentTimeMillis();
            int error = 0;
            if (errorCode != null && !errorCode.isEmpty() || errorText != null && !errorText.isEmpty()) {
                error = 1;
            }
            String updStr = "UPDATE " + this.tableHistory + " SET \"END_TIME\" = %now,  \"END_TIMESTAMP\" = " + endTimeStamp + ", \"ELAPSED\" = " + endTimeStamp + " - \"START_TIMESTAMP\", \"ERROR\" = " + error;
            if (errorCode != null) {
                updStr = errorCode.length() > 50 ? updStr.concat(", \"ERROR_CODE\" = '" + errorCode.substring(0, 50) + "'") : updStr.concat(", \"ERROR_CODE\" = '" + errorCode + "'");
            }
            if (errorText != null) {
                updStr = errorText.length() > 250 ? updStr.concat(", \"ERROR_TEXT\" = '" + errorText.substring(0, 250) + "'") : updStr.concat(", \"ERROR_TEXT\" = '" + errorText + "'");
            }
            updStr = updStr.concat(" WHERE \"ID\" = " + this.historyId);
            profilingAllowed = false;
            this.conn.execute(updStr);
            this.conn.commit();
            profilingAllowed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setProfilingAllowed(boolean profilingAllowed) throws Exception {
        SOSProfiler.profilingAllowed = profilingAllowed;
    }

    public static boolean isProfilingAllowed() {
        return profilingAllowed;
    }

    public static void setDepthAllowed(int allowedDepth) {
        SOSProfiler.allowedDepth = allowedDepth;
    }

    private int getSequence(String entry) {
        int retVal = 0;
        try {
            String updStr = " update " + this.tableSettings + " set \"VALUE\"=\"VALUE\"+1  where \"NAME\"='" + entry + "'";
            profilingAllowed = false;
            this.conn.execute(updStr);
            this.conn.commit();
            profilingAllowed = true;
        }
        catch (Exception updStr) {
            // empty catch block
        }
        try {
            String selStr = " select \"VALUE\" from " + this.tableSettings + " where \"NAME\"='" + entry + "'";
            profilingAllowed = false;
            String singleValue = this.conn.getSingleValue(selStr);
            profilingAllowed = true;
            retVal = Integer.parseInt(singleValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    private void setStartTimeStamp(long startTimeStamp) {
        this.startTimeStamp = startTimeStamp;
    }

    private void getMethodName() {
        try {
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            String callStack = sw.toString();
            this.scope = SOSProfiler.getCountOfString(callStack);
            int atPos = callStack.indexOf("Profiler.start");
            atPos = callStack.indexOf("at", atPos);
            int dotPos = callStack.indexOf("(", atPos);
            callStack = callStack.substring(atPos + 2, dotPos);
            int metPos = callStack.lastIndexOf(".");
            this.classname = callStack.substring(1, metPos);
            this.methodname = callStack.substring(metPos + 1, callStack.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getCountOfString(String str) {
        try {
            int iPos = 0;
            int count = 0;
            for (int i = 0; i < str.length(); ++i) {
                iPos = str.indexOf("at ");
                if (iPos <= -1) continue;
                str = str.substring(iPos + 1, str.length());
                ++count;
            }
            return count - 2;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public void setScriptname(String scriptname) {
        this.scriptname = scriptname;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setName4TableSettings(String tableSettings) {
        this.tableSettings = tableSettings;
    }

    public String getName4TableSettings() {
        return this.tableSettings;
    }

    public void setName4TableHistory(String tableHistory) {
        this.tableHistory = tableHistory;
    }

    public String getName4TableHistory() {
        return this.tableHistory;
    }

    public void setEntryHistoryId(String historyId) {
        this.entryHistoryId = historyId;
    }

    public String getEntryHistoryId() {
        return this.entryHistoryId;
    }

    public void setEntryHistoryStep(String entryHistoryStep) {
        this.entryHistoryStep = entryHistoryStep;
    }

    public String getEntryHistoryStep() {
        return this.entryHistoryStep;
    }
}

