/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import java.util.ArrayDeque;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.GenericOutlet;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q4QAD\b\u0001\u001fuA\u0001\"\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006}\u0001!\ta\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0011\u0019a\u0005\u0001)A\u0005\t\"9Q\n\u0001a\u0001\n\u0003q\u0005b\u0002*\u0001\u0001\u0004%\ta\u0015\u0005\u00073\u0002\u0001\u000b\u0015B(\t\u000bi\u0003A\u0011C.\t\u000by\u0003A\u0011A0\t\u000b\u0001\u0004A\u0011A1\t\u000b\r\u0004A\u0011A0\t\u000b\u0011\u0004A\u0011A3\t\u000bQ\u0004A\u0011A0\u0003\u001d\t+hMZ3sK\u0012|U\u000f\u001e7fi*\u0011\u0001#E\u0001\u0006QR$\bO\r\u0006\u0003%M\ta!\u001a8hS:,'B\u0001\u000b\u0016\u0003\u0011IW\u000e\u001d7\u000b\u0005Y9\u0012\u0001\u00025uiBT!\u0001G\r\u0002\u000bA,7n[8\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u000b\u0003=U\u001a2\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0006gR\fw-\u001a\u0006\u0003U]\taa\u001d;sK\u0006l\u0017B\u0001\u0017(\u0005)yU\u000f\u001e%b]\u0012dWM]\u0001\u0007_V$H.\u001a;\u0004\u0001A\u0019\u0001'M\u001a\u000e\u0003=I!AM\b\u0003\u001b\u001d+g.\u001a:jG>+H\u000f\\3u!\t!T\u0007\u0004\u0001\u0005\u000bY\u0002!\u0019A\u001c\u0003\u0003Q\u000b\"\u0001O\u001e\u0011\u0005\u0001J\u0014B\u0001\u001e\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\t\u001f\n\u0005u\n#aA!os\u00061A(\u001b8jiz\"\"\u0001Q!\u0011\u0007A\u00021\u0007C\u0003.\u0005\u0001\u0007q&\u0001\u0004ck\u001a4WM]\u000b\u0002\tB\u0019QIS\u001a\u000e\u0003\u0019S!a\u0012%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tYeI\u0001\u0006BeJ\f\u0017\u0010R3rk\u0016\fqAY;gM\u0016\u0014\b%A\u0005d_6\u0004H.\u001a;fIV\tq\n\u0005\u0002!!&\u0011\u0011+\t\u0002\b\u0005>|G.Z1o\u00035\u0019w.\u001c9mKR,Gm\u0018\u0013fcR\u0011Ak\u0016\t\u0003AUK!AV\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b1\u001a\t\t\u00111\u0001P\u0003\rAH%M\u0001\u000bG>l\u0007\u000f\\3uK\u0012\u0004\u0013A\u00023p!V\u001c\b\u000e\u0006\u0002U9\")Q\f\u0003a\u0001g\u0005!Q\r\\3n\u0003\u0019yg\u000eU;mYR\tA+\u0001\u0003qkNDGC\u0001+c\u0011\u0015i&\u00021\u00014\u0003!\u0019w.\u001c9mKR,\u0017\u0001\u00024bS2$\"\u0001\u00164\t\u000b\u001dd\u0001\u0019\u00015\u0002\u000b\r\fWo]3\u0011\u0005%\fhB\u00016p\u001d\tYg.D\u0001m\u0015\tig&\u0001\u0004=e>|GOP\u0005\u0002E%\u0011\u0001/I\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00118OA\u0005UQJ|w/\u00192mK*\u0011\u0001/I\u0001\tiJLh\t\\;tQ\"\u0012\u0001A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s^\t!\"\u00198o_R\fG/[8o\u0013\tY\bPA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public class BufferedOutlet<T>
implements OutHandler {
    private final GenericOutlet<T> outlet;
    private final ArrayDeque<T> buffer;
    private boolean completed;

    public void onDownstreamFinish() throws Exception {
        OutHandler.onDownstreamFinish$((OutHandler)this);
    }

    public void onDownstreamFinish(Throwable cause) throws Exception {
        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
    }

    public ArrayDeque<T> buffer() {
        return this.buffer;
    }

    public boolean completed() {
        return this.completed;
    }

    public void completed_$eq(boolean x$1) {
        this.completed = x$1;
    }

    public void doPush(T elem) {
        this.outlet.push(elem);
    }

    public void onPull() {
        this.tryFlush();
    }

    public void push(T elem) {
        if (this.outlet.canBePushed() && this.buffer().isEmpty()) {
            this.doPush(elem);
            return;
        }
        this.buffer().addLast(elem);
    }

    public void complete() {
        Predef$.MODULE$.require(!this.completed(), (Function0 & Serializable)() -> "Can only complete once.");
        this.completed_$eq(true);
        if (this.buffer().isEmpty()) {
            this.outlet.complete();
            return;
        }
    }

    public void fail(Throwable cause) {
        this.buffer().clear();
        this.outlet.fail(cause);
    }

    public void tryFlush() {
        if (this.outlet.canBePushed() && !this.buffer().isEmpty()) {
            this.doPush(this.buffer().pop());
        }
        if (this.buffer().isEmpty() && this.completed()) {
            this.outlet.complete();
            return;
        }
    }

    public BufferedOutlet(GenericOutlet<T> outlet) {
        this.outlet = outlet;
        OutHandler.$init$((OutHandler)this);
        this.buffer = new ArrayDeque();
        this.completed = false;
        outlet.setHandler(this);
    }
}

