/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SOSOrderedHashtable
extends Hashtable {
    private static final long serialVersionUID = 4689277581313476669L;
    private Vector mSerialOrder = new Vector();
    private Hashtable mHashtable = new Hashtable();

    @Override
    public synchronized void clear() throws UnsupportedOperationException {
        this.mHashtable.clear();
        this.mSerialOrder.clear();
    }

    @Override
    public synchronized Object remove(Object key) {
        this.mSerialOrder.remove(key);
        return this.mHashtable.remove(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) throws NullPointerException {
        Object toReturn = this.mHashtable.put(key, value);
        if (toReturn == null) {
            this.mSerialOrder.add(key);
        }
        return toReturn;
    }

    public Iterator iterateKeys() {
        return new Enumerator();
    }

    public Enumeration enumerateKeys() {
        return new Enumerator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mHashtable.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mHashtable.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.mHashtable.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mHashtable.isEmpty();
    }

    @Override
    public int size() {
        return this.mHashtable.size();
    }

    @Override
    public synchronized int hashCode() {
        return this.mHashtable.hashCode();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.equals(o);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{ ");
        Object key = null;
        int i = 0;
        while (i < this.mSerialOrder.size()) {
            key = this.mSerialOrder.elementAt(i++);
            s.append(key.toString());
            s.append("=");
            s.append(this.mHashtable.get(key).toString());
            s.append("; ");
        }
        s.append(" }");
        return s.toString();
    }

    private class Enumerator
    implements Enumeration,
    Iterator {
        int count;
        int serial;

        private Enumerator() {
            this.count = SOSOrderedHashtable.this.mSerialOrder.size();
            this.serial = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.serial < this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            SOSOrderedHashtable sOSOrderedHashtable = SOSOrderedHashtable.this;
            synchronized (sOSOrderedHashtable) {
                if (this.count == 0 || this.serial == this.count) {
                    throw new NoSuchElementException("OrderedHashtable Enumerator");
                }
                return SOSOrderedHashtable.this.mSerialOrder.elementAt(this.serial++);
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
        }
    }
}

