/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sos.util.SOSTreeContentHandler;
import sos.util.SOSTreeElement;

public class SOSTree {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private Writer out = null;
    private String site = null;
    private SOSTreeElement root = null;
    private SOSTreeContentHandler handler = null;
    private String space = "&nbsp;&nbsp;";
    private boolean showRoot = true;
    private boolean textOpenNode = false;
    private boolean nodeOpenNode = true;
    private boolean postfixOpenNode = false;
    private boolean closeLowerNodes = true;
    private boolean subTables = false;
    private String cssClass = "tree";
    private boolean disabled = false;
    private String imgDir = "images/";
    private String imgOpenNode = "openFolder.gif\" border=\"0";
    private String imgCloseNode = "closeFolder.gif\" border=\"0";
    private String imgLeaf = "leaf.gif\" border=\"0";
    private String separating = ";";
    private String tdWidth = "400";
    private List<String> tableHead = null;
    private String openNode = null;
    private String closeNode = null;
    private String activeStyle = null;
    private boolean autoFlush = true;

    public SOSTree() {
        this.init();
    }

    public SOSTree(HttpServletRequest request, HttpServletResponse response, Writer out) {
        this();
        this.request = request;
        this.response = response;
        this.out = out;
    }

    public void setRequest(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("setRequest: parameter request is null");
        }
        this.request = request;
        this.site = request.getRequestURI();
    }

    public void setResponse(HttpServletResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("setResponse: parameter response is null");
        }
        this.response = response;
    }

    public void setOut(Writer out) {
        if (out == null) {
            throw new IllegalArgumentException("setOut: parameter out is null");
        }
        this.out = out;
    }

    public void setContentHandler(SOSTreeContentHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("setContentHandler: parameter handler is null");
        }
        this.handler = handler;
    }

    public void setRootVisible(boolean visible) {
        this.showRoot = visible;
    }

    public boolean isRootVisible() {
        return this.showRoot;
    }

    public void setRootName(String name) {
        this.root.setName(name);
    }

    public void setRootTitle(String title) {
        this.root.setTitle(title);
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setImgDir(String imgDir) {
        this.imgDir = imgDir;
    }

    public String getImgDir() {
        return this.imgDir;
    }

    public void setImgOpenNode(String img) {
        this.imgOpenNode = img;
    }

    public String getImgOpenNode() {
        return this.imgOpenNode;
    }

    public void setImgCloseNode(String img) {
        this.imgCloseNode = img;
    }

    public String getImgCloseNode() {
        return this.imgCloseNode;
    }

    public void setImgLeaf(String img) {
        this.imgLeaf = img;
    }

    public String getImgLeaf() {
        return this.imgLeaf;
    }

    public void setTextOpenNode(boolean textOpenNode) {
        this.textOpenNode = textOpenNode;
    }

    public boolean isTextOpenNode() {
        return this.textOpenNode;
    }

    public void setNodeOpenNode(boolean nodeOpenNode) {
        this.nodeOpenNode = nodeOpenNode;
    }

    public boolean isNodeOpenNode() {
        return this.nodeOpenNode;
    }

    public void setPostfixOpenNode(boolean postfixOpenNode) {
        this.postfixOpenNode = postfixOpenNode;
    }

    public boolean isPostfixOpenNode() {
        return this.postfixOpenNode;
    }

    public void setCloseLowerNodes(boolean closeLowerNodes) {
        this.closeLowerNodes = closeLowerNodes;
    }

    public boolean isCloseLowerNodes() {
        return this.closeLowerNodes;
    }

    public void setTdWidth(String width) {
        this.tdWidth = width;
    }

    public String getTdWidth() {
        return this.tdWidth;
    }

    public void setSubTables(boolean subTables) {
        this.subTables = subTables;
    }

    public boolean isSubTables() {
        return this.subTables;
    }

    public SOSTreeElement getRootNode() {
        return this.root;
    }

    public void setHeadline(List<String> headline) {
        this.tableHead = headline;
    }

    public List<String> getHeadline() {
        return this.tableHead;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    private void init() {
        this.root = new SOSTreeElement();
        this.root.setOpen(true);
        this.root.setId(0);
        this.root.setName("ROOT");
        this.root.setTitle("ROOT");
    }

    public void clear() {
        this.init();
    }

    public String get() throws Exception {
        if (this.request == null) {
            throw new NullPointerException("get: request is not set");
        }
        if (this.response == null) {
            throw new NullPointerException("get: response is not set");
        }
        if (this.handler == null) {
            throw new NullPointerException("get: handler is not set");
        }
        try {
            StringBuilder out = new StringBuilder();
            out.append("<!-- TreeView Start -->\n<table class=\"").append(this.disabled ? "dis" : "").append(this.cssClass).append("\">\n");
            if (this.tableHead != null) {
                out.append("<tr class=\"").append(this.disabled ? "dis" : "").append(this.cssClass).append("_head\">");
                for (int i = 0; i < this.tableHead.size(); ++i) {
                    out.append("<th class=\"").append(this.disabled ? "dis" : "").append(this.cssClass).append("_head\">").append(this.tableHead.get(i)).append("</th>");
                }
                out.append("</tr>\n");
            }
            int indent = 0;
            if (this.showRoot) {
                out.append(this.formatElement(this.root, ""));
                ++indent;
            }
            if (this.root.isOpen()) {
                out.append(this.printNodeContent(this.root, indent));
            }
            out.append("</table>\n<!-- TreeView End -->\n");
            return out.toString();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public void show() throws Exception {
        if (this.out == null) {
            throw new NullPointerException("show: out is not set");
        }
        this.process();
        this.out.write(this.get());
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    public void print() throws Exception {
        if (this.out == null) {
            throw new NullPointerException("print: out is not set");
        }
        this.out.write(this.get());
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    public void process() throws Exception {
        this.openNode = this.request.getParameter("openNode");
        this.closeNode = this.request.getParameter("closeNode");
        if (this.showRoot) {
            this.toggleNode(this.root);
        }
        this.process(this.root);
    }

    private void process(SOSTreeElement node) throws Exception {
        if (node.isOpen()) {
            this.fillNode(node);
        }
        for (SOSTreeElement current = node.getList(); current != null; current = current.getNext()) {
            if (current.isNode()) {
                this.toggleNode(current);
            }
            if (!current.isOpen()) continue;
            this.process(current);
        }
    }

    private String printNodeContent(SOSTreeElement node, int level) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("printElement: parameter node is null");
        }
        if (node.isLeaf()) {
            throw new IllegalArgumentException("printElement: parameter node is set as leaf");
        }
        try {
            StringBuilder indent = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                indent.append((CharSequence)indent);
            }
            SOSTreeElement current = node.getList();
            StringBuilder out = new StringBuilder();
            if (this.subTables) {
                out.append("<tr class=\"").append(this.disabled ? "dis" : "").append(this.cssClass).append("\"><td colspan=\"10\" class=\"").append(this.disabled ? "dis" : "").append(this.cssClass).append("\"><table class=\"").append(this.disabled ? "dis" : "").append(this.cssClass).append("\">");
            }
            while (current != null) {
                out.append(this.formatElement(current, indent.toString()));
                if (current.isOpen()) {
                    out.append(this.printNodeContent(current, level + 1));
                }
                current = current.getNext();
            }
            if (this.subTables) {
                out.append("</table></td></tr>");
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private String formatElement(SOSTreeElement element, String indent) {
        if (element == null || indent == null) {
            throw new IllegalArgumentException("getElementStr: parameter element or indent is null");
        }
        String cssClass = element.getCssClass() != null ? element.getCssClass() : this.cssClass;
        String imgDir = element.getImgDir() != null ? element.getImgDir() : this.imgDir;
        String imgOpenNode = element.getImgOpenNode() != null ? element.getImgOpenNode() : this.imgOpenNode;
        String imgCloseNode = element.getImgCloseNode() != null ? element.getImgCloseNode() : this.imgCloseNode;
        String imgLeaf = element.getImgLeaf() != null ? element.getImgLeaf() : this.imgLeaf;
        String hrefName = element.getHrefName() != null ? element.getHrefName() : "";
        String hrefAnker = element.getHrefAnker() != null ? element.getHrefAnker() : "";
        String activStyle = element.getActivStyle() != null ? element.getActivStyle() : "";
        StringBuilder str = new StringBuilder();
        String url = this.formatURL(element, true);
        StringBuilder image = new StringBuilder();
        image.append("<img src=\"").append(imgDir);
        if (element.isLeaf()) {
            image.append(imgLeaf);
        } else if (element.isOpen()) {
            image.append(imgOpenNode);
        } else {
            image.append(imgCloseNode);
        }
        image.append("\">");
        element.setActivStyle(null);
        str.append("<tr class=\"").append(this.disabled ? "dis" : "").append(cssClass).append("\"><td class=\"").append(this.disabled ? "dis" : "").append(cssClass).append("\"").append(this.tdWidth != null ? " width=\"" + this.tdWidth + "\"" : "").append(">").append(indent);
        if (element.isLeaf() && (element.getImgLeaf() == null || !"".equals(element.getImgLeaf()))) {
            str.append((CharSequence)image).append(this.space);
        }
        if (this.nodeOpenNode && element.isNode()) {
            str.append("<a ").append(hrefName).append(" class=\"").append(this.disabled ? "dis" : "").append(cssClass).append("\" href=\"").append(url).append(hrefAnker).append("\">").append((CharSequence)image).append("</a>").append(this.space);
        } else if (element.getURL() != null && element.isNode()) {
            str.append("<a ").append(hrefName).append(" class=\"").append(this.disabled ? "dis" : "").append(cssClass).append("\" href=\"").append(this.formatURL(element, false)).append(hrefAnker).append("\">").append((CharSequence)image).append("</a>").append(this.space);
        } else if (element.isNode()) {
            str.append((CharSequence)image).append(this.space);
        }
        if (element.getPrefix() != null && !"".equals(element.getPrefix())) {
            str.append(element.getPrefix()).append(this.space);
        }
        if (this.textOpenNode && element.isNode()) {
            str.append("<a ").append(activStyle).append(" ").append(hrefName).append(" class=\"").append(this.disabled ? "dis" : "").append(cssClass).append("\" href=\"").append(url).append(hrefAnker).append("\">").append(element.getTitle()).append("</a>");
        } else if (element.getURL() != null) {
            str.append("<a ").append(activStyle).append(" ").append(hrefName).append(" class=\"").append(this.disabled ? "dis" : "").append(cssClass).append("\" href=\"").append(this.formatURL(element, false)).append(hrefAnker).append("\">").append(element.getTitle()).append("</a>");
        } else if (activStyle != null && !activStyle.isEmpty()) {
            str.append("<font ").append(activStyle).append(">").append(element.getTitle()).append("</font>");
        } else {
            str.append(element.getTitle());
        }
        str.append("</td>");
        if (element.getPostfix() != null) {
            str.append("<td class=\"").append(this.disabled ? "dis" : "").append(cssClass).append("\">");
            if (element.isNode() && this.postfixOpenNode) {
                str.append("<a ").append(hrefName).append(" class=\"").append(this.disabled ? "dis" : "").append(cssClass).append("\"href=\"").append(url).append(hrefAnker).append("\">").append(element.getPostfix()).append("</a>");
            } else {
                str.append(element.getPostfix());
            }
            str.append("</td>");
        }
        str.append("</tr>");
        str.append("\n");
        return str.toString();
    }

    private String formatURL(SOSTreeElement element, boolean openClose) {
        if (element == null) {
            throw new IllegalArgumentException("formatURL: parameter element is null");
        }
        StringBuilder url = new StringBuilder();
        String and = "";
        if (openClose) {
            url.append(this.site).append("?").append(element.isOpen() ? "closeNode=" + element.getPath() : "openNode=" + element.getPath());
            and = "&";
        } else {
            url.append(element.getURL());
            if (url.indexOf("?") < 0) {
                url.append("?");
            } else {
                and = "&";
            }
        }
        Map<String, String> parameters = element.getParameters();
        if (parameters != null) {
            for (String name : parameters.keySet()) {
                url.append(and).append(name).append("=").append(parameters.get(name));
                and = "&";
            }
        }
        return this.response.encodeURL(url.toString());
    }

    private void toggleNode(SOSTreeElement node) {
        if (node == null) {
            throw new IllegalArgumentException("toggleNode: parameter node is null");
        }
        if (node.isLeaf()) {
            throw new IllegalArgumentException("toggleNode: parameter node is not set as node");
        }
        if (node.isNode() && this.openNode != null && this.openNode.equals(node.getPath())) {
            node.setOpen(true);
            node.setActivStyle(this.activeStyle);
        }
        if (node.isNode() && this.closeNode != null && this.closeNode.equals(node.getPath())) {
            node.setOpen(false);
            node.setActivStyle(this.activeStyle);
            if (this.closeLowerNodes) {
                this.closeLowerNodes(node);
            }
        }
    }

    private void fillNode(SOSTreeElement node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("fillNode: parameter node is null");
        }
        if (node.isLeaf()) {
            throw new IllegalArgumentException("fillNode: parameter node is not set as node");
        }
        if (this.handler == null) {
            throw new NullPointerException("fillNode: content handler is null");
        }
        if (node.isNew()) {
            this.handler.startNode(node);
            SOSTreeElement newElement = null;
            newElement = this.handler.newElement(node, newElement);
            while (newElement != null) {
                node.insert(newElement);
                newElement = this.handler.newElement(node, newElement);
            }
            node.setNew(false);
        }
    }

    private void closeLowerNodes(SOSTreeElement node) {
        if (node == null) {
            throw new IllegalArgumentException("closeLowerNodes: parameter node is null");
        }
        if (node.isLeaf()) {
            throw new IllegalArgumentException("closeLowerNodes: parameter node is not set as node");
        }
        for (SOSTreeElement current = node.getList(); current != null; current = current.getNext()) {
            if (!current.isLeaf()) {
                current.setOpen(false);
            }
            if (current.isLeaf() || current.getList() == null) continue;
            this.closeLowerNodes(current);
        }
    }

    public void openToElement(SOSTreeElement element) {
        if (element == null) {
            return;
        }
        for (SOSTreeElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            parent.setOpen(true);
        }
    }

    public SOSTreeElement getElementByIdPath(String path) throws Exception {
        return this.getElementByPath(this.root, path, false);
    }

    public SOSTreeElement getElementByNamePath(String namePath) throws Exception {
        return this.getElementByPath(this.root, namePath, true);
    }

    private SOSTreeElement getElementByPath(SOSTreeElement element, String path, boolean names) throws Exception {
        try {
            if (element == null || path == null) {
                return null;
            }
            int id = -1;
            String name = null;
            String[] paths = path.split(this.separating, 3);
            if (names) {
                name = paths[0].trim();
            } else {
                id = Integer.parseInt(paths[0].trim());
            }
            if (!names && id != element.getId()) {
                return null;
            }
            if (names) {
                if (element.getName() == null) {
                    throw new Exception("TreeElement(" + element.getPath() + "): name is n + ");
                }
                if (!name.equals(element.getName())) {
                    return null;
                }
            }
            if (paths.length == 1) {
                return element;
            }
            this.fillNode(element);
            if (element.isLeaf()) {
                return element;
            }
            for (SOSTreeElement current = element.getList(); current != null; current = current.getNext()) {
                int id2 = -1;
                String name2 = null;
                if (names) {
                    name2 = paths[1].trim();
                } else {
                    id2 = Integer.parseInt(paths[1].trim());
                }
                if (names && current.getName() == null) {
                    throw new Exception("TreeElement(" + current.getPath() + "): name is null");
                }
                if (names && name2.equals(current.getName()) || !names && id2 == current.getId()) {
                    if (paths.length == 2) {
                        return current;
                    }
                    return this.getElementByPath(current, paths[1] + this.separating + paths[2], names);
                }
                if (names || id2 >= current.getId()) continue;
                return null;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return null;
    }

    public SOSTreeElement getElementByName(String name) {
        return this.getElementByName(this.root, name);
    }

    private SOSTreeElement getElementByName(SOSTreeElement node, String name) {
        if (name == null || node == null) {
            return null;
        }
        if (node.isLeaf()) {
            throw new IllegalArgumentException("getElementByName: parameter node is not set as node");
        }
        for (SOSTreeElement current = node.getList(); current != null; current = current.getNext()) {
            SOSTreeElement ret;
            if (current.getName() != null && current.getName().equals(name)) {
                return current;
            }
            if (!current.isNode() || current.getList() == null || (ret = this.getElementByName(current, name)) == null) continue;
            return ret;
        }
        return null;
    }

    public String getActivStyle() {
        return this.activeStyle;
    }

    public void setActivStyle(String style) {
        this.activeStyle = style;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean flush) {
        this.autoFlush = flush;
    }
}

