/*
 * Decompiled with CFR 0.152.
 */
package sos.util.string2bool;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sos.util.string2bool.SOSMalformedBooleanException;

final class SOSBooleanUtil {
    SOSBooleanUtil() {
    }

    static String validAndformat(String booleanExpression) throws SOSMalformedBooleanException {
        if (booleanExpression == null || "".equals(booleanExpression)) {
            throw new IllegalArgumentException("Argument: booleanExpression is null or void");
        }
        SOSBooleanUtil.validRegexp(booleanExpression);
        SOSBooleanUtil.validParenthesis(booleanExpression);
        return booleanExpression.toUpperCase().replaceAll("TRUE", "T").replaceAll("FALSE", "F").replaceAll("\\|\\|", "|").replaceAll("&&", "&");
    }

    private static void validRegexp(String booleanExpression) throws SOSMalformedBooleanException {
        String regexp = "(\\(|\\)|\\|{2}|\\&{2}|!|(false)|(true)|\\s)+";
        if (!booleanExpression.matches("^" + regexp + "$")) {
            Matcher matcher = Pattern.compile(regexp).matcher(booleanExpression);
            ArrayList<Integer> errorIndexes = new ArrayList<Integer>();
            while (matcher.find()) {
                int end;
                int start = matcher.start();
                if (start != 0) {
                    errorIndexes.add(new Integer(start));
                }
                if ((end = matcher.end()) == booleanExpression.length()) continue;
                errorIndexes.add(new Integer(end));
            }
            if (errorIndexes.isEmpty()) {
                errorIndexes.add(new Integer(0));
            }
            throw new SOSMalformedBooleanException("Expected [ ' ' ( ) || && ! true false ]", errorIndexes, booleanExpression);
        }
    }

    private static void validParenthesis(String booleanExpression) throws SOSMalformedBooleanException {
        int length = booleanExpression.length();
        int openParenthesis = 0;
        int closeParenthesis = 0;
        int lastOpenParenthesisIndex = 0;
        block4: for (int i = 0; i < length; ++i) {
            char charAt = booleanExpression.charAt(i);
            switch (charAt) {
                case '(': {
                    lastOpenParenthesisIndex = i;
                    ++openParenthesis;
                    continue block4;
                }
                case ')': {
                    if (openParenthesis >= ++closeParenthesis) continue block4;
                    throw new SOSMalformedBooleanException("Have a close parenthesis without an open parenthesis", i, booleanExpression);
                }
            }
        }
        if (closeParenthesis < openParenthesis) {
            throw new SOSMalformedBooleanException("Have an open parenthesis without a close parenthesis", lastOpenParenthesisIndex, booleanExpression);
        }
    }
}

