/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.ftp;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionProxyProtocol;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.ftp.common.SOSFTPBaseClass;
import com.sos.vfs.ftp.common.SOSFTPClientLogger;
import com.sos.vfs.ftp.common.SOSFTPSProxySelector;
import java.io.File;
import java.net.ProxySelector;
import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.util.TrustManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSFTPS
extends SOSFTPBaseClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFTPS.class);

    @Override
    public void doConnect() {
        try {
            if (!this.isConnected()) {
                super.doConnect();
                FTPSClient client = (FTPSClient)super.getClient();
                client.execPBSZ(0L);
                this.logReply("execPBSZ");
                client.execPROT("P");
                this.logReply("execPROT");
                this.getClient().enterLocalPassiveMode();
                this.logReply("enterLocalPassiveMode");
            } else {
                LOGGER.warn(SOSVfs_D_0102.params(new Object[]{this.getHost(), this.getPort()}));
            }
        }
        catch (Exception e) {
            String msg = this.getHostID("connect returns an exception");
            LOGGER.error(msg, (Throwable)e);
        }
    }

    @Override
    public FTPClient getClient() {
        if (super.getClient() == null) {
            String addFTPProtocol;
            FTPSClient client = null;
            try {
                LOGGER.info(String.format("use %s client security", this.getProviderOptions().ftpsClientSecurity.getValue()));
                client = new FTPSClient(this.getProviderOptions().ftpsProtocol.getValue(), this.getProviderOptions().ftpsClientSecurity.isImplicit());
                if (this.usingProxy()) {
                    LOGGER.info(String.format("using proxy: protocol = %s, host = %s, port = %s, user = %s, pass = ?", this.getProxyProtocol().getValue(), this.getProxyHost(), this.getProxyPort(), this.getProxyUser()));
                    if (this.usingHttpProxy()) {
                        client.setProxy(this.getHTTPProxy());
                    } else {
                        SOSOptionProxyProtocol.Protocol proxyProtocol = this.getProxyProtocol().isSocks4() ? SOSOptionProxyProtocol.Protocol.socks4 : SOSOptionProxyProtocol.Protocol.socks5;
                        SOSFTPSProxySelector ps = new SOSFTPSProxySelector(proxyProtocol, this.getProxyHost(), this.getProxyPort(), this.getProxyUser(), this.getProxyPassword());
                        ProxySelector.setDefault(ps);
                    }
                }
                if (!SOSString.isEmpty((String)this.getProviderOptions().keystoreFile.getValue())) {
                    this.setTrustManager(client);
                }
            }
            catch (Exception e) {
                throw new JobSchedulerException("can not create FTPS-Client", (Throwable)e);
            }
            this.setCommandListener(new SOSFTPClientLogger(this.getHostID("")));
            if (this.getProviderOptions() != null && this.getProviderOptions().protocolCommandListener.isTrue()) {
                client.addProtocolCommandListener((ProtocolCommandListener)this.getCommandListener());
            }
            if ((addFTPProtocol = System.getenv("AddFTPProtocol")) != null && "true".equalsIgnoreCase(addFTPProtocol)) {
                client.addProtocolCommandListener((ProtocolCommandListener)this.getCommandListener());
            }
            super.setClient((FTPClient)client);
        }
        return super.getClient();
    }

    private void setTrustManager(FTPSClient client) throws Exception {
        LOGGER.info(String.format("using keystore: type = %s, file = %s", this.getProviderOptions().keystoreType.getValue(), this.getProviderOptions().keystoreFile.getValue()));
        KeyStore ks = this.loadKeyStore(this.getProviderOptions().keystoreType.getValue(), new File(this.getProviderOptions().keystoreFile.getValue()), this.getProviderOptions().keystorePassword.getValue());
        client.setTrustManager((TrustManager)TrustManagerUtils.getDefaultTrustManager((KeyStore)ks));
    }
}

