/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.http;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.http.SOSHTTPFile;
import com.sos.vfs.http.common.SOSHTTPClient;
import com.sos.vfs.http.common.SOSHTTPInputStream;
import com.sos.vfs.http.common.SOSHTTPOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.entity.InputStreamEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSHTTP
extends SOSCommonProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHTTP.class);
    private SOSHTTPClient client;
    private HashMap<String, Long> fileSizes = new HashMap();
    private LinkedHashMap<String, String> headers;

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        super.connect(options);
        this.client = new SOSHTTPClient(options, false);
        this.host = this.client.getBaseURI().getHost();
        this.port = this.client.getPort();
        this.setHeaders();
        this.checkConnection();
        LOGGER.info(SOSVfs_D_0102.params(new Object[]{this.host, this.port}));
        this.logReply();
    }

    @Override
    public void disconnect() {
        this.reply = "disconnect OK";
        this.fileSizes = new HashMap();
        this.headers = new LinkedHashMap();
        if (this.client != null) {
            try {
                this.client.close();
                this.client = null;
            }
            catch (Throwable ex) {
                this.reply = "disconnect: " + ex;
            }
        }
        LOGGER.info(this.reply);
    }

    @Override
    public boolean isConnected() {
        return this.client != null;
    }

    private void checkConnection() throws Exception {
        URI uri = this.client.getBaseURI();
        HttpGet request = new HttpGet(uri);
        this.setHttpHeaders((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
            this.checkConnectResponse(uri, response);
        }
        catch (Throwable e) {
            this.throwException((HttpRequestBase)request, e);
        }
    }

    @Override
    public void mkdir(String pathname) throws IOException {
        LOGGER.debug("[mkdir][not implemented yet]" + pathname);
    }

    @Override
    public void rmdir(String pathname) throws IOException {
        LOGGER.info("[rmdir][not implemented yet]" + pathname);
    }

    @Override
    public boolean isDirectory(String path) {
        boolean isDirectory;
        block14: {
            isDirectory = false;
            try {
                URI uri = this.client.normalizeURI(path.endsWith("/") ? path : path + "/");
                HttpTrace request = new HttpTrace(uri);
                this.setHttpHeaders((HttpRequestBase)request);
                try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
                    isDirectory = response.getStatusLine().getStatusCode() <= 400;
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block14;
                LOGGER.debug("[" + path + "]" + e.toString(), e);
            }
        }
        return isDirectory;
    }

    @Override
    public SOSFileEntry getFileEntry(String path) throws Exception {
        long size = this.size(path);
        if (size < 0L) {
            return null;
        }
        String fileName = SOSHTTP.getBaseNameFromPath(path);
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.HTTP);
        entry.setDirectory(false);
        entry.setFilename(fileName);
        entry.setNormalizedFilename(URLEncoder.encode(fileName, "UTF-8"));
        entry.setFilesize(size);
        entry.setParentPath(this.client.getRelativeDirectoryPath(this.client.normalizeURI(path)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getFileEntry=%s]%s", path, SOSString.toString((Object)entry)));
        }
        return entry;
    }

    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) throws IOException {
        if (path.isEmpty()) {
            path = "/";
        }
        this.reply = "ls OK";
        return new ArrayList<SOSFileEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(String path) throws Exception {
        if (this.fileSizes.containsKey(path)) {
            return this.fileSizes.get(path);
        }
        long size = -1L;
        URI uri = this.client.normalizeURI(path);
        HttpGet request = new HttpGet(uri);
        this.setHttpHeaders((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
            StatusLine sl = response.getStatusLine();
            boolean success = SOSHTTPClient.isSuccessStatusCode(sl);
            if (success) {
                HttpEntity en = response.getEntity();
                size = en.getContentLength();
                if (size < 0L) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("[%s][size=%s]use getInputStreamLen", uri, size));
                    }
                    size = this.getInputStreamLen(en.getContent());
                }
            } else if (sl.getStatusCode() != 404) {
                throw new Exception(SOSHTTPClient.getResponseStatus(uri, sl));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[%s][size=%s]%s", uri, size, SOSString.toString((Object)sl)));
            }
        }
        catch (Throwable e) {
            this.throwException((HttpRequestBase)request, e);
        }
        finally {
            this.fileSizes.put(path, size);
        }
        return size;
    }

    private long getInputStreamLen(InputStream is) throws Exception {
        long total = 0L;
        try {
            int readed = 0;
            byte[] buffer = new byte[1024];
            while ((readed = is.read(buffer)) != -1) {
                total += (long)readed;
            }
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable readed) {}
        }
        return total;
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) {
        URI uri;
        if (checkIsDirectory && this.isDirectory(path)) {
            throw new JobSchedulerException(SOSVfs_E_186.params(new Object[]{path}));
        }
        try {
            uri = this.client.normalizeURI(path);
        }
        catch (Throwable e) {
            throw new JobSchedulerException(String.format("[%s]%s", path, e.toString()), e);
        }
        HttpDelete request = new HttpDelete(uri);
        this.setHttpHeaders((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
            StatusLine sl = response.getStatusLine();
            if (!SOSHTTPClient.isSuccessStatusCode(sl)) {
                throw new Exception(SOSHTTPClient.getResponseStatus(uri, sl));
            }
        }
        catch (Throwable e) {
            this.reply = e.toString();
            this.throwJobSchedulerException((HttpRequestBase)request, e);
        }
        this.reply = "rm OK";
        LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"delete", uri, this.getReplyString()})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String from, String to) {
        URI uriTo;
        try {
            uriTo = this.client.normalizeURI(to);
        }
        catch (Throwable e) {
            throw new JobSchedulerException(String.format("[to=%s]%s", to, e.toString()), e);
        }
        InputStream is = null;
        try {
            is = this.getInputStream(from);
            HttpPut requestTo = new HttpPut(uriTo);
            this.setHttpHeaders((HttpRequestBase)requestTo);
            requestTo.setEntity((HttpEntity)new InputStreamEntity(is));
            try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)requestTo);){
                try {
                    is.close();
                    is = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                StatusLine sl = response.getStatusLine();
                if (!SOSHTTPClient.isSuccessStatusCode(sl)) {
                    throw new Exception(SOSHTTPClient.getResponseStatus(uriTo, sl));
                }
                this.delete(from, false);
            }
            catch (Throwable e) {
                this.reply = e.toString();
                this.throwJobSchedulerException((HttpRequestBase)requestTo, e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.reply = "mv OK";
        LOGGER.info(this.getHostID(SOSVfs_I_189.params(new Object[]{from, to, this.getReplyString()})));
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        String fn = "";
        try {
            fn = this.adjustFileSeparator(fileName);
            if (!this.client.isAbsolute(fn)) {
                String tfn = fileName.startsWith("/") ? fn : "/" + fn;
                fn = this.client.getBaseURIPath().endsWith(tfn + "/") ? this.client.getBaseURIPath().substring(0, this.client.getBaseURIPath().length() - 1) : (this.client.getBaseURIPath() + fn).replaceAll("//+", "/");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[getFile][%s]%s", fileName, fn));
            }
            SOSHTTPFile file = new SOSHTTPFile(fn);
            file.setProvider(this);
            return file;
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[getFile][%s][%s]%s", fileName, fn, e.toString()), e);
            return null;
        }
    }

    @Override
    public boolean fileExists(String path) {
        try {
            return this.size(path) > -1L;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean directoryExists(String path) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]directoryExists", path));
        }
        return this.isDirectory(path);
    }

    private void setHeaders() throws IOException {
        if (!SOSString.isEmpty((String)this.getProviderOptions().http_headers.getValue())) {
            this.headers = this.readHeaders(this.getProviderOptions().http_headers.getValue());
            LOGGER.info(String.format("[HTTPHeaders]%s", StringUtils.stripEnd((String)StringUtils.stripStart((String)this.headers.toString(), (String)"{"), (String)"}")));
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append, boolean resume) {
        try {
            URI uri = this.client.normalizeURI(path);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[getOutputStream][path=%s]uri=%s", path, uri));
            }
            HttpPut request = new HttpPut(uri);
            this.setHttpHeaders((HttpRequestBase)request);
            return new SOSHTTPOutputStream(this.client.getClient(), request, uri);
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getOutputStream()", path}), ex);
        }
    }

    @Override
    public InputStream getInputStream(String path) {
        try {
            URI uri = this.client.normalizeURI(path);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[getInputStream][path=%s]uri=%s", path, uri));
            }
            CloseableHttpResponse response = null;
            try {
                HttpGet request = new HttpGet(uri);
                this.setHttpHeaders((HttpRequestBase)request);
                response = this.client.execute((HttpRequestBase)request);
                StatusLine sl = response.getStatusLine();
                if (!SOSHTTPClient.isSuccessStatusCode(sl)) {
                    throw new Exception(SOSHTTPClient.getResponseStatus(uri, sl));
                }
                return new SOSHTTPInputStream(response);
            }
            catch (Throwable e) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getInputStream()", path}), ex);
        }
    }

    private void checkConnectResponse(URI uri, CloseableHttpResponse response) throws Exception {
        int sc = SOSHTTPClient.checkConnectResponse(uri, response);
        if (sc == 404) {
            this.client.setBaseUriOnNotExists();
        }
    }

    private void setHttpHeaders(HttpRequestBase request) {
        if (this.headers != null && this.headers.size() > 0) {
            this.headers.forEach((k, v) -> request.addHeader(k.toString(), v.toString()));
        }
    }

    private LinkedHashMap<String, String> readHeaders(String val) throws IOException {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        Stream.of(val.split("\\|")).forEach(e -> {
            String header = e.trim();
            int p = header.indexOf(" ");
            if (p == -1) {
                m.put(header, "");
            } else {
                String name = header.substring(0, p);
                String value = header.substring(p);
                m.put(name, value.trim());
            }
        });
        return m;
    }

    private void throwException(HttpRequestBase request, Throwable e) throws Exception {
        throw new Exception(String.format("[%s]%s", request.getURI(), e.toString()), e);
    }

    private void throwJobSchedulerException(HttpRequestBase request, Throwable e) throws JobSchedulerException {
        throw new JobSchedulerException(String.format("[%s]%s", request.getURI(), e.toString()), e);
    }

    @Override
    public boolean isHTTP() {
        return true;
    }
}

