/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.jms.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.protobuf.compiler.CommandLineSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerTool
extends Thread
implements MessageListener,
ExceptionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerTool.class);
    private static int parallelThreads = 1;
    private boolean running;
    private Session session;
    private Destination destination;
    private MessageProducer replyProducer;
    private boolean pauseBeforeShutdown = false;
    private boolean verbose = true;
    private int maxiumMessages;
    private String subject = "TOOL.DEFAULT";
    private boolean topic;
    private String user = ActiveMQConnection.DEFAULT_USER;
    private String password = ActiveMQConnection.DEFAULT_PASSWORD;
    private String url = "failover://tcp://localhost:61616";
    private boolean transacted;
    private boolean durable;
    private String clientId;
    private int ackMode = 1;
    private String consumerName = "James";
    private long sleepTime;
    private long receiveTimeOut;

    public static void main(String[] args) {
        ArrayList<ConsumerTool> threads = new ArrayList<ConsumerTool>();
        ConsumerTool consumerTool = new ConsumerTool();
        Object[] unknown = CommandLineSupport.setOptions((Object)consumerTool, (String[])args);
        if (unknown.length > 0) {
            LOGGER.info("Unknown options: " + Arrays.toString(unknown));
            System.exit(-1);
        }
        consumerTool.showParameters();
        for (int threadCount = 1; threadCount <= parallelThreads; ++threadCount) {
            consumerTool = new ConsumerTool();
            CommandLineSupport.setOptions((Object)consumerTool, (String[])args);
            consumerTool.start();
            threads.add(consumerTool);
        }
        while (true) {
            Iterator itr = threads.iterator();
            int running = 0;
            while (itr.hasNext()) {
                ConsumerTool thread = (ConsumerTool)itr.next();
                if (!thread.isAlive()) continue;
                ++running;
            }
            if (running <= 0) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        LOGGER.debug("All threads completed their work");
        for (ConsumerTool consumerTool2 : threads) {
        }
    }

    public void showParameters() {
        LOGGER.info("Connecting to URL: " + this.url);
        LOGGER.info("Consuming " + (this.topic ? "topic" : "queue") + ": " + this.subject);
        LOGGER.info("Using a " + (this.durable ? "durable" : "non-durable") + " subscription");
        LOGGER.info("Running " + parallelThreads + " parallel threads");
    }

    @Override
    public void run() {
        try {
            this.running = true;
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.user, this.password, this.url);
            Connection connection = connectionFactory.createConnection();
            if (this.durable && this.clientId != null && this.clientId.length() > 0 && !"null".equals(this.clientId)) {
                connection.setClientID(this.clientId);
            }
            connection.setExceptionListener((ExceptionListener)this);
            connection.start();
            this.session = connection.createSession(this.transacted, this.ackMode);
            this.destination = this.topic ? this.session.createTopic(this.subject) : this.session.createQueue(this.subject);
            this.replyProducer = this.session.createProducer(null);
            this.replyProducer.setDeliveryMode(1);
            Object consumer = null;
            consumer = this.durable && this.topic ? this.session.createDurableSubscriber((Topic)this.destination, this.consumerName) : this.session.createConsumer(this.destination);
            if (this.maxiumMessages > 0) {
                this.consumeMessagesAndClose(connection, this.session, (MessageConsumer)consumer);
            } else if (this.receiveTimeOut == 0L) {
                consumer.setMessageListener((MessageListener)this);
            } else {
                this.consumeMessagesAndClose(connection, this.session, (MessageConsumer)consumer, this.receiveTimeOut);
            }
        }
        catch (Exception e) {
            LOGGER.error("[" + this.getName() + "] Caught: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            if (message instanceof TextMessage) {
                TextMessage txtMsg = (TextMessage)message;
                if (this.verbose) {
                    String msg = txtMsg.getText();
                    int length = msg.length();
                    if (length > 50) {
                        msg = msg.substring(0, 50) + "...";
                    }
                    LOGGER.info("[" + this.getName() + "] Received: '" + msg + "' (length " + length + ")");
                }
            } else if (this.verbose) {
                LOGGER.info("[" + this.getName() + "] Received: '" + message + "'");
            }
            if (message.getJMSReplyTo() != null) {
                this.replyProducer.send(message.getJMSReplyTo(), (Message)this.session.createTextMessage("Reply: " + message.getJMSMessageID()));
            }
            if (this.transacted) {
                this.session.commit();
            } else if (this.ackMode == 2) {
                message.acknowledge();
            }
        }
        catch (JMSException e) {
            LOGGER.error("[" + this.getName() + "] Caught: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.sleepTime > 0L) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized void onException(JMSException ex) {
        LOGGER.info("[" + this.getName() + "] JMS Exception occured.  Shutting down client.");
        this.running = false;
    }

    synchronized boolean isRunning() {
        return this.running;
    }

    protected void consumeMessagesAndClose(Connection connection, Session session, MessageConsumer consumer) throws JMSException, IOException {
        LOGGER.info("[" + this.getName() + "] We are about to wait until we consume: " + this.maxiumMessages + " message(s) then we will shutdown");
        int i = 0;
        while (i < this.maxiumMessages && this.isRunning()) {
            Message message = consumer.receive(1000L);
            if (message == null) continue;
            ++i;
            this.onMessage(message);
        }
        LOGGER.info("[" + this.getName() + "] Closing connection");
        consumer.close();
        session.close();
        connection.close();
        if (this.pauseBeforeShutdown) {
            LOGGER.info("[" + this.getName() + "] Press return to shut down");
            System.in.read();
        }
    }

    protected void consumeMessagesAndClose(Connection connection, Session session, MessageConsumer consumer, long timeout) throws JMSException, IOException {
        Message message;
        LOGGER.info("[" + this.getName() + "] We will consume messages while they continue to be delivered within: " + timeout + " ms, and then we will shutdown");
        while ((message = consumer.receive(timeout)) != null) {
            this.onMessage(message);
        }
        LOGGER.info("[" + this.getName() + "] Closing connection");
        consumer.close();
        session.close();
        connection.close();
        if (this.pauseBeforeShutdown) {
            LOGGER.info("[" + this.getName() + "] Press return to shut down");
            System.in.read();
        }
    }

    public void setAckMode(String ackMode) {
        if ("CLIENT_ACKNOWLEDGE".equals(ackMode)) {
            this.ackMode = 2;
        }
        if ("AUTO_ACKNOWLEDGE".equals(ackMode)) {
            this.ackMode = 1;
        }
        if ("DUPS_OK_ACKNOWLEDGE".equals(ackMode)) {
            this.ackMode = 3;
        }
        if ("SESSION_TRANSACTED".equals(ackMode)) {
            this.ackMode = 0;
        }
    }

    public void setClientId(String clientID) {
        this.clientId = clientID;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void setMaxiumMessages(int maxiumMessages) {
        this.maxiumMessages = maxiumMessages;
    }

    public void setPauseBeforeShutdown(boolean pauseBeforeShutdown) {
        this.pauseBeforeShutdown = pauseBeforeShutdown;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public void setReceiveTimeOut(long receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setParallelThreads(int parallelThreads) {
        if (parallelThreads < 1) {
            parallelThreads = 1;
        }
        ConsumerTool.parallelThreads = parallelThreads;
    }

    public void setTopic(boolean topic) {
        this.topic = topic;
    }

    public void setQueue(boolean queue) {
        this.topic = !queue;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

