/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.local;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.SOSShell;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.local.SOSLocalFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSFile;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSLocal
extends SOSCommonProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSLocal.class);
    private SOSProviderOptions providerOptions = null;
    private SOSShell shell = null;
    private int directoryFilesCount = 0;

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        this.providerOptions = options;
    }

    @Override
    public void delete(String pathname, boolean checkIsDirectory) {
        Path path = null;
        try {
            path = Paths.get(pathname, new String[0]).toAbsolutePath();
            Files.delete(path);
        }
        catch (Throwable ex) {
            this.reply = ex.toString();
            throw new JobSchedulerException("[delete]" + this.reply, ex);
        }
        this.reply = "rm OK";
        LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"delete", path, this.getReplyString()})));
    }

    @Override
    public void rename(String oldpath, String newpath) {
        Path source = null;
        Path dest = null;
        try {
            source = Paths.get(oldpath, new String[0]).toAbsolutePath();
            dest = Paths.get(newpath, new String[0]).toAbsolutePath();
            if (!Files.exists(dest, new LinkOption[0])) {
                try {
                    Files.move(source, dest, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    Files.move(source, dest, new CopyOption[0]);
                }
            } else {
                Files.move(source, dest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException("[rename]" + this.reply, e);
        }
        this.reply = "mv OK";
        LOGGER.info(this.getHostID(SOSVfs_I_189.params(new Object[]{source, dest, this.getReplyString()})));
    }

    @Override
    public void executeCommand(String cmd) throws Exception {
        this.executeCommand(cmd, null);
    }

    @Override
    public void executeCommand(String cmd, SOSEnv env) throws Exception {
        int exitCode;
        if (this.shell == null) {
            this.shell = new SOSShell();
        }
        String command = cmd.trim();
        if (this.shell.isWindows()) {
            command = this.shell.replaceCommand4Windows(command);
        }
        if ((exitCode = this.shell.executeCommand(command, env)) != 0) {
            boolean raiseException = true;
            if (this.providerOptions != null) {
                raiseException = this.providerOptions.raiseExceptionOnError.value();
            }
            if (raiseException) {
                throw new JobSchedulerException(SOSVfs_E_191.params(new Object[]{exitCode + ""}));
            }
            LOGGER.info(SOSVfs_D_151.params(new Object[]{command, SOSVfs_E_191.params(new Object[]{exitCode + ""})}));
        }
    }

    public SOSShell getShell() {
        if (this.shell == null) {
            this.shell = new SOSShell();
        }
        return this.shell;
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        SOSLocalFile file = new SOSLocalFile(fileName);
        file.setProvider(this);
        return file;
    }

    @Override
    public SOSFileEntry getFileEntry(String pathname) throws Exception {
        File file = new File(pathname);
        if (file.exists() && file.isFile()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s]found", pathname));
            }
            return this.getFileEntry(file);
        }
        return null;
    }

    private SOSFileEntry getFileEntry(File file) {
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.FILESYSTEM);
        entry.setDirectory(file.isDirectory());
        entry.setFilename(file.getName());
        entry.setFilesize(file.length());
        entry.setParentPath(file.getParent());
        return entry;
    }

    @Override
    public List<SOSFileEntry> listNames(String pathname, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) throws IOException {
        ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
        File dir = new File(pathname);
        if (checkIfExists && !dir.exists()) {
            return result;
        }
        if (checkIfIsDirectory && !dir.isDirectory()) {
            this.reply = "ls OK";
            return result;
        }
        File[] list = dir.listFiles();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[%s][listFiles] %s files or folders", pathname, list.length));
        }
        for (File file : list) {
            result.add(this.getFileEntry(file));
        }
        return result;
    }

    @Override
    public List<SOSFileEntry> getFileList(String folder, int maxFiles, boolean recursive, Pattern fileNamePattern, Pattern excludedDirectoriesPattern, boolean checkIfExists, String integrityHashType, int recLevel) throws Exception {
        this.directoryFilesCount = 0;
        if (excludedDirectoriesPattern == null) {
            return this.getFilelistOldMethod(folder, maxFiles, fileNamePattern.pattern(), 0, recursive, checkIfExists, integrityHashType);
        }
        Path dir = Paths.get(folder, new String[0]).toAbsolutePath();
        if (checkIfExists && !Files.exists(dir, new LinkOption[0])) {
            return new ArrayList<SOSFileEntry>();
        }
        if (recursive) {
            return this.getFileListRecursive(dir, maxFiles, fileNamePattern, excludedDirectoriesPattern, integrityHashType);
        }
        return this.getFileListNonRecursive(dir, maxFiles, fileNamePattern, integrityHashType);
    }

    private List<SOSFileEntry> getFileListNonRecursive(Path folder, int maxFiles, Pattern fileNamePattern, String integrityHashType) throws IOException {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(folder);){
            for (Path path : stream) {
                FileVisitResult fvr = this.checkMaxFiles(maxFiles);
                if (fvr != null) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][skip][preVisitDirectory][maxFiles=%s]exceeded", path, maxFiles));
                    }
                    ArrayList<SOSFileEntry> arrayList = result;
                    return arrayList;
                }
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                if (isTraceEnabled) {
                    LOGGER.trace(String.format("[%s]", path));
                }
                String fn = path.getFileName().toString();
                boolean add = true;
                if (integrityHashType != null && fn.endsWith(integrityHashType)) {
                    add = false;
                }
                if (!add || !fileNamePattern.matcher(fn).find()) continue;
                result.add(this.getFileEntry(path.toFile()));
                ++this.directoryFilesCount;
            }
        }
        return result;
    }

    private List<SOSFileEntry> getFileListRecursive(Path folder, final int maxFiles, final Pattern fileNamePattern, final Pattern excludedDirectoriesPattern, final String integrityHashType) throws IOException {
        final boolean isDebugEnabled = LOGGER.isDebugEnabled();
        final boolean isTraceEnabled = LOGGER.isTraceEnabled();
        final ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) {
                String path;
                FileVisitResult fvr = SOSLocal.this.checkMaxFiles(maxFiles);
                if (fvr != null) {
                    LOGGER.info(String.format("[skip]maxFiles=%s exceeded", maxFiles));
                    return fvr;
                }
                if (excludedDirectoriesPattern != null && excludedDirectoriesPattern.matcher(path = SOSCommonProvider.normalizePath(file.toAbsolutePath().toString())).find()) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][preVisitDirectory][match][excludedDirectories=%s]", path, excludedDirectoriesPattern.pattern()));
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!attrs.isDirectory()) {
                    FileVisitResult fvr = SOSLocal.this.checkMaxFiles(maxFiles);
                    if (fvr != null) {
                        LOGGER.info(String.format("[skip]maxFiles=%s exceeded", maxFiles));
                        return fvr;
                    }
                    if (isTraceEnabled) {
                        LOGGER.trace(String.format("[%s][visitFile]", file));
                    }
                    String fn = file.getFileName().toString();
                    boolean add = true;
                    if (integrityHashType != null && fn.endsWith(integrityHashType)) {
                        add = false;
                    }
                    if (add && fileNamePattern.matcher(fn).find()) {
                        result.add(SOSLocal.this.getFileEntry(file.toFile()));
                        SOSLocal.this.directoryFilesCount++;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }

    private FileVisitResult checkMaxFiles(int maxFiles) {
        return maxFiles > 0 && this.directoryFilesCount >= maxFiles ? FileVisitResult.TERMINATE : null;
    }

    private List<SOSFileEntry> getFilelistOldMethod(String folder, int maxFiles, String fileNameRegExp, int flag, boolean recursive, boolean checkIfExists, String integrityHashType) {
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
        try {
            Vector list = SOSFile.getFolderlist((String)folder, (String)fileNameRegExp, (int)flag, (boolean)recursive);
            if (isTraceEnabled) {
                LOGGER.trace(String.format("[%s][getFolderlist] %s files or folders", folder, list.size()));
            }
            for (File file : list) {
                FileVisitResult fvr = this.checkMaxFiles(maxFiles);
                if (fvr != null) {
                    LOGGER.info(String.format("[skip]maxFiles=%s exceeded", maxFiles));
                    return result;
                }
                if (file.isDirectory() || integrityHashType != null && file.getName().endsWith(integrityHashType)) continue;
                result.add(this.getFileEntry(file));
                ++this.directoryFilesCount;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        return result;
    }

    @Override
    public List<SOSFileEntry> getSubFolders(String folder, int maxFiles, boolean recursive, Pattern pattern, int recLevel) throws Exception {
        ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
        try {
            Vector list = SOSFile.getFolderlist((String)folder, (String)pattern.pattern(), (int)0, (boolean)recursive);
            for (File file : list) {
                if (!file.isDirectory()) continue;
                result.add(this.getFileEntry(file));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        return result;
    }

    @Override
    public OutputStream getOutputStream(String fileName, boolean append, boolean resume) {
        return null;
    }

    @Override
    public boolean isDirectory(String fileName) {
        return new File(fileName).isDirectory();
    }

    @Override
    public boolean directoryExists(String fileName) {
        File f;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]directoryExists", fileName));
        }
        return (f = new File(fileName)).isDirectory() && f.exists();
    }

    @Override
    public boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    @Override
    public void mkdir(String pathname) throws IOException {
        File dir = new File(pathname);
        if (!dir.exists()) {
            Files.createDirectories(dir.toPath().toAbsolutePath(), new FileAttribute[0]);
        } else if (!dir.isDirectory()) {
            throw new JobSchedulerException(SOSVfs_E_277.params(new Object[]{pathname}));
        }
    }

    @Override
    public void rmdir(String folderName) throws IOException {
        try (Stream<Path> stream = Files.walk(Paths.get(folderName, new String[0]), new FileVisitOption[0]);){
            for (Path p : stream.sorted(Comparator.reverseOrder()).collect(Collectors.toList())) {
                Files.delete(p);
            }
        }
        this.reply = "rmdir OK";
        LOGGER.info(String.format("[rmdir][%s]%s", folderName, this.reply));
    }
}

