/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.sftp;

import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommandResult;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.sftp.common.ISOSSFTP;
import com.sos.vfs.sftp.common.SOSSSHServerInfo;
import com.sos.vfs.sftp.jcraft.SOSSFTPJCraft;
import com.sos.vfs.sftp.sshj.SOSSFTPSSHJ;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Pattern;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSSFTP
extends SOSCommonProvider
implements ISOSSFTP {
    private static final Pattern HAS_WINDOWS_OPENSSH_DRIVER_LETTER_SPECIFIER = Pattern.compile("^/[a-zA-Z]:");
    private ISOSSFTP provider;

    public SOSSFTP(SOSOptionString sshProviderOption) {
        this.setProvider(sshProviderOption);
    }

    private void setProvider(SOSOptionString sshProviderOption) {
        String sshPovider;
        if (sshProviderOption == null) {
            SOSBaseOptions vfsOptions = new SOSBaseOptions();
            sshProviderOption = vfsOptions.ssh_provider;
        }
        this.provider = (sshPovider = sshProviderOption.getValue().toUpperCase()).equals(SSHProvider.JSCH.name()) ? new SOSSFTPJCraft() : new SOSSFTPSSHJ();
    }

    @Override
    public boolean isConnected() {
        return this.provider.isConnected();
    }

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        this.provider.connect(options);
    }

    @Override
    public void disconnect() {
        this.provider.disconnect();
    }

    @Override
    public void mkdir(String path) {
        this.provider.mkdir(path);
    }

    @Override
    public void rmdir(String path) {
        this.provider.rmdir(path);
    }

    @Override
    public boolean fileExists(String filename) {
        return this.provider.fileExists(filename);
    }

    @Override
    public boolean directoryExists(String filename) {
        return this.provider.directoryExists(filename);
    }

    @Override
    public boolean isDirectory(String filename) {
        return this.provider.isDirectory(filename);
    }

    @Override
    public long size(String filename) throws Exception {
        return this.provider.size(filename);
    }

    @Override
    public SOSFileEntry getFileEntry(String pathname) throws Exception {
        return this.provider.getFileEntry(pathname);
    }

    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) {
        return this.provider.listNames(path, maxFiles, checkIfExists, checkIfIsDirectory);
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) {
        this.provider.delete(path, checkIsDirectory);
    }

    @Override
    public void rename(String from, String to) {
        this.provider.rename(from, to);
    }

    @Override
    public void executeCommand(String cmd) {
        this.executeCommand(cmd, null);
    }

    @Override
    public void executeCommand(String cmd, SOSEnv env) {
        this.provider.executeCommand(cmd, env);
    }

    @Override
    public SOSCommandResult executeResultCommand(String cmd) throws Exception {
        SOSCommandResult result = this.provider.executeResultCommand(cmd);
        if (result.getException() != null) {
            throw new Exception(result.getException());
        }
        return result;
    }

    @Override
    public InputStream getInputStream(String fileName) {
        return this.provider.getInputStream(fileName);
    }

    @Override
    public OutputStream getOutputStream(String fileName, boolean append, boolean resume) {
        return this.provider.getOutputStream(fileName, append, resume);
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        return this.provider.getFile(fileName);
    }

    @Override
    public String getModificationDateTime(String path) {
        return this.provider.getModificationDateTime(path);
    }

    @Override
    public long putFile(String source, String target) {
        return this.provider.putFile(source, target);
    }

    @Override
    public void putFile(File source, String target, int chmod) throws Exception {
        this.provider.putFile(source, target, chmod);
    }

    @Override
    public void get(String source, String target) {
        this.provider.get(source, target);
    }

    @Override
    public String getStdErr() {
        return this.provider.getStdErr();
    }

    @Override
    public void resetStdErr() {
        this.provider.resetStdErr();
    }

    @Override
    public String getStdOut() {
        return this.provider.getStdOut();
    }

    @Override
    public void resetStdOut() {
        this.provider.resetStdOut();
    }

    @Override
    public Integer getExitCode() {
        return this.provider.getExitCode();
    }

    @Override
    public String getExitSignal() {
        return this.provider.getExitSignal();
    }

    @Override
    public boolean isSimulateShell() {
        return this.provider.isSimulateShell();
    }

    @Override
    public void setSimulateShell(boolean val) {
        this.provider.setSimulateShell(val);
    }

    @Override
    public boolean isExecSessionExists() {
        return this.provider.isExecSessionExists();
    }

    @Override
    public boolean isExecSessionConnected() {
        return this.provider.isExecSessionConnected();
    }

    @Override
    public void execSessionSendSignalContinue() throws Exception {
        this.provider.execSessionSendSignalContinue();
    }

    @Override
    public SOSSSHServerInfo getSSHServerInfo() {
        return this.provider.getSSHServerInfo();
    }

    public static boolean hasWindowsOpenSSHDriverLetterSpecifier(String path) {
        return HAS_WINDOWS_OPENSSH_DRIVER_LETTER_SPECIFIER.matcher(path).find();
    }

    @Override
    public boolean isSFTP() {
        return true;
    }

    public static enum SSHProvider {
        JSCH,
        SSHJ;

    }
}

