/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.smb.smbj;

import com.hierynomus.smbj.share.File;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.vfs.smb.common.SOSSMBFile;
import com.sos.vfs.smb.smbj.SOSSMBJ;
import java.io.InputStream;
import java.io.OutputStream;

public class SOSSMBJFile
extends SOSSMBFile {
    private File smbFile;

    public SOSSMBJFile(String path) {
        super(path);
    }

    @Override
    public InputStream getFileInputStream() {
        try {
            if (this.getInputStream() == null) {
                this.fileName = super.adjustRelativePathName(this.fileName);
                SOSSMBJ handler = (SOSSMBJ)this.getProvider();
                this.smbFile = handler.openFile2Read(this.fileName);
                if (this.smbFile == null) {
                    throw new Exception("openFile2Read failed");
                }
                this.setInputStream(this.smbFile.getInputStream());
            }
        }
        catch (Throwable e) {
            throw new JobSchedulerException(SOSVfs_E_158.params(new Object[]{"getFileInputStream()", this.fileName}), e);
        }
        return this.getInputStream();
    }

    @Override
    public OutputStream getFileOutputStream() {
        try {
            if (this.getOutputStream() == null) {
                this.fileName = super.adjustRelativePathName(this.fileName);
                SOSSMBJ handler = (SOSSMBJ)this.getProvider();
                this.smbFile = handler.openFile2Write(this.fileName, this.isModeAppend());
                if (this.smbFile == null) {
                    throw new Exception("openFile2Write failed");
                }
                this.setOutputStream(this.smbFile.getOutputStream(this.isModeAppend()));
            }
        }
        catch (Throwable e) {
            throw new JobSchedulerException(SOSVfs_E_158.params(new Object[]{"getFileOutputStream()", this.fileName}), e);
        }
        return this.getOutputStream();
    }

    @Override
    public void closeInput() {
        super.closeInput();
        this.closeSmbFile();
    }

    @Override
    public void closeOutput() {
        super.closeOutput();
        this.closeSmbFile();
    }

    private void closeSmbFile() {
        if (this.smbFile != null) {
            try {
                this.smbFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

