/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.webdav.jackrabbit.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.vfs.http.common.SOSHTTPClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class SOSWebDAVOutputStream
extends ByteArrayOutputStream {
    private CloseableHttpClient client;
    private URI uri;

    public SOSWebDAVOutputStream(CloseableHttpClient client, URI uri) {
        this.client = client;
        this.uri = uri;
    }

    @Override
    public void close() throws IOException {
        try {
            this.executePutMethod(this.toByteArray());
        }
        catch (Throwable e) {
            throw new JobSchedulerException(e);
        }
        finally {
            super.close();
        }
    }

    private void executePutMethod(byte[] data) throws Exception {
        HttpPut p = new HttpPut(this.uri);
        p.addHeader("Expect", "100-continue");
        p.setEntity((HttpEntity)new ByteArrayEntity(data));
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)p);){
            StatusLine sl = response.getStatusLine();
            if (!SOSHTTPClient.isSuccessStatusCode(sl)) {
                throw new Exception(SOSHTTPClient.getResponseStatus(this.uri, sl));
            }
        }
    }
}

