/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.engine.jobapi.scripting;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.sos.scheduler.engine.jobapi.scripting.ScriptInstance;

public class JobScriptInstanceAdapter {
    private final ScriptInstance scriptInstance;

    public JobScriptInstanceAdapter(String language, Supplier<ImmutableMap<String, Object>> bindingsLazy, String script) {
        this.scriptInstance = new ScriptInstance(language, bindingsLazy, script);
    }

    public final boolean callInit(boolean deflt) throws Exception {
        this.loadScript();
        return this.scriptInstance.callBooleanWhenExists(deflt, "spooler_init", new Object[0]);
    }

    public final void callExit() {
        try {
            this.scriptInstance.callWhenExists("spooler_exit", new Object[0]);
        }
        finally {
            this.scriptInstance.close();
        }
    }

    public final boolean callOpen(boolean deflt) throws Exception {
        return this.scriptInstance.callBooleanWhenExists(deflt, "spooler_open", new Object[0]);
    }

    public final void callClose() throws Exception {
        this.scriptInstance.callWhenExists("spooler_close", new Object[0]);
    }

    public final boolean callProcess(boolean deflt) throws Exception {
        return this.scriptInstance.callBooleanWhenExists(deflt, "spooler_process", new Object[0]);
    }

    public final void callOnError() throws Exception {
        this.scriptInstance.callWhenExists("spooler_on_error", new Object[0]);
    }

    public final void callOnSuccess() throws Exception {
        this.scriptInstance.callWhenExists("spooler_on_success", new Object[0]);
    }

    public final boolean callTaskBefore() throws Exception {
        this.loadScript();
        return this.scriptInstance.callBooleanWhenExists(true, "spooler_task_before", new Object[0]);
    }

    public final void callTaskAfter() throws Exception {
        try {
            this.scriptInstance.callWhenExists("spooler_task_after", new Object[0]);
        }
        finally {
            this.scriptInstance.close();
        }
    }

    public final boolean callProcessBefore() throws Exception {
        return this.scriptInstance.callBooleanWhenExists(true, "spooler_process_before", new Object[0]);
    }

    public final boolean callProcessAfter(boolean spoolerProcessResult) throws Exception {
        return this.scriptInstance.callBooleanWhenExists(spoolerProcessResult, "spooler_process_after", spoolerProcessResult);
    }

    private void loadScript() {
        this.scriptInstance.loadScript();
    }
}

