/*
 * Decompiled with CFR 0.152.
 */
package sos.spooler.jobs;

import java.util.Objects;
import sos.spooler.Beans;
import sos.spooler.HasBean;

public class ScriptAdapterHelper {
    private static final String beanLanguagePrefix = "java";
    private static final String methodLanguagePrefix = "javax.script";

    private ScriptAdapterHelper() {
    }

    static Parameters parseLanguageParameter(String prefixedLanguageString) {
        String[] parts = prefixedLanguageString.split(":", 2);
        if (parts.length != 2) {
            throw new RuntimeException("Invalid language='" + prefixedLanguageString + "'");
        }
        boolean isBeanCall = ScriptAdapterHelper.languagePrefixIsBeanCall(parts[0]);
        String language = parts[1];
        return new Parameters(language, isBeanCall);
    }

    static Object conditionalToBean(boolean isToBean, HasBean<?> o) {
        return isToBean ? Beans.toBean(o) : o;
    }

    static boolean languagePrefixIsBeanCall(String prefix) {
        if (prefix.equals(beanLanguagePrefix)) {
            return true;
        }
        if (prefix.startsWith(methodLanguagePrefix)) {
            return false;
        }
        throw new RuntimeException("Invalid language prefix '" + prefix + "'. '" + beanLanguagePrefix + "' or '" + methodLanguagePrefix + "' expected");
    }

    static final class Parameters {
        final String language;
        final boolean isUsingBean;

        Parameters(String language, boolean isBeanCall) {
            this.language = language;
            this.isUsingBean = isBeanCall;
        }

        public boolean equals(Object o) {
            return this.language.equals(((Parameters)o).language) && this.isUsingBean == ((Parameters)o).isUsingBean;
        }

        public int hashCode() {
            return Objects.hashCode(this.language) + Boolean.hashCode(this.isUsingBean);
        }
    }
}

