@echo off
@rem 
@rem ------------------------------------------------------------
@rem Company: Software- und Organisations-Service GmbH
@rem Author : Oliver Haufe <oliver.haufe@sos-berlin.com>
@rem ------------------------------------------------------------
SETLOCAL

set YADE_ARGS=
set YADE_FIRST_ARG=%~1
set YADE_SCRIPT=%~dpnx0
set YADE_HOME=%~dp0..

set YADE_JAVA_OPTIONS=%JAVA_OPTIONS%
if not defined YADE_LOG_LEVEL set YADE_LOG_LEVEL=INFO
set VERBOSE_PARAM=
set WITH_SETTINGS=
set WITH_RETURNVALUES=

:hide_passw_and_read_java_options
set YADE_ARG=%~1
if not defined YADE_ARG goto set_params
set YADE_ARG_QUOTED=%1
set YADE_ARG2=%2

if "%YADE_ARG%" == %YADE_ARG_QUOTED% (
  if "%YADE_ARG_QUOTED:~1,9%" == "-password" (
    set YADE_ARGS=%YADE_ARGS% -password=***
  ) else (
    if "%YADE_ARG_QUOTED:~1,13%" == "-java-options" (
      call :set_java_options "%YADE_ARG_QUOTED:~15,-1%"
    ) else (
      if "%YADE_ARG_QUOTED:~1,10%" == "-log-level" (
        call :set_log_level "%YADE_ARG_QUOTED:~12,-1%"
      ) else (
        if "%YADE_ARG_QUOTED:~1,9%" == "-settings" (
          set WITH_SETTINGS=1 
          set YADE_ARGS=%YADE_ARGS% %YADE_ARG_QUOTED%
        ) else (
          if "%YADE_ARG_QUOTED:~1,14%" == "-return-values" (
            set WITH_RETURNVALUES=1 
            set YADE_ARGS=%YADE_ARGS% %YADE_ARG_QUOTED%
          ) else (
            set YADE_ARGS=%YADE_ARGS% %YADE_ARG_QUOTED%
          )
        )
      )
    )
  )
  shift
) else (
  if "%YADE_ARG:~0,9%" == "-password" (
    set YADE_ARGS=%YADE_ARGS% -password=***
  ) else (
    if "%YADE_ARG:~0,13%" == "-java-options" (
      call :set_java_options %YADE_ARG2%
    ) else (
      if "%YADE_ARG:~0,10%" == "-log-level" (
        call :set_log_level %YADE_ARG2%
      ) else (
        if "%YADE_ARG:~0,9%" == "-settings" (
          set WITH_SETTINGS=1
          set YADE_ARGS=%YADE_ARGS% %YADE_ARG%=%YADE_ARG2%
        ) else (
          if "%YADE_ARG:~0,14%" == "-return-values" (
            set WITH_RETURNVALUES=1
            set YADE_ARGS=%YADE_ARGS% %YADE_ARG%=%YADE_ARG2%
          ) else (
            set YADE_ARGS=%YADE_ARGS% %YADE_ARG%=%YADE_ARG2%
          )
        )
      )
    )
  )
  shift
  shift
)
goto hide_passw_and_read_java_options

:set_java_options
set YADE_JAVA_OPTIONS=%~1
goto final

:set_log_level
set LOG_LEVEL=%~1
if /I "DEBUG" == "%LOG_LEVEL%" (
  set YADE_LOG_LEVEL=%LOG_LEVEL%
  set VERBOSE_PARAM=-verbose 3
)
if /I "TRACE" == "%LOG_LEVEL%" (
  set YADE_LOG_LEVEL=%LOG_LEVEL%
  set VERBOSE_PARAM=-verbose 9
)
goto final

:set_params
set SETTINGS_PARAM=
if not defined WITH_SETTINGS (
  if defined JS7_YADE_CONFIG_DIR (
    set SETTINGS_PARAM= -settings "%JS7_YADE_CONFIG_DIR%\yade.xml"
    set YADE_ARGS=%YADE_ARGS% -settings="%JS7_YADE_CONFIG_DIR%\yade.xml"
  ) 
)

set RETURNVALUES_PARAM=
if not defined WITH_RETURNVALUES (
  if defined JS7_RETURN_VALUES (
    set RETURNVALUES_PARAM= -return-values "%JS7_RETURN_VALUES%"
    set YADE_ARGS=%YADE_ARGS% -return-values="%JS7_RETURN_VALUES%"
  )
  if defined SCHEDULER_RETURN_VALUES (
    set RETURNVALUES_PARAM= -return-values "%SCHEDULER_RETURN_VALUES%"
    set YADE_ARGS=%YADE_ARGS% -return-values="%SCHEDULER_RETURN_VALUES%"
  ) 
)

:banner
echo.
echo + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
echo +                     START  : YADE4DMZ.CMD                       +
echo +                     ---------------------                       +
echo + DATE     : %DATE% %TIME%
echo + HOSTNAME : %COMPUTERNAME%
echo + USER     : %USERNAME%
echo + CALL     : %YADE_SCRIPT%%YADE_ARGS%
echo +                                                                 +
echo + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
echo.

if "%YADE_FIRST_ARG%"=="" goto usage
if "%YADE_FIRST_ARG%"=="-?" goto usage
if "%YADE_FIRST_ARG%"=="/?" goto usage
if /I "%YADE_FIRST_ARG%"=="-h" goto usage
if /I "%YADE_FIRST_ARG%"=="--help" goto usage
goto next

:usage
echo YADE requires parameters. Please see
echo https://kb.sos-berlin.com/display/PKB/JADE+-+Documentation
echo.
exit /B 1

:next
call :normalize_home "%YADE_HOME%\dummy"
set YADE_BIN=%YADE_HOME%\bin
set CLASSPATH_BASE=%YADE_HOME%\lib
if not exist "%CLASSPATH_BASE%" (
  echo Classpath directory "%CLASSPATH_BASE%" does not exist.
  echo.
  exit /B 1
)
if not defined LOG4JPROP (
  if exist "%YADE_HOME%\lib\log4j2.xml" set LOG4JPROP=-Dlog4j.configurationFile="file:///%YADE_HOME%/lib/log4j2.xml"
)

set JAVA_BIN=java.exe
if exist "%JAVA_HOME%\bin\java.exe" set JAVA_BIN=%JAVA_HOME%\bin\java.exe

@rem set classpath 
set CLASSPATH_BASE=%CLASSPATH_BASE:\=/%
set CP=%CLASSPATH_BASE%/patches/*;%CLASSPATH_BASE%/user_lib/*;%CLASSPATH_BASE%/3rd-party/*;%CLASSPATH_BASE%/sos/*

@rem set log env
set YADE_LOGS=%TEMP%
if defined JS7_AGENT_LOGS set YADE_LOGS=%JS7_AGENT_LOGS%
set YADE_TZ=Etc/UTC
if defined JS7_AGENT_TZ set YADE_TZ=%JS7_AGENT_TZ%

echo.%YADE_JAVA_OPTIONS% | findstr /I /C:-Xmx >nul
if ERRORLEVEL 1 set YADE_JAVA_OPTIONS=%YADE_JAVA_OPTIONS% -Xmx32m

"%JAVA_BIN%" %LOG4JPROP% %YADE_JAVA_OPTIONS% -classpath "%CP%" com.sos.DataExchange.SOSDataExchangeEngine4DMZMain %* %VERBOSE_PARAM%%SETTINGS_PARAM%%RETURNVALUES_PARAM%
set /A YADE_EXIT=%ERRORLEVEL%

echo.
echo + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
echo +                      END   : YADE4DMZ.CMD                       +
echo +                      --------------------                       +
echo + DATE     : %DATE% %TIME%
echo + HOSTNAME : %COMPUTERNAME%
echo + USER     : %USERNAME%
echo + CALL     : %YADE_SCRIPT%%YADE_ARGS%
echo + EXIT     : %YADE_EXIT%
echo +                                                                 +
echo + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
echo.

exit /B %YADE_EXIT%

:normalize_home
set YADE_HOME=%~dp1
set YADE_HOME=%YADE_HOME:~0,-1%
goto final

ENDLOCAL
:final