/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.process.SOSCommandResult;
import com.sos.izpack.process.SOSShell;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipal;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class ChangeWindowsACL
extends ProcessHelper {
    private static final String SID_LOCAL_SYSTEM = "S-1-5-18";
    private final Set<AclEntryPermission> modAccess = EnumSet.of(AclEntryPermission.READ_DATA, new AclEntryPermission[]{AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_ACL, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_DATA, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.APPEND_DATA, AclEntryPermission.DELETE, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.EXECUTE});
    private final Set<AclEntryFlag> inheritflags = EnumSet.of(AclEntryFlag.DIRECTORY_INHERIT, AclEntryFlag.FILE_INHERIT);
    private boolean accessProcessed = false;

    @Override
    public boolean run(String[] args) throws Exception {
        this.ok = true;
        Path appDataPath = Paths.get(this.idata.getVariable("APPDATA_PATH"), new String[0]);
        String installMode = this.idata.getVariable("installMode");
        this.setACLsForWindowsServiceAccountRecursive(appDataPath);
        if ("agent".equals(installMode) || "controller".equals(installMode)) {
            this.setACLsForWindowsServiceAccountRecursive(this.idata.getVariable("configPath"), appDataPath);
            this.setACLsForWindowsServiceAccountRecursive(this.idata.getVariable("logPath"), appDataPath);
            this.setACLsForWindowsServiceAccountRecursive(this.idata.getVariable("pidFilePath"), appDataPath);
        }
        return true;
    }

    private boolean directoryIsHomeOfPrincipal(Path dir, UserPrincipal principal) {
        Path home;
        String serviceUser = this.idata.getVariable("USER_NAME");
        if (principal != null) {
            serviceUser = principal.getName().replaceFirst("^[^\\\\]+\\\\(.*)$", "$1");
        }
        return dir.startsWith(home = Paths.get(this.idata.getVariable("USER_HOME"), new String[0])) && this.idata.getVariable("USER_NAME").equalsIgnoreCase(serviceUser);
    }

    private boolean setACLsForWindowsServiceAccountRecursive(Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            String hostname = this.idata.getVariable("HOST_NAME");
            UserPrincipal principal2 = null;
            UserPrincipal principal = ProcessHelper.getWindowsAccount(this.idata.getVariable("serviceAccount"), hostname);
            if (this.directoryIsHomeOfPrincipal(path, principal)) {
                return true;
            }
            if (principal == null) {
                principal = ProcessHelper.getWindowsAccount(this.getLocalSystemFromSID(), hostname);
                principal2 = ProcessHelper.getWindowsAccount(".\\" + this.idata.getVariable("USER_NAME"), hostname);
            }
            if (principal == null && principal2 == null) {
                return false;
            }
            if (this.directoryIsHomeOfPrincipal(path, null)) {
                return true;
            }
            this.callHeader(path.toString());
            if (!Files.isDirectory(path, new LinkOption[0])) {
                this.log("... %1$s is not a directory.", path.toString());
                return false;
            }
            return this.setModAccessRecursive(path, principal, principal2);
        }
        catch (IOException e) {
            this.log(e);
            return false;
        }
    }

    private boolean setACLsForWindowsServiceAccountRecursive(String dir, Path defaultParentDir) {
        if (dir == null || dir.isEmpty()) {
            return true;
        }
        Path path = Paths.get(dir, new String[0]);
        if (defaultParentDir != null && path.startsWith(defaultParentDir)) {
            return true;
        }
        return this.setACLsForWindowsServiceAccountRecursive(path);
    }

    private void callHeader(String dir) {
        this.writeHeader("Set ACLs in " + dir);
    }

    private boolean hasAccess(AclEntry aclEntry, List<AclEntry> aclEntries) {
        return aclEntries.stream().filter(entry -> entry.principal().equals(aclEntry.principal())).filter(entry -> entry.type().equals((Object)aclEntry.type())).filter(entry -> entry.flags().containsAll(aclEntry.flags())).filter(entry -> entry.permissions().containsAll(aclEntry.permissions())).count() > 0L;
    }

    private boolean setAccess(Path path, UserPrincipal account, Set<AclEntryPermission> permissions) throws IOException {
        List<AclEntry> aclEntries;
        AclEntry newEntry;
        AclFileAttributeView aclView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        AclEntry.Builder builder = AclEntry.newBuilder();
        builder.setPrincipal(account);
        builder.setType(AclEntryType.ALLOW);
        builder.setPermissions(permissions);
        if (Files.isDirectory(path, new LinkOption[0])) {
            builder.setFlags(this.inheritflags);
        }
        if (!this.hasAccess(newEntry = builder.build(), aclEntries = aclView.getAcl())) {
            try {
                aclEntries.add(0, newEntry);
                aclView.setAcl(aclEntries);
                return true;
            }
            catch (IOException e) {
                this.log("error with adding ACL %1$s%nfor %2$s", newEntry.toString(), path.toString());
                throw e;
            }
        }
        return false;
    }

    private boolean setAccessRecursive(Path path, final UserPrincipal account, final Set<AclEntryPermission> permissions) throws IOException {
        this.accessProcessed = this.setAccess(path, account, permissions);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String subDirName;
                if (Files.isSymbolicLink(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (ChangeWindowsACL.this.setAccess(dir, account, permissions)) {
                    ChangeWindowsACL.this.accessProcessed = true;
                }
                if ((subDirName = dir.getFileName().toString()).equals("temp") || subDirName.equals("tmp") || subDirName.equals("logs") || subDirName.equals("live")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                int numOfPathElemes = dir.getNameCount();
                if (numOfPathElemes > 1 && dir.getName(numOfPathElemes - 2).toString().equals("config") && !subDirName.equals("private") && !subDirName.equals("executable")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    if (Files.isSymbolicLink(file)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (ChangeWindowsACL.this.setAccess(file, account, permissions)) {
                        ChangeWindowsACL.this.accessProcessed = true;
                    }
                }
                catch (Exception e) {
                    ChangeWindowsACL.this.log(e);
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return this.accessProcessed;
    }

    private boolean setModAccessRecursive(Path path, UserPrincipal ... accounts) throws IOException {
        boolean ret = false;
        for (UserPrincipal account : accounts) {
            if (account == null) continue;
            System.out.println("set ACLs for " + account.getName());
            if (!this.setAccessRecursive(path, account, this.modAccess)) continue;
            this.log("... set read/write access for Windows service account in %n'%1$s'", path.toString());
            ret = true;
        }
        if (!ret) {
            this.log("... nothing to do", new Object[0]);
        }
        return ret;
    }

    private String getPrincipalNameFromSID(String sid) {
        SOSCommandResult pr = new SOSCommandResult();
        String[] dbs = new String[]{"group", "sysaccount"};
        try {
            for (String db : dbs) {
                pr = SOSShell.executeCommand("wmic", db, "where", "sid='" + sid + "'", "get", "name", "/format:value");
                if (pr.getExitCode() != 0 || pr.getStdErr().trim().length() != 0) continue;
                return pr.getStdOut().trim().replaceFirst("[^=]+=([^\r\n]*)", "$1");
            }
        }
        catch (Throwable e) {
            this.log(e.toString(), new Object[0]);
        }
        return null;
    }

    private String getLocalSystemFromSID() {
        return this.getPrincipalNameFromSID(SID_LOCAL_SYSTEM);
    }
}

