/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.util.AccessValidator;
import com.sos.izpack.util.HostPortValidator;
import com.sos.izpack.util.Install;
import com.sos.izpack.util.LookForPreviousInstallation;

public class LookForPreviousInstallationValidator
implements DataValidator {
    private String errorMessageId = "install.notexist.error";

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return "install.notexist.warning";
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        try {
            AccessValidator accessValidator;
            this.errorMessageId = "install.notexist.error";
            boolean installationFound = false;
            boolean installationError = false;
            boolean withRestartJS = true;
            if (idata.getVariable("withRestartJS") != null && idata.getVariable("withRestartJS").equalsIgnoreCase("false")) {
                withRestartJS = false;
            }
            try {
                installationFound = new LookForPreviousInstallation().run(idata);
                Install.setInstallError(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                Install.setInstallError(e.getMessage());
                installationError = true;
            }
            if (OsVersion.IS_UNIX && (idata.getVariable("runningUser") == null || idata.getVariable("runningUser").isEmpty())) {
                idata.setVariable("runningUser", idata.getVariable("USER_NAME"));
                idata.setVariable("runningUserHome", idata.getVariable("USER_HOME"));
            }
            String installMode = "install";
            if (idata.getVariable("installMode") != null) {
                installMode = idata.getVariable("installMode");
            }
            if (installMode.equals("update")) {
                if (installationError) {
                    System.out.println(String.format("The data of the previous installation are incomplete under %1$s.", idata.getInstallPath()));
                    this.errorMessageId = "install.incomplete.error";
                    return DataValidator.Status.ERROR;
                }
                if (!installationFound) {
                    System.out.println(String.format("No Controller installations are found under %1$s.", idata.getInstallPath()));
                    this.errorMessageId = "install.notexist.error";
                    return DataValidator.Status.ERROR;
                }
                if (idata.getVariable("numOfPrevInstallations").equals("1") && withRestartJS) {
                    HostPortValidator hostPortValidator = new HostPortValidator();
                    if (hostPortValidator.validateData(idata) == DataValidator.Status.ERROR) {
                        this.errorMessageId = hostPortValidator.getErrorMessageId();
                        return DataValidator.Status.ERROR;
                    }
                    AccessValidator accessValidator2 = new AccessValidator();
                    if (accessValidator2.validateData(idata) == DataValidator.Status.ERROR) {
                        this.errorMessageId = accessValidator2.getErrorMessageId();
                        return DataValidator.Status.ERROR;
                    }
                }
            } else if (installMode.equals("agent") && (accessValidator = new AccessValidator()).validateData(idata) == DataValidator.Status.ERROR) {
                this.errorMessageId = accessValidator.getErrorMessageId();
                return DataValidator.Status.ERROR;
            }
        }
        catch (Exception e) {
            System.out.println("LookForPreviousInstallationValidator: " + e.toString());
        }
        return DataValidator.Status.OK;
    }
}

