/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.util.OsVersion;

public class OSInfo {
    private static final String[] keys = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"};
    public static final boolean HAS_32BIT = OSInfo.has32Bits();
    public static final boolean HAS_64BIT = OSInfo.has64Bits();
    public static final boolean IS_WINDOWS_AMD64 = OsVersion.IS_WINDOWS && HAS_64BIT && OSInfo.archAMD();
    public static final boolean IS_WINDOWS_IA64 = OsVersion.IS_WINDOWS && HAS_64BIT && OSInfo.archIA();
    public static final boolean IS_WINDOWS_X86 = OsVersion.IS_WINDOWS && HAS_32BIT;

    public static int getNumOfBits() {
        int numOfBits = 32;
        for (String key : keys) {
            String property = System.getProperty(key);
            if (property == null || property.equalsIgnoreCase("unknown") || property.indexOf("64") < 0) continue;
            numOfBits = 64;
        }
        return numOfBits;
    }

    public static boolean has32Bits() {
        return OSInfo.getNumOfBits() == 32;
    }

    public static boolean has64Bits() {
        return OSInfo.getNumOfBits() == 64;
    }

    public static boolean archAMD() {
        return System.getProperty("os.arch").toUpperCase().contains("AMD");
    }

    public static boolean archIA() {
        return System.getProperty("os.arch").toUpperCase().contains("IA");
    }
}

