/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.coi.tools.os.izpack.Registry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class Install {
    public static Registry reg;
    public static Boolean isAutomatedInstallation;
    private static String dbConnectionError;
    private static String installError;
    public static boolean isSuccessful;
    private static Map<String, Path> driverFiles;

    public static void setDbConnectionError(String err) {
        dbConnectionError = err;
    }

    public static String getDbConnectionError() {
        return dbConnectionError;
    }

    public static void setInstallError(String err) {
        installError = err;
    }

    public static String getInstallError() {
        return installError;
    }

    public static void cleanDriverFiles() {
        driverFiles.values().forEach(df -> {
            try {
                Files.deleteIfExists(df);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getDriverFile(String classname) throws IOException {
        if (driverFiles.get(classname) == null) {
            Path driverFile = Files.createTempFile("sosjdbc", ".jar", new FileAttribute[0]);
            InputStream inStream = null;
            OutputStream outStream = null;
            try {
                int bytesRead;
                inStream = Install.class.getClassLoader().getResourceAsStream(Install.getResource(classname));
                if (inStream == null) {
                    throw new IOException("Resource of internal driver not found: " + classname);
                }
                outStream = Files.newOutputStream(driverFile, new OpenOption[0]);
                byte[] buffer = new byte[8192];
                while ((bytesRead = inStream.read(buffer)) != -1) {
                    outStream.write(buffer, 0, bytesRead);
                }
                driverFiles.put(classname, driverFile);
                URL uRL = driverFile.toUri().toURL();
                return uRL;
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return driverFiles.get(classname).toUri().toURL();
    }

    private static String getResource(String classname) throws IOException {
        switch (classname) {
            case "org.mariadb.jdbc.Driver": {
                return "resources/mariadb.jar";
            }
            case "oracle.jdbc.OracleDriver": 
            case "oracle.jdbc.driver.OracleDriver": {
                return "resources/ojdbc.jar";
            }
            case "org.postgresql.Driver": {
                return "resources/postgresql.jar";
            }
        }
        throw new IOException("Internal driver not found: " + classname);
    }

    static {
        isAutomatedInstallation = Boolean.FALSE;
        dbConnectionError = "";
        installError = "";
        isSuccessful = true;
        driverFiles = new HashMap<String, Path>();
    }
}

