/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.JettyJavaOptions;
import com.sos.izpack.util.Install;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class LookForPreviousInstallation {
    private Properties previousVars = new Properties();
    private Properties defaultVars = new Properties();
    private final String[] exceptVars = new String[]{"installInformationName", "installInformationExist", "numOfPrevInstallations", "installMode", "os", "shortcutFolder", "XInfoPanel.font", "InstallerFrame.logfilePath", "databaseCreateTables", "prevJdbcConnectionUrl", "dbConnectionError", "licenseFile", "licenseOption", "renameInstallInformationError", "ShowCreateDirectoryMessage", "ShowExistsDirectoryWarning", "pathIntro", "autoScriptName", "registerUninstaller", "withJetty", "bit", "logDir", "logPathDefault", "withJettyInstall"};
    private final List<String> notFatalErrors = new ArrayList<String>();
    private String installInformationName = null;
    private boolean updateMode = false;
    private boolean agentMode = false;
    private boolean jocMode = false;
    private boolean controllerMode = false;
    private int numOfPrevInstallations = 0;
    BiPredicate<Path, BasicFileAttributes> subDirFilter = (path, fileAttr) -> {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        Path jsinstallInformation = path.resolve(this.installInformationName);
        if (Files.isReadable(jsinstallInformation) && Files.isRegularFile(jsinstallInformation, new LinkOption[0])) {
            System.out.println(jsinstallInformation.toAbsolutePath().toString() + " found.");
            return true;
        }
        return false;
    };

    public boolean run(InstallData idata) throws Exception {
        return this.run(idata, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(InstallData idata, String subDir) throws Exception {
        block20: {
            this.installInformationName = idata.getVariable("installInformationName");
            if (this.installInformationName == null) {
                this.installInformationName = ".installationinformation";
            }
            if (idata.getVariable("installMode") != null) {
                this.updateMode = idata.getVariable("installMode").contains("update");
                this.agentMode = idata.getVariable("installMode").contains("agent");
                this.jocMode = idata.getVariable("installMode").contains("joc");
                this.controllerMode = idata.getVariable("installMode").contains("controller");
            }
            idata.setVariable("installInformationExist", "no");
            try {
                Path installDir = Paths.get(idata.getInstallPath(), new String[0]).toAbsolutePath();
                if (subDir != null) {
                    installDir = installDir.resolve(subDir);
                    this.numOfPrevInstallations = 1;
                } else if ((installDir = this.lookingForLastPreviousInstallation(installDir, idata)) != null) {
                    subDir = installDir.getFileName().toString();
                }
                if (this.numOfPrevInstallations > 1 && this.updateMode) {
                    boolean bl = true;
                    return bl;
                }
                if (installDir != null && this.readPreviousInstallation(installDir)) {
                    Path renamedAppDataDir;
                    if (this.readDefaultVars()) {
                        this.setCurrentVars(idata.getVariables().getProperties());
                    }
                    idata.setVariable("installInformationExist", "yes");
                    Path appDataDir = Paths.get(this.previousVars.getProperty("APPDATA_PATH"), new String[0]);
                    if (!Files.exists(appDataDir, new LinkOption[0]) && subDir != null && Files.exists(renamedAppDataDir = appDataDir.getParent().resolve(subDir), new LinkOption[0])) {
                        appDataDir = renamedAppDataDir;
                    }
                    idata.setAttribute("APPDATA_PATH", appDataDir.toAbsolutePath());
                    this.updateInstallData(installDir, appDataDir, idata);
                } else if (installDir == null && this.updateMode) {
                    boolean appDataDir = false;
                    return appDataDir;
                }
                this.jocInstallData(idata);
                this.jocSettingsData(idata);
                this.setDbmsDefault(idata);
                boolean appDataDir = true;
                return appDataDir;
            }
            catch (Exception e) {
                this.notFatalErrors.add(e.getMessage());
                if (this.updateMode) {
                    throw e;
                }
            }
            finally {
                idata.setAttribute("notFatalErrors", this.notFatalErrors);
                if (this.updateMode) break block20;
                for (String notFatalError : this.notFatalErrors) {
                    System.out.println(notFatalError);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchedulerEnvs(Path installDir, InstallData idata) throws IOException, InterruptedException, RuntimeException {
        String scriptExt = ".sh";
        if (OsVersion.IS_WINDOWS) {
            scriptExt = ".cmd";
        }
        BufferedReader in = null;
        Path envscript = null;
        Path instscript = null;
        if (this.controllerMode || this.updateMode) {
            instscript = installDir.resolve("bin/controller_instance" + scriptExt);
            envscript = installDir.resolve("bin/environment_variables" + scriptExt);
            if (instscript != null && Files.isReadable(instscript)) {
                System.out.println("Environment variables from " + instscript.toString() + " are reading.");
                try {
                    Pattern p = Pattern.compile("^(?:[ ]*[sS][eE][tT][ ]+)?([^=]+)=(.*)$");
                    Matcher m = null;
                    in = Files.newBufferedReader(instscript);
                    String str = "";
                    while ((str = in.readLine()) != null) {
                        m = p.matcher(str = str.trim());
                        if (!m.find()) continue;
                        switch (m.group(1)) {
                            case "JS7_CONTROLLER_ID": {
                                idata.setVariable("controllerId", m.group(2));
                                System.out.println("ControllerId = " + idata.getVariable("controllerId"));
                                break;
                            }
                            case "JS7_SERVICE_NAME_SUFFIX": {
                                idata.setVariable("serviceNameSuffix", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_DATA": {
                                idata.setVariable("APPDATA_PATH", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_USER": {
                                idata.setVariable("controllerUser", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_LOGS": 
                            case "JS7_CONTROLLER_LOG_DIR": {
                                idata.setVariable("logPath", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_PID_FILE_DIR": {
                                idata.setVariable("pidFilePath", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_PID_FILE_NAME": {
                                idata.setVariable("pidFileName", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_CONFIG_DIR": {
                                idata.setVariable("configPath", m.group(2));
                                break;
                            }
                            case "JAVA_HOME": {
                                idata.setVariable("javaHome", m.group(2));
                                break;
                            }
                            case "JAVA_OPTIONS": {
                                idata.setVariable("javaOptions", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_WATCHDOG": {
                                idata.setVariable("watchdogScript", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_HTTP_PORT": {
                                idata.setVariable("controllerHttpPort", m.group(2));
                                if (m.group(2).isEmpty()) break;
                                if (m.group(2).contains(":")) {
                                    String[] hostPortParts = m.group(2).split(":", 2);
                                    idata.setVariable("controllerPort", hostPortParts[1]);
                                    idata.setVariable("controllerHost", hostPortParts[0]);
                                    break;
                                }
                                idata.setVariable("controllerPort", m.group(2));
                                idata.setVariable("controllerHost", "");
                                break;
                            }
                            case "JS7_CONTROLLER_HTTPS_PORT": {
                                idata.setVariable("controllerHttpsPort", m.group(2));
                            }
                        }
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception p) {}
                    }
                }
            }
            if (envscript != null && Files.isReadable(envscript)) {
                System.out.println("Environment variables from " + envscript.toString() + " are reading.");
                try {
                    Pattern p = Pattern.compile("^(?:[ ]*[sS][eE][tT][ ]+)?([^=]+)=(.*)$");
                    Matcher m = null;
                    in = Files.newBufferedReader(envscript);
                    String str = "";
                    while ((str = in.readLine()) != null) {
                        m = p.matcher(str = str.trim());
                        if (!m.find()) continue;
                        switch (m.group(1)) {
                            case "JS7_CONTROLLER_ID": {
                                idata.setVariable("controllerId", m.group(2));
                                System.out.println("ControllerId = " + idata.getVariable("controllerId"));
                                break;
                            }
                            case "JS7_SERVICE_NAME_SUFFIX": {
                                idata.setVariable("serviceNameSuffix", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_DATA": {
                                idata.setVariable("APPDATA_PATH", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_USER": {
                                idata.setVariable("controllerUser", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_LOGS": 
                            case "JS7_CONTROLLER_LOG_DIR": {
                                idata.setVariable("logPath", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_PID_FILE_DIR": {
                                idata.setVariable("pidFilePath", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_PID_FILE_NAME": {
                                idata.setVariable("pidFileName", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_CONFIG_DIR": {
                                idata.setVariable("configPath", m.group(2));
                                break;
                            }
                            case "JAVA_HOME": {
                                idata.setVariable("javaHome", m.group(2));
                                break;
                            }
                            case "JAVA_OPTIONS": {
                                idata.setVariable("javaOptions", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_WATCHDOG": {
                                idata.setVariable("watchdogScript", m.group(2));
                                break;
                            }
                            case "JS7_CONTROLLER_HTTP_PORT": {
                                idata.setVariable("controllerHttpPort", m.group(2));
                                if (m.group(2).isEmpty()) break;
                                if (m.group(2).contains(":")) {
                                    String[] hostPortParts = m.group(2).split(":", 2);
                                    idata.setVariable("controllerPort", hostPortParts[1]);
                                    idata.setVariable("controllerHost", hostPortParts[0]);
                                    break;
                                }
                                idata.setVariable("controllerPort", m.group(2));
                                idata.setVariable("controllerHost", "");
                                break;
                            }
                            case "JS7_CONTROLLER_HTTPS_PORT": {
                                idata.setVariable("controllerHttpsPort", m.group(2));
                            }
                        }
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception p) {}
                    }
                }
            }
        } else if (this.agentMode && (envscript = installDir.resolve("bin/agent_" + idata.getVariable("agentPort") + scriptExt)) != null && Files.isReadable(envscript)) {
            System.out.println("Environment variables from " + envscript.toString() + " are reading.");
            try {
                Pattern p = Pattern.compile("^(?:[ ]*[sS][eE][tT][ ]+)?([^=]+)=(.*)$");
                Matcher m = null;
                in = Files.newBufferedReader(envscript);
                String str = "";
                while ((str = in.readLine()) != null) {
                    m = p.matcher(str = str.trim());
                    if (!m.find()) continue;
                    switch (m.group(1)) {
                        case "JS7_AGENT_DATA": {
                            idata.setVariable("APPDATA_PATH", m.group(2));
                            break;
                        }
                        case "JS7_AGENT_USER": {
                            idata.setVariable("schedulerUser", m.group(2));
                            break;
                        }
                        case "JS7_AGENT_LOGS": 
                        case "JS7_AGENT_LOG_DIR": {
                            idata.setVariable("logPath", m.group(2));
                            break;
                        }
                        case "JS7_AGENT_PID_FILE_DIR": {
                            idata.setVariable("pidFilePath", m.group(2));
                            break;
                        }
                        case "JS7_CONTROLLER_PID_FILE_NAME": {
                            idata.setVariable("pidFileName", m.group(2));
                            break;
                        }
                        case "JS7_AGENT_CONFIG_DIR": {
                            idata.setVariable("configPath", m.group(2));
                            break;
                        }
                        case "JS7_AGENT_WORK_DIR": {
                            idata.setVariable("workPath", m.group(2));
                            break;
                        }
                        case "JAVA_HOME": {
                            idata.setVariable("javaHome", m.group(2));
                            break;
                        }
                        case "JAVA_OPTIONS": {
                            idata.setVariable("javaOptions", m.group(2));
                            break;
                        }
                        case "JS7_AGENT_JOB_JAVA_OPTIONS": {
                            idata.setVariable("jobJavaOptions", m.group(2));
                            break;
                        }
                        case "JS7_AGENT_CLASSPATH_USER": {
                            idata.setVariable("javaClasspathUser", m.group(2));
                            break;
                        }
                        case "JS7_AGENT_WATCHDOG": {
                            idata.setVariable("watchdogScript", m.group(2));
                            break;
                        }
                        case "JS7_AGENT_HTTP_PORT": {
                            idata.setVariable("agentHttpPort", m.group(2));
                            if (m.group(2).isEmpty()) break;
                            if (m.group(2).contains(":")) {
                                String[] hostPortParts = m.group(2).split(":", 2);
                                idata.setVariable("agentPort", hostPortParts[1]);
                                idata.setVariable("agentHost", hostPortParts[0]);
                                break;
                            }
                            idata.setVariable("agentPort", m.group(2));
                            idata.setVariable("agentHost", "");
                            break;
                        }
                        case "JS7_AGENT_HTTPS_PORT": {
                            idata.setVariable("agentHttpsPort", m.group(2));
                        }
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private Path lookingForLastPreviousInstallation(Path installDir, InstallData idata) throws Exception {
        Path lastSubDir;
        block9: {
            long lastModified = 0L;
            lastSubDir = null;
            Path jsinstallInformation = null;
            List<Object> subDirsList = new ArrayList();
            this.numOfPrevInstallations = 0;
            idata.setVariable("numOfPrevInstallations", "0");
            idata.setAttribute("INSTALL_PATH", null);
            try {
                if (Files.isDirectory(installDir, new LinkOption[0])) {
                    if (this.numOfPrevInstallations == 0 && Files.isReadable(jsinstallInformation = installDir.resolve(this.installInformationName)) && Files.isRegularFile(jsinstallInformation, new LinkOption[0])) {
                        lastSubDir = installDir;
                        this.numOfPrevInstallations = 1;
                        if (this.controllerMode || this.updateMode) {
                            idata.setInstallPath(installDir.getParent().toString());
                            idata.setAttribute("INSTALL_PATH", installDir.getParent());
                            idata.setVariable("subDir", installDir.getFileName().toString());
                        }
                        idata.setVariable("numOfPrevInstallations", "1");
                        subDirsList.add(installDir);
                        idata.setAttribute("foundInstallations", subDirsList);
                    }
                    if (this.numOfPrevInstallations == 0) {
                        subDirsList = Files.find(installDir, 1, this.subDirFilter, new FileVisitOption[0]).collect(Collectors.toList());
                        this.numOfPrevInstallations = subDirsList.size();
                        idata.setAttribute("foundInstallations", subDirsList);
                        idata.setVariable("numOfPrevInstallations", this.numOfPrevInstallations + "");
                        if ((this.controllerMode || this.updateMode) && this.numOfPrevInstallations == 1) {
                            idata.setVariable("subDir", ((Path)subDirsList.get(0)).getFileName().toString());
                        }
                        for (Path path : subDirsList) {
                            if (this.updateMode) {
                                lastSubDir = path;
                                break;
                            }
                            long curLastModified = Files.getLastModifiedTime(path.resolve(this.installInformationName), new LinkOption[0]).toMillis();
                            if (lastModified >= curLastModified) continue;
                            lastModified = curLastModified;
                            lastSubDir = path;
                        }
                    }
                }
                System.out.println("numOfPrevInstallations = " + idata.getVariable("numOfPrevInstallations"));
            }
            catch (Exception e) {
                this.notFatalErrors.add(e.toString());
                if (!this.updateMode) break block9;
                throw e;
            }
        }
        return lastSubDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readPreviousInstallation(Path installDir) {
        Path installationinfo = installDir.resolve(this.installInformationName);
        ObjectInputStream oin = null;
        try {
            if (Files.isRegularFile(installationinfo, new LinkOption[0])) {
                System.out.println(installationinfo.toString() + " read.");
                oin = new ObjectInputStream(Files.newInputStream(installationinfo, new OpenOption[0]));
                oin.readObject();
                this.previousVars = (Properties)oin.readObject();
                boolean bl = true;
                return bl;
            }
            System.out.println(installationinfo.toString() + " not found.");
        }
        catch (Exception e) {
            this.notFatalErrors.add(e.toString());
        }
        finally {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private void setCurrentVars(Properties varList) throws Exception {
        List<String> exVars = Arrays.asList(this.exceptVars);
        for (String varName : varList.stringPropertyNames()) {
            if (this.defaultVars.containsKey(varName) && !exVars.contains(varName)) {
                if (this.previousVars.containsKey(varName)) {
                    varList.setProperty(varName, this.previousVars.getProperty(varName));
                } else {
                    varList.setProperty(varName, this.defaultVars.getProperty(varName));
                }
            }
            if (!varName.equals("databaseCreateTables")) continue;
            varList.setProperty(varName, "byInstaller");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readDefaultVars() throws Exception {
        ObjectInputStream objIn = null;
        try {
            InputStream in = InstallerBase.class.getResourceAsStream("/resources/vars");
            if (null == in) {
                throw new IOException("Resource /resources/vars not found.");
            }
            objIn = new ObjectInputStream(in);
            this.defaultVars = (Properties)objIn.readObject();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.notFatalErrors.add(e.toString());
            if (this.updateMode) {
                throw e;
            }
        }
        finally {
            if (objIn != null) {
                try {
                    objIn.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private void readingPrevInstallMessage(Path installDir, Path appDataDir) {
        System.out.println("Reading previous installation in " + installDir.toAbsolutePath().toString());
    }

    private void jocInstallData(InstallData idata) throws IOException, InterruptedException, RuntimeException, ParserConfigurationException, SAXException, XPathExpressionException {
        if (this.jocMode) {
            JettyJavaOptions jettyOpts = new JettyJavaOptions(idata);
            jettyOpts.read();
            idata.setVariable("jettyOptions", jettyOpts.getOptionsString());
            if (Install.isAutomatedInstallation.booleanValue()) {
                idata.setVariable("jettyOptionXmx", "");
                idata.setVariable("jettyOptionXms", "");
                idata.setVariable("jettyOptionXss", "");
                idata.setVariable("jettyOptXmx", "");
                idata.setVariable("jettyOptXms", "");
                idata.setVariable("jettyOptXss", "");
            } else {
                idata.setVariable("jettyOptionXmx", jettyOpts.getOptionXmx(idata.getVariable("jettyOptionXmx")));
                idata.setVariable("jettyOptionXms", jettyOpts.getOptionXms(idata.getVariable("jettyOptionXms")));
                idata.setVariable("jettyOptionXss", jettyOpts.getOptionXss(idata.getVariable("jettyOptionXss")));
                idata.setVariable("jettyOptXmx", "-Xmx" + idata.getVariable("jettyOptionXmx") + "MB");
                idata.setVariable("jettyOptXms", "-Xms" + idata.getVariable("jettyOptionXms") + "MB");
                idata.setVariable("jettyOptXss", "-Xss" + idata.getVariable("jettyOptionXss") + "KB");
            }
            Path jocPropertiesFile = (Path)idata.getAttribute("APPDATA_PATH");
            if (jocPropertiesFile != null && Files.exists(jocPropertiesFile = jocPropertiesFile.resolve("resources/joc/joc.properties"), new LinkOption[0])) {
                Properties p = new Properties();
                p.load(Files.newInputStream(jocPropertiesFile, new OpenOption[0]));
                idata.setVariable("jocClusterId", p.getProperty("cluster_id", idata.getVariable("jocClusterId")));
                idata.setVariable("jocTitle", p.getProperty("title", idata.getVariable("jocTitle")));
                idata.setVariable("ordering", p.getProperty("ordering", idata.getVariable("ordering")));
            }
        }
    }

    private void jocSettingsData(InstallData idata) throws IOException, InterruptedException, RuntimeException, ParserConfigurationException, SAXException, XPathExpressionException {
        Path jocPropertiesFile;
        if (this.jocMode && (jocPropertiesFile = (Path)idata.getAttribute("APPDATA_PATH")) != null && Files.exists(jocPropertiesFile = jocPropertiesFile.resolve("webapps/joc/WEB-INF/classes/joc-settings.properties"), new LinkOption[0])) {
            Properties p = new Properties();
            p.load(Files.newInputStream(jocPropertiesFile, new OpenOption[0]));
            idata.setVariable("prevAsApiServer", p.getProperty("as_api_server", "no"));
        }
    }

    private void updateInstallData(Path installDir, Path appDataDir, InstallData idata) throws IOException, InterruptedException, RuntimeException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.readingPrevInstallMessage(installDir, appDataDir);
        this.getSchedulerEnvs(installDir, idata);
    }

    private void setDbmsDefault(InstallData idata) {
        try {
            String dbms = idata.getVariable("databaseDbms");
            if (dbms != null && !dbms.isEmpty()) {
                idata.setVariable("databaseDbmsDefault", dbms);
                if (dbms.equals("h2")) {
                    idata.setVariable("databaseConfigurationMethod", "h2");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

